/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.listeners;

import org.eclipse.jpt.common.ui.internal.plugin.JptCommonUiPlugin;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.utility.internal.RunnableAdapter;
import org.eclipse.jpt.common.utility.internal.collection.SynchronizedQueue;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;

public class SWTListChangeListenerWrapper
implements ListChangeListener {
    private final ListChangeListener listener;
    private final SynchronizedQueue<ListEvent> events = new SynchronizedQueue();

    public SWTListChangeListenerWrapper(ListChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void itemsAdded(ListAddEvent event) {
        this.events.enqueue((Object)event);
        this.execute((Runnable)((Object)new ForwardEventsRunnable()));
    }

    public void itemsRemoved(ListRemoveEvent event) {
        this.events.enqueue((Object)event);
        this.execute((Runnable)((Object)new ForwardEventsRunnable()));
    }

    public void itemsMoved(ListMoveEvent event) {
        this.events.enqueue((Object)event);
        this.execute((Runnable)((Object)new ForwardEventsRunnable()));
    }

    public void itemsReplaced(ListReplaceEvent event) {
        this.events.enqueue((Object)event);
        this.execute((Runnable)((Object)new ForwardEventsRunnable()));
    }

    public void listCleared(ListClearEvent event) {
        this.events.enqueue((Object)event);
        this.execute((Runnable)((Object)new ForwardEventsRunnable()));
    }

    public void listChanged(ListChangeEvent event) {
        this.events.enqueue((Object)event);
        this.execute((Runnable)((Object)new ForwardEventsRunnable()));
    }

    void forwardEvents() {
        for (ListEvent event : this.events.drain()) {
            try {
                this.forwardEvent(event);
            }
            catch (RuntimeException ex) {
                JptCommonUiPlugin.instance().logError(ex);
            }
        }
    }

    private void forwardEvent(ListEvent event) {
        if (event instanceof ListAddEvent) {
            this.listener.itemsAdded((ListAddEvent)event);
        } else if (event instanceof ListRemoveEvent) {
            this.listener.itemsRemoved((ListRemoveEvent)event);
        } else if (event instanceof ListMoveEvent) {
            this.listener.itemsMoved((ListMoveEvent)event);
        } else if (event instanceof ListReplaceEvent) {
            this.listener.itemsReplaced((ListReplaceEvent)event);
        } else if (event instanceof ListClearEvent) {
            this.listener.listCleared((ListClearEvent)event);
        } else if (event instanceof ListChangeEvent) {
            this.listener.listChanged((ListChangeEvent)event);
        }
    }

    private void execute(Runnable r) {
        DisplayTools.execute(r);
    }

    public String toString() {
        return "SWT(" + this.listener + ')';
    }

    class ForwardEventsRunnable
    extends RunnableAdapter {
        ForwardEventsRunnable() {
        }

        public void run() {
            SWTListChangeListenerWrapper.this.forwardEvents();
        }
    }
}

