/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.VirtualNamedColumn;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaVirtualNamedColumn<PA extends NamedColumn.ParentAdapter, C extends NamedColumn>
extends AbstractJavaContextModel<JpaContextModel>
implements VirtualNamedColumn {
    protected final PA parentAdapter;
    protected String specifiedName;
    protected String defaultName;
    protected String columnDefinition;
    protected Table dbTable;

    protected AbstractJavaVirtualNamedColumn(PA parentAdapter) {
        super(parentAdapter.getColumnParent());
        this.parentAdapter = parentAdapter;
    }

    @Override
    public void update() {
        super.update();
        this.setSpecifiedName(this.buildSpecifiedName());
        this.setDefaultName(this.buildDefaultName());
        this.setColumnDefinition(this.buildColumnDefinition());
        this.setDbTable(this.buildDbTable());
    }

    public abstract C getOverriddenColumn();

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    protected void setSpecifiedName(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        return this.getOverriddenColumn().getSpecifiedName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected String buildDefaultName() {
        return this.parentAdapter.getDefaultColumnName(this);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    protected void setColumnDefinition(String columnDefinition) {
        String old = this.columnDefinition;
        this.columnDefinition = columnDefinition;
        this.firePropertyChanged("columnDefinition", old, columnDefinition);
    }

    protected String buildColumnDefinition() {
        return this.getOverriddenColumn().getColumnDefinition();
    }

    protected Column getDbColumn() {
        Table table = this.getDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getName());
    }

    @Override
    public Table getDbTable() {
        return this.dbTable;
    }

    protected void setDbTable(Table dbTable) {
        Table old = this.dbTable;
        this.dbTable = dbTable;
        this.firePropertyChanged("dbTable", old, dbTable);
    }

    protected Table buildDbTable() {
        return this.parentAdapter.resolveDbTable(this.getTableName());
    }

    @Override
    public String getTableName() {
        return this.parentAdapter.getDefaultTableName();
    }

    @Override
    public boolean isResolved() {
        return this.getDbColumn() != null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.buildValidator().validate(messages, reporter);
    }

    protected JpaValidator buildValidator() {
        return this.parentAdapter.buildColumnValidator(this);
    }

    @Override
    public TextRange getValidationTextRange() {
        return ((JpaContextModel)this.parent).getValidationTextRange();
    }

    @Override
    public TextRange getNameValidationTextRange() {
        return this.getValidationTextRange();
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    public void toString(StringBuilder sb) {
        String table = this.getTableName();
        if (table != null) {
            sb.append(table);
            sb.append('.');
        }
        sb.append(this.getName());
    }
}

