/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmBaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlContextModelFactory;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.NamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.NullOrmConverter;
import org.eclipse.jpt.jpa.core.resource.orm.Attributes;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlVersion;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmVersionMapping<X extends XmlVersion>
extends AbstractOrmAttributeMapping<X>
implements OrmVersionMapping {
    protected final OrmSpecifiedColumn column;
    protected OrmConverter converter;
    protected final OrmConverter nullConverter = new NullOrmConverter(this);
    protected static final OrmConverter.Adapter[] CONVERTER_ADAPTER_ARRAY = new OrmConverter.Adapter[]{OrmBaseTemporalConverter.BasicAdapter.instance()};
    protected static final Iterable<OrmConverter.Adapter> CONVERTER_ADAPTERS = IterableTools.iterable((Object[])CONVERTER_ADAPTER_ARRAY);

    protected AbstractOrmVersionMapping(OrmSpecifiedPersistentAttribute parent, X xmlMapping) {
        super(parent, xmlMapping);
        this.column = this.buildColumn();
        this.converter = this.buildConverter();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.column.synchronizeWithResourceModel();
        this.syncConverter();
    }

    @Override
    public void update() {
        super.update();
        this.column.update();
        this.converter.update();
    }

    @Override
    public OrmSpecifiedColumn getColumn() {
        return this.column;
    }

    protected OrmSpecifiedColumn buildColumn() {
        return this.getContextModelFactory().buildOrmColumn(this);
    }

    @Override
    public OrmConverter getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(Class<? extends Converter> converterType) {
        if (this.converter.getType() != converterType) {
            OrmConverter old = this.converter;
            this.converter = this.nullConverter;
            this.clearXmlConverterValues();
            OrmConverter.Adapter converterAdapter = this.getConverterAdapter(converterType);
            this.converter = this.buildConverter(converterAdapter);
            this.converter.initialize();
            this.firePropertyChanged("converter", old, this.converter);
        }
    }

    protected OrmConverter buildConverter(OrmConverter.Adapter converterAdapter) {
        return converterAdapter != null ? converterAdapter.buildNewConverter(this, this.getContextModelFactory()) : this.nullConverter;
    }

    protected void setConverter_(OrmConverter converter) {
        OrmConverter old = this.converter;
        this.converter = converter;
        this.firePropertyChanged("converter", old, converter);
    }

    protected void clearXmlConverterValues() {
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            adapter.clearXmlValue(this.xmlAttributeMapping);
        }
    }

    protected OrmConverter buildConverter() {
        OrmXmlContextModelFactory factory = this.getContextModelFactory();
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            OrmConverter ormConverter = adapter.buildConverter(this, factory);
            if (ormConverter == null) continue;
            return ormConverter;
        }
        return this.nullConverter;
    }

    protected void syncConverter() {
        OrmConverter.Adapter adapter = this.getXmlConverterAdapter();
        if (adapter == null) {
            if (this.converter.getType() != null) {
                this.setConverter_(this.nullConverter);
            }
        } else if (this.converter.getType() == adapter.getConverterType()) {
            this.converter.synchronizeWithResourceModel();
        } else {
            this.setConverter_(adapter.buildNewConverter(this, this.getContextModelFactory()));
        }
    }

    protected OrmConverter.Adapter getXmlConverterAdapter() {
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            if (!adapter.isActive(this.xmlAttributeMapping)) continue;
            return adapter;
        }
        return null;
    }

    protected OrmConverter.Adapter getConverterAdapter(Class<? extends Converter> converterType) {
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter.getConverterType() != converterType) continue;
            return adapter;
        }
        return null;
    }

    protected Iterable<OrmConverter.Adapter> getConverterAdapters() {
        return CONVERTER_ADAPTERS;
    }

    @Override
    public String getKey() {
        return "version";
    }

    @Override
    public int getXmlSequence() {
        return 30;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmVersionMapping(this);
    }

    @Override
    protected void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        super.initializeFromOrmColumnMapping(oldMapping);
        this.column.initializeFrom(oldMapping.getColumn());
    }

    @Override
    public void addXmlAttributeMappingTo(Attributes xmlAttributes) {
        xmlAttributes.getVersions().add((Object)((XmlVersion)this.xmlAttributeMapping));
    }

    @Override
    public void removeXmlAttributeMappingFrom(Attributes xmlAttributes) {
        xmlAttributes.getVersions().remove((Object)this.xmlAttributeMapping);
    }

    @Override
    public JpaContextModel getColumnParent() {
        return this;
    }

    @Override
    public String getDefaultColumnName(NamedColumn col) {
        return this.name;
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return this.getTypeMapping().resolveDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.getTypeMapping().tableNameIsInvalid(tableName);
    }

    @Override
    public Iterable<String> getCandidateTableNames() {
        return this.getTypeMapping().getAllAssociatedTableNames();
    }

    @Override
    public XmlColumn getXmlColumn() {
        return ((XmlVersion)this.xmlAttributeMapping).getColumn();
    }

    @Override
    public XmlColumn buildXmlColumn() {
        XmlColumn xmlColumn = OrmFactory.eINSTANCE.createXmlColumn();
        ((XmlVersion)this.xmlAttributeMapping).setColumn(xmlColumn);
        return xmlColumn;
    }

    @Override
    public void removeXmlColumn() {
        ((XmlVersion)this.xmlAttributeMapping).setColumn(null);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.column.validate(messages, reporter);
        this.converter.validate(messages, reporter);
        this.validateAttributeType(messages);
    }

    protected void validateAttributeType(List<IMessage> messages) {
        if (!ArrayTools.contains((Object[])SUPPORTED_TYPE_NAMES, (Object)this.getFullyQualifiedAttributeType())) {
            messages.add(this.buildValidationMessage(this.getNameTextRange(), JptJpaCoreValidationMessages.PERSISTENT_ATTRIBUTE_INVALID_VERSION_MAPPING_TYPE, this.getName()));
        }
    }

    @Override
    public JpaValidator buildColumnValidator(NamedColumn col) {
        return new NamedColumnValidator((PersistentAttribute)this.getPersistentAttribute(), (BaseColumn)col, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.column.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.converter.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return null;
    }
}

