/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTemporalConverterValidator
implements JpaValidator {
    protected final BaseTemporalConverter converter;

    protected AbstractTemporalConverterValidator(BaseTemporalConverter converter) {
        this.converter = converter;
    }

    protected AttributeMapping getAttributeMapping() {
        return this.converter.getParent();
    }

    protected SpecifiedPersistentAttribute getPersistentAttribute() {
        return this.getAttributeMapping().getPersistentAttribute();
    }

    @Override
    public boolean validate(List<IMessage> messages, IReporter reporter) {
        return this.validateAttributeTypeWithTemporal(messages);
    }

    protected boolean validateAttributeTypeWithTemporal(List<IMessage> messages) {
        String typeName = this.getTypeName();
        if (typeName == null) {
            return true;
        }
        if (!ArrayTools.contains((Object[])BaseTemporalConverter.TEMPORAL_MAPPING_SUPPORTED_TYPES, (Object)typeName)) {
            messages.add(this.buildInvalidTemporalMappingTypeMessage());
            return false;
        }
        return true;
    }

    protected abstract String getTypeName();

    protected IMessage buildInvalidTemporalMappingTypeMessage() {
        return this.getPersistentAttribute().isVirtual() ? this.buildVirtualAttributeInvalidTemporalMappingTypeMessage() : this.buildInvalidTemporalMappingTypeMessage_();
    }

    protected IMessage buildInvalidTemporalMappingTypeMessage_() {
        return ValidationMessageTools.buildValidationMessage((IResource)this.converter.getResource(), (TextRange)this.converter.getValidationTextRange(), (ValidationMessage)this.getInvalidTemporalMappingTypeMessage());
    }

    protected abstract ValidationMessage getInvalidTemporalMappingTypeMessage();

    protected IMessage buildVirtualAttributeInvalidTemporalMappingTypeMessage() {
        return ValidationMessageTools.buildValidationMessage((IResource)this.converter.getResource(), (TextRange)this.getPersistentAttribute().getValidationTextRange(), (ValidationMessage)this.getVirtualAttributeInvalidTemporalMappingTypeMessage(), (Object[])new Object[]{this.getPersistentAttribute().getName()});
    }

    protected abstract ValidationMessage getVirtualAttributeInvalidTemporalMappingTypeMessage();
}

