/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.OrderColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.java.GenericJavaOrderColumn2_0;
import org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.OrderColumnAnnotationDefinition2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedOrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOrderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaSpecifiedOrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OrderColumnAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.OrderByAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaOrderable
extends AbstractJavaContextModel<JavaAttributeMapping>
implements JavaOrderable2_0 {
    protected String specifiedOrderBy = this.buildSpecifiedOrderBy();
    protected boolean noOrdering = this.buildNoOrdering();
    protected boolean pkOrdering = this.buildPkOrdering();
    protected boolean customOrdering = this.buildCustomOrdering();
    protected OrderColumnAnnotation2_0 nullOrderColumnAnnotation;
    protected final JavaOrderable2_0.ParentAdapter parentAdapter;
    protected boolean orderColumnOrdering = false;
    protected final JavaSpecifiedOrderColumn2_0 orderColumn;

    public GenericJavaOrderable(JavaAttributeMapping parent) {
        this(new JavaOrderable2_0.ParentAdapter.Null(parent));
    }

    public GenericJavaOrderable(JavaOrderable2_0.ParentAdapter parentAdapter) {
        super((JavaAttributeMapping)parentAdapter.getOrderableParent());
        this.parentAdapter = parentAdapter;
        this.orderColumnOrdering = this.buildOrderColumnOrdering();
        this.orderColumn = this.buildOrderColumn();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedOrderBy_(this.buildSpecifiedOrderBy());
        this.setNoOrdering_(this.buildNoOrdering());
        this.setPkOrdering_(this.buildPkOrdering());
        this.setCustomOrdering_(this.buildCustomOrdering());
        this.setOrderColumnOrdering_(this.buildOrderColumnOrdering());
        this.orderColumn.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.orderColumn.update();
    }

    @Override
    public String getSpecifiedOrderBy() {
        return this.specifiedOrderBy;
    }

    @Override
    public void setSpecifiedOrderBy(String orderBy) {
        if (orderBy != null) {
            this.removeOrderColumnAnnotation();
            this.getOrderByAnnotationForUpdate().setValue(orderBy);
            this.setSpecifiedOrderBy_(orderBy);
            this.setNoOrdering_(false);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(true);
            this.setOrderColumnOrdering_(false);
        } else {
            this.setNoOrdering(true);
        }
    }

    protected void setSpecifiedOrderBy_(String orderBy) {
        String old = this.specifiedOrderBy;
        this.specifiedOrderBy = orderBy;
        this.firePropertyChanged("specifiedOrderBy", old, orderBy);
    }

    protected String buildSpecifiedOrderBy() {
        if (this.orderColumnAnnotationIsPresent()) {
            return null;
        }
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        return orderByAnnotation == null ? null : orderByAnnotation.getValue();
    }

    @Override
    public boolean isNoOrdering() {
        return this.noOrdering;
    }

    @Override
    public void setNoOrdering(boolean noOrdering) {
        if (noOrdering) {
            this.removeOrderColumnAnnotation();
            if (this.getOrderByAnnotation() != null) {
                this.removeOrderByAnnotation();
            }
            this.setSpecifiedOrderBy_(null);
            this.setNoOrdering_(true);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
            this.setOrderColumnOrdering_(false);
        } else {
            this.setPkOrdering(true);
        }
    }

    protected void setNoOrdering_(boolean noOrdering) {
        boolean old = this.noOrdering;
        this.noOrdering = noOrdering;
        this.firePropertyChanged("noOrdering", old, noOrdering);
    }

    protected boolean buildNoOrdering() {
        return this.isJpa2_0Compatible() ? this.buildNoOrdering2_0() : this.buildNoOrdering1_0();
    }

    protected boolean buildNoOrdering2_0() {
        boolean orderColumnPresent;
        boolean orderByMissing = this.getOrderByAnnotation() == null;
        boolean orderByPresent = !orderByMissing;
        boolean orderColumnMissing = this.getOrderColumnAnnotation() == null;
        boolean bl = orderColumnPresent = !orderColumnMissing;
        return orderByMissing && orderColumnMissing || orderByPresent && orderColumnPresent;
    }

    protected boolean buildNoOrdering1_0() {
        return this.getOrderByAnnotation() == null;
    }

    @Override
    public boolean isPkOrdering() {
        return this.pkOrdering;
    }

    @Override
    public void setPkOrdering(boolean pkOrdering) {
        if (pkOrdering) {
            this.removeOrderColumnAnnotation();
            OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
            if (orderByAnnotation == null) {
                this.addOrderByAnnotation();
            } else {
                orderByAnnotation.setValue(null);
            }
            this.setSpecifiedOrderBy_(null);
            this.setNoOrdering_(false);
            this.setPkOrdering_(true);
            this.setCustomOrdering_(false);
            this.setOrderColumnOrdering_(false);
        } else {
            this.setNoOrdering(true);
        }
    }

    protected void setPkOrdering_(boolean pkOrdering) {
        boolean old = this.pkOrdering;
        this.pkOrdering = pkOrdering;
        this.firePropertyChanged("pkOrdering", old, pkOrdering);
    }

    protected boolean buildPkOrdering() {
        if (this.orderColumnAnnotationIsPresent()) {
            return false;
        }
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        return orderByAnnotation != null && orderByAnnotation.getValue() == null;
    }

    @Override
    public boolean isCustomOrdering() {
        return this.customOrdering;
    }

    @Override
    public void setCustomOrdering(boolean customOrdering) {
        if (customOrdering) {
            this.setSpecifiedOrderBy("");
        } else {
            this.setNoOrdering(true);
        }
    }

    protected void setCustomOrdering_(boolean customOrdering) {
        boolean old = this.customOrdering;
        this.customOrdering = customOrdering;
        this.firePropertyChanged("customOrdering", old, customOrdering);
    }

    protected boolean buildCustomOrdering() {
        if (this.orderColumnAnnotationIsPresent()) {
            return false;
        }
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        return orderByAnnotation != null && orderByAnnotation.getValue() != null;
    }

    @Override
    public boolean isOrderColumnOrdering() {
        return this.orderColumnOrdering;
    }

    @Override
    public void setOrderColumnOrdering(boolean orderColumnOrdering) {
        if (orderColumnOrdering) {
            if (this.getOrderColumnAnnotation() == null) {
                this.addOrderColumnAnnotation();
            }
            if (this.getOrderByAnnotation() != null) {
                this.removeOrderByAnnotation();
            }
            this.setSpecifiedOrderBy_(null);
            this.setNoOrdering_(false);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
            this.setOrderColumnOrdering_(true);
        } else {
            this.setNoOrdering(true);
        }
    }

    protected void setOrderColumnOrdering_(boolean orderColumnOrdering) {
        boolean old = this.orderColumnOrdering;
        this.orderColumnOrdering = orderColumnOrdering;
        this.firePropertyChanged("orderColumnOrdering", old, orderColumnOrdering);
    }

    protected boolean buildOrderColumnOrdering() {
        return this.orderColumnAnnotationIsPresent() && this.getOrderByAnnotation() == null;
    }

    @Override
    public JavaSpecifiedOrderColumn2_0 getOrderColumn() {
        return this.orderColumn;
    }

    protected JavaSpecifiedOrderColumn2_0 buildOrderColumn() {
        OrderColumnParentAdapter columnParentAdapter = new OrderColumnParentAdapter();
        return this.isJpa2_0Compatible() ? this.getJpaFactory2_0().buildJavaOrderColumn(columnParentAdapter) : new GenericJavaOrderColumn2_0(columnParentAdapter);
    }

    protected OrderByAnnotation getOrderByAnnotation() {
        return (OrderByAnnotation)this.getResourceAttribute().getAnnotation("javax.persistence.OrderBy");
    }

    protected OrderByAnnotation getOrderByAnnotationForUpdate() {
        OrderByAnnotation annotation = this.getOrderByAnnotation();
        return annotation != null ? annotation : this.addOrderByAnnotation();
    }

    protected OrderByAnnotation addOrderByAnnotation() {
        return (OrderByAnnotation)this.getResourceAttribute().addAnnotation("javax.persistence.OrderBy");
    }

    protected void removeOrderByAnnotation() {
        this.getResourceAttribute().removeAnnotation("javax.persistence.OrderBy");
    }

    protected OrderColumnAnnotation2_0 getOrderColumnAnnotation() {
        return (OrderColumnAnnotation2_0)this.getResourceAttribute().getAnnotation("javax.persistence.OrderColumn");
    }

    protected boolean orderColumnAnnotationIsPresent() {
        return this.isJpa2_0Compatible() && this.getOrderColumnAnnotation() != null;
    }

    protected OrderColumnAnnotation2_0 addOrderColumnAnnotation() {
        return (OrderColumnAnnotation2_0)this.getResourceAttribute().addAnnotation("javax.persistence.OrderColumn");
    }

    protected void removeOrderColumnAnnotation() {
        if (this.orderColumnAnnotationIsPresent()) {
            this.removeOrderColumnAnnotation_();
        }
    }

    protected void removeOrderColumnAnnotation_() {
        this.getResourceAttribute().removeAnnotation("javax.persistence.OrderColumn");
    }

    public OrderColumnAnnotation2_0 getNonNullOrderColumnAnnotation() {
        return this.isJpa2_0Compatible() ? (OrderColumnAnnotation2_0)this.getResourceAttribute().getNonNullAnnotation("javax.persistence.OrderColumn") : this.getNullOrderColumnAnnotation();
    }

    protected OrderColumnAnnotation2_0 getNullOrderColumnAnnotation() {
        if (this.nullOrderColumnAnnotation == null) {
            this.nullOrderColumnAnnotation = this.buildNullOrderColumnAnnotation();
        }
        return this.nullOrderColumnAnnotation;
    }

    protected OrderColumnAnnotation2_0 buildNullOrderColumnAnnotation() {
        return (OrderColumnAnnotation2_0)OrderColumnAnnotationDefinition2_0.instance().buildNullAnnotation((JavaResourceAnnotatedElement)this.getResourceAttribute());
    }

    protected JavaAttributeMapping getAttributeMapping() {
        return (JavaAttributeMapping)this.parent;
    }

    protected JavaSpecifiedPersistentAttribute getPersistentAttribute() {
        return this.getAttributeMapping().getPersistentAttribute();
    }

    @Override
    public JavaResourceAttribute getResourceAttribute() {
        return this.getPersistentAttribute().getResourceAttribute();
    }

    @Override
    public String getDefaultTableName() {
        return this.parentAdapter.getTableName();
    }

    protected Table resolveDbTable(String tableName) {
        return this.parentAdapter.resolveDbTable(tableName);
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return this.orderColumn.getCompletionProposals(pos);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getOrderByAnnotationTextRange();
        return textRange != null ? textRange : this.getAttributeMapping().getValidationTextRange();
    }

    protected TextRange getOrderByAnnotationTextRange() {
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        return orderByAnnotation == null ? null : orderByAnnotation.getTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.orderColumnAnnotationIsPresent() && this.getOrderByAnnotation() != null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(this.buildValidationMessage((JpaModel)this.getAttributeMapping(), this.getPersistentAttribute().getValidationTextRange(), JptJpaCoreValidationMessages.ORDER_COLUMN_AND_ORDER_BY_BOTH_SPECIFIED, this.getPersistentAttribute().getName()));
            } else {
                messages.add(this.buildValidationMessage((JpaModel)this.getAttributeMapping(), this.getOrderByAnnotationTextRange(), JptJpaCoreValidationMessages.ORDER_COLUMN_AND_ORDER_BY_BOTH_SPECIFIED, this.getPersistentAttribute().getName()));
            }
        }
        if (this.orderColumnOrdering) {
            this.orderColumn.validate(messages, reporter);
        }
    }

    public class OrderColumnParentAdapter
    implements JavaSpecifiedOrderColumn2_0.ParentAdapter {
        public JavaOrderable2_0 getColumnParent() {
            return GenericJavaOrderable.this;
        }

        public String getDefaultTableName() {
            return GenericJavaOrderable.this.getDefaultTableName();
        }

        public Table resolveDbTable(String tableName) {
            return GenericJavaOrderable.this.resolveDbTable(tableName);
        }

        public String getDefaultColumnName(NamedColumn column) {
            return String.valueOf(this.getPersistentAttribute().getName()) + "_ORDER";
        }

        public TextRange getValidationTextRange() {
            return GenericJavaOrderable.this.getValidationTextRange();
        }

        public JpaValidator buildColumnValidator(NamedColumn column) {
            return new OrderColumnValidator((PersistentAttribute)this.getPersistentAttribute(), (SpecifiedOrderColumn2_0)column);
        }

        public OrderColumnAnnotation2_0 getColumnAnnotation() {
            return GenericJavaOrderable.this.getNonNullOrderColumnAnnotation();
        }

        public void removeColumnAnnotation() {
            GenericJavaOrderable.this.removeOrderColumnAnnotation_();
        }

        protected JavaSpecifiedPersistentAttribute getPersistentAttribute() {
            return GenericJavaOrderable.this.getPersistentAttribute();
        }
    }
}

