/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedNativeQuery;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.java.JavaNamedNativeQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmNamedNativeQuery;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmQuery;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.core.resource.orm.XmlNamedNativeQuery;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmNamedNativeQuery
extends AbstractOrmQuery<XmlNamedNativeQuery>
implements OrmNamedNativeQuery {
    protected String query;
    protected String resultClass;
    protected String fullyQualifiedResultClass;
    protected String resultSetMapping;

    public GenericOrmNamedNativeQuery(JpaContextModel parent, XmlNamedNativeQuery xmlNamedNativeQuery) {
        super(parent, xmlNamedNativeQuery);
        this.query = ((XmlNamedNativeQuery)this.xmlQuery).getQuery();
        this.resultClass = xmlNamedNativeQuery.getResultClass();
        this.resultSetMapping = xmlNamedNativeQuery.getResultSetMapping();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setQuery_(((XmlNamedNativeQuery)this.xmlQuery).getQuery());
        this.setResultClass_(((XmlNamedNativeQuery)this.xmlQuery).getResultClass());
        this.setResultSetMapping_(((XmlNamedNativeQuery)this.xmlQuery).getResultSetMapping());
    }

    @Override
    public void update() {
        super.update();
        this.setFullyQualifiedResultClass(this.buildFullyQualifiedResultClass());
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        this.setQuery_(query);
        ((XmlNamedNativeQuery)this.xmlQuery).setQuery(query);
    }

    protected void setQuery_(String query) {
        String old = this.query;
        this.query = query;
        this.firePropertyChanged("query", old, query);
    }

    @Override
    public String getResultClass() {
        return this.resultClass;
    }

    @Override
    public void setResultClass(String resultClass) {
        this.setResultClass_(resultClass);
        ((XmlNamedNativeQuery)this.xmlQuery).setResultClass(resultClass);
    }

    protected void setResultClass_(String resultClass) {
        String old = this.resultClass;
        this.resultClass = resultClass;
        this.firePropertyChanged("resultClass", old, resultClass);
    }

    @Override
    public String getFullyQualifiedResultClass() {
        return this.fullyQualifiedResultClass;
    }

    protected void setFullyQualifiedResultClass(String resultClass) {
        String old = this.fullyQualifiedResultClass;
        this.fullyQualifiedResultClass = resultClass;
        this.firePropertyChanged("fullyQualifiedResultClass", old, resultClass);
    }

    protected String buildFullyQualifiedResultClass() {
        return this.getMappingFileRoot().qualify(this.resultClass);
    }

    @Override
    public char getResultClassEnclosingTypeSeparator() {
        return '$';
    }

    @Override
    public String getResultSetMapping() {
        return this.resultSetMapping;
    }

    @Override
    public void setResultSetMapping(String resultSetMapping) {
        this.setResultSetMapping_(resultSetMapping);
        ((XmlNamedNativeQuery)this.xmlQuery).setResultSetMapping(resultSetMapping);
    }

    protected void setResultSetMapping_(String resultSetMapping) {
        String old = this.resultSetMapping;
        this.resultSetMapping = resultSetMapping;
        this.firePropertyChanged("resultSetMapping", old, resultSetMapping);
    }

    @Override
    public void convertFrom(JavaNamedNativeQuery javaQuery) {
        super.convertFrom(javaQuery);
        this.setQuery(javaQuery.getQuery());
        this.setResultClass(javaQuery.getResultClass());
        this.setResultSetMapping(javaQuery.getResultSetMapping());
    }

    @Override
    public void validate(JpaJpqlQueryHelper queryHelper, List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateQuery(queryHelper, messages, reporter);
    }

    protected void validateQuery(JpaJpqlQueryHelper queryHelper, List<IMessage> messages, IReporter reporter) {
        if (StringTools.isBlank((String)this.query)) {
            messages.add(this.buildValidationMessage(this.getNameTextRange(), JptJpaCoreValidationMessages.QUERY_STATEMENT_UNDEFINED, this.name));
        }
    }

    @Override
    protected boolean isEquivalentTo(Query other) {
        return super.isEquivalentTo(other) && this.isEquivalentTo((NamedNativeQuery)other);
    }

    protected boolean isEquivalentTo(NamedNativeQuery other) {
        return ObjectTools.equals((Object)this.query, (Object)other.getQuery()) && ObjectTools.equals((Object)this.resultClass, (Object)other.getResultClass()) && ObjectTools.equals((Object)this.resultSetMapping, (Object)other.getResultSetMapping());
    }

    public Class<NamedNativeQuery> getType() {
        return NamedNativeQuery.class;
    }
}

