/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.persistence;

import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextModel;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperty;
import org.eclipse.text.edits.ReplaceEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPersistenceUnitProperty
extends AbstractPersistenceXmlContextModel<PersistenceUnit>
implements PersistenceUnit.Property {
    protected final XmlProperty xmlProperty;
    protected String name;
    protected String value;

    public GenericPersistenceUnitProperty(PersistenceUnit parent, XmlProperty xmlProperty) {
        super(parent);
        this.xmlProperty = xmlProperty;
        this.name = xmlProperty.getName();
        this.value = xmlProperty.getValue();
    }

    @Override
    public XmlProperty getXmlProperty() {
        return this.xmlProperty;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.xmlProperty.getName());
        this.setValue_(this.xmlProperty.getValue());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName_(name);
        this.xmlProperty.setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        if (this.firePropertyChanged("name", old, name)) {
            this.getPersistenceUnit().propertyNameChanged(old, name, this.value);
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.setValue_(value);
        this.xmlProperty.setValue(value);
    }

    protected void setValue_(String value) {
        String old = this.value;
        this.value = value;
        if (this.firePropertyChanged("value", old, value)) {
            this.getPersistenceUnit().propertyValueChanged(this.name, value);
        }
    }

    protected String getValuePackageName() {
        return this.value == null ? null : this.getValuePackageName_();
    }

    protected String getValuePackageName_() {
        int lastPeriod = this.value.lastIndexOf(46);
        return lastPeriod == -1 ? null : this.value.substring(0, lastPeriod);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlProperty.getValidationTextRange();
        return textRange != null ? textRange : this.getPersistenceUnit().getValidationTextRange();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return ObjectTools.equals((Object)this.value, (Object)originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.createRenameTypeEdit(originalType, newName)) : IterableTools.emptyIterable();
    }

    protected ReplaceEdit createRenameTypeEdit(IType originalType, String newName) {
        return this.xmlProperty.createRenameTypeEdit(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return ObjectTools.equals((Object)this.value, (Object)originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.createRenamePackageEdit(newPackage.getElementName())) : IterableTools.emptyIterable();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return ObjectTools.equals((Object)this.getValuePackageName(), (Object)originalPackage.getElementName()) ? IterableTools.singletonIterable((Object)this.createRenamePackageEdit(newName)) : IterableTools.emptyIterable();
    }

    protected ReplaceEdit createRenamePackageEdit(String newName) {
        return this.xmlProperty.createRenamePackageEdit(newName);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
        sb.append(" = ");
        sb.append(this.value);
    }
}

