/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.persistence;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.utility.EmptyTextRange;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.JpaContextModelRoot;
import org.eclipse.jpt.jpa.core.context.XmlFile;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextModel;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.Persistence2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceXml2_0;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPersistenceXml
extends AbstractPersistenceXmlContextModel<JpaContextModelRoot>
implements PersistenceXml2_0 {
    protected final JptXmlResource xmlResource;
    protected JptResourceType resourceType;
    protected Persistence root;

    public GenericPersistenceXml(JpaContextModelRoot parent, JptXmlResource xmlResource) {
        super(parent);
        this.checkXmlResource(xmlResource);
        this.xmlResource = xmlResource;
        this.resourceType = xmlResource.getResourceType();
        XmlPersistence xmlPersistence = (XmlPersistence)xmlResource.getRootObject();
        if (xmlPersistence != null) {
            this.root = this.buildRoot(xmlPersistence);
        }
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncPersistence();
    }

    protected void syncPersistence() {
        this.syncPersistence(true);
    }

    @Override
    public void update() {
        this.updatePersistence();
    }

    protected void updatePersistence() {
        this.syncPersistence(false);
    }

    protected void syncPersistence(boolean sync) {
        XmlPersistence oldXmlPersistence = this.root == null ? null : this.root.getXmlPersistence();
        XmlPersistence newXmlPersistence = (XmlPersistence)this.xmlResource.getRootObject();
        JptResourceType newResourceType = this.xmlResource.getResourceType();
        if ((oldXmlPersistence != newXmlPersistence || newXmlPersistence == null || this.valuesAreDifferent(this.resourceType, newResourceType)) && this.root != null) {
            this.root.dispose();
            this.setRoot(null);
        }
        this.resourceType = newResourceType;
        if (newXmlPersistence != null) {
            if (this.root == null) {
                this.setRoot(this.buildRoot(newXmlPersistence));
            } else if (sync) {
                this.root.synchronizeWithResourceModel();
            } else {
                this.root.update();
            }
        }
    }

    @Override
    public Persistence getRoot() {
        return this.root;
    }

    protected void setRoot(Persistence persistence) {
        Persistence old = this.root;
        this.root = persistence;
        this.firePropertyChanged("root", old, persistence);
    }

    protected Persistence buildRoot(XmlPersistence xmlPersistence) {
        return this.getContextModelFactory().buildPersistence(this, xmlPersistence);
    }

    protected void checkXmlResource(JptXmlResource resource) {
        if (resource == null) {
            throw new NullPointerException();
        }
        if (!resource.getContentType().isKindOf(XmlPersistence.CONTENT_TYPE)) {
            throw new IllegalArgumentException("Content type is not 'persistence': " + resource);
        }
    }

    @Override
    public JptXmlResource getXmlResource() {
        return this.xmlResource;
    }

    @Override
    public IResource getResource() {
        return this.xmlResource.getFile();
    }

    @Override
    public JptResourceType getResourceType() {
        return this.xmlResource.getResourceType();
    }

    protected JpaFile getJpaFile() {
        return this.getJpaFile(this.xmlResource.getFile());
    }

    @Override
    public boolean isLatestSupportedVersion() {
        return XmlFile.XmlFile_.isLatestSupportedVersion(this);
    }

    @Override
    public boolean isGenericMappingFile() {
        return false;
    }

    @Override
    public void addRootStructureNodesTo(JpaFile jpaFile, Collection<JpaStructureNode> rootStructureNodes) {
        if (this.root != null) {
            this.root.addRootStructureNodesTo(jpaFile, rootStructureNodes);
        }
    }

    @Override
    public void dispose() {
        if (this.root != null) {
            this.root.dispose();
        }
    }

    @Override
    public void initializeMetamodel() {
        if (this.root != null) {
            ((Persistence2_0)this.root).initializeMetamodel();
        }
    }

    @Override
    public IStatus synchronizeMetamodel(IProgressMonitor monitor) {
        return this.root != null ? ((Persistence2_0)this.root).synchronizeMetamodel(monitor) : Status.OK_STATUS;
    }

    @Override
    public void disposeMetamodel() {
        if (this.root != null) {
            ((Persistence2_0)this.root).disposeMetamodel();
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.root == null) {
            messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.PERSISTENCE_XML_INVALID_CONTENT));
        } else {
            this.root.validate(messages, reporter);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return EmptyTextRange.instance();
    }
}

