/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.caching;

import java.util.Collection;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCacheType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCaching;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkCacheDefaultsComposite<T extends EclipseLinkCaching>
extends Pane<T> {
    public EclipseLinkCacheDefaultsComposite(Pane<T> subjectHolder, Composite container) {
        super(subjectHolder, container);
    }

    protected Composite addComposite(Composite parent) {
        return this.addTitledGroup(parent, JptJpaEclipseLinkUiMessages.CACHE_DEFAULTS_COMPOSITE_GROUP_TITLE, 2, null);
    }

    protected void initializeLayout(Composite parent) {
        this.addLabel(parent, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CACHING_TAB_DEFAULT_CACHE_TYPE_LABEL);
        this.buildDefaultCacheTypeCombo(parent);
        this.addLabel(parent, JptJpaEclipseLinkUiMessages.DEFAULT_CACHE_SIZE_COMPOSITE_DEFAULT_CACHE_SIZE);
        this.addDefaultCacheSizeCombo(parent);
        TriStateCheckBox sharedCacheCheckBox = this.addTriStateCheckBoxWithDefault(parent, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CACHING_TAB_SHARED_CACHE_DEFAULT_LABEL, this.buildDefaultSharedCacheHolder(), this.buildDefaultSharedCacheStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_CACHING_DEFAULT_SHARED);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        sharedCacheCheckBox.getCheckBox().setLayoutData((Object)gridData);
    }

    protected EnumFormComboViewer<EclipseLinkCaching, EclipseLinkCacheType> buildDefaultCacheTypeCombo(Composite container) {
        return new EnumFormComboViewer<EclipseLinkCaching, EclipseLinkCacheType>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("cacheTypeDefault");
            }

            protected EclipseLinkCacheType[] getChoices() {
                return EclipseLinkCacheType.values();
            }

            protected boolean sortChoices() {
                return false;
            }

            protected EclipseLinkCacheType getDefaultValue() {
                return ((EclipseLinkCaching)this.getSubject()).getDefaultCacheTypeDefault();
            }

            protected String displayString(EclipseLinkCacheType value) {
                switch (value) {
                    case full: {
                        return JptJpaEclipseLinkUiMessages.CACHE_TYPE_COMPOSITE_FULL;
                    }
                    case weak: {
                        return JptJpaEclipseLinkUiMessages.CACHE_TYPE_COMPOSITE_WEAK;
                    }
                    case soft: {
                        return JptJpaEclipseLinkUiMessages.CACHE_TYPE_COMPOSITE_SOFT;
                    }
                    case soft_weak: {
                        return JptJpaEclipseLinkUiMessages.CACHE_TYPE_COMPOSITE_SOFT_WEAK;
                    }
                    case hard_weak: {
                        return JptJpaEclipseLinkUiMessages.CACHE_TYPE_COMPOSITE_HARD_WEAK;
                    }
                    case none: {
                        return JptJpaEclipseLinkUiMessages.CACHE_TYPE_COMPOSITE_NONE;
                    }
                }
                throw new IllegalStateException();
            }

            protected EclipseLinkCacheType getValue() {
                return ((EclipseLinkCaching)this.getSubject()).getCacheTypeDefault();
            }

            protected void setValue(EclipseLinkCacheType value) {
                ((EclipseLinkCaching)this.getSubject()).setCacheTypeDefault(value);
            }

            protected String getHelpId() {
                return EclipseLinkHelpContextIds.PERSISTENCE_CACHING_DEFAULT_TYPE;
            }
        };
    }

    protected void addDefaultCacheSizeCombo(Composite container) {
        new IntegerCombo<EclipseLinkCaching>((Pane)this, container){

            protected String getHelpId() {
                return EclipseLinkHelpContextIds.PERSISTENCE_CACHING_DEFAULT_SIZE;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<EclipseLinkCaching, Integer>(this.getSubjectHolder()){

                    protected Integer buildValue_() {
                        return ((EclipseLinkCaching)this.subject).getDefaultCacheSizeDefault();
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<EclipseLinkCaching, Integer>(this.getSubjectHolder(), new String[]{"cacheSizeDefault"}){

                    protected Integer buildValue_() {
                        return ((EclipseLinkCaching)this.subject).getCacheSizeDefault();
                    }

                    protected void setValue_(Integer value) {
                        ((EclipseLinkCaching)this.subject).setCacheSizeDefault(value);
                    }
                };
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildDefaultSharedCacheHolder() {
        return new PropertyAspectAdapter<EclipseLinkCaching, Boolean>(this.getSubjectHolder(), new String[]{"sharedCacheDefault"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkCaching)this.subject).getSharedCacheDefault();
            }

            protected void setValue_(Boolean value) {
                ((EclipseLinkCaching)this.subject).setSharedCacheDefault(value);
            }
        };
    }

    private PropertyValueModel<String> buildDefaultSharedCacheStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultDefaultSharedCacheHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CACHING_TAB_DEFAULT_SHARED_CACHE_DEFAULT_LABEL, (Object)defaultStringValue);
                }
                return JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CACHING_TAB_SHARED_CACHE_DEFAULT_LABEL;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultDefaultSharedCacheHolder() {
        return new PropertyAspectAdapter<EclipseLinkCaching, Boolean>(this.getSubjectHolder(), new String[]{"sharedCacheDefault"}){

            protected Boolean buildValue_() {
                if (((EclipseLinkCaching)this.subject).getSharedCacheDefault() != null) {
                    return null;
                }
                return ((EclipseLinkCaching)this.subject).getDefaultSharedCacheDefault();
            }
        };
    }
}

