/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.core.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.internal.discovery.core.util.HttpClientTransportService;
import org.eclipse.mylyn.internal.discovery.core.util.IOWithCauseException;
import org.eclipse.mylyn.internal.discovery.core.util.ITransportService;
import org.eclipse.mylyn.internal.discovery.core.util.P2TransportService;

public class WebUtil {
    private static ITransportService transport;

    public static IStatus download(URI uri, File target, IProgressMonitor monitor) throws IOException {
        IStatus result;
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
        try {
            result = WebUtil.download(uri, out, monitor);
        }
        finally {
            ((OutputStream)out).close();
        }
        if (!result.isOK()) {
            target.delete();
            if (result.getException() instanceof IOException) {
                throw (IOException)result.getException();
            }
            throw new IOWithCauseException(result.getException());
        }
        return result;
    }

    public static void readResource(URI uri, TextContentProcessor processor, IProgressMonitor monitor) throws IOException, CoreException {
        InputStream in = WebUtil.stream(uri, monitor);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            processor.process(reader);
        }
        finally {
            in.close();
        }
    }

    public static boolean verifyAvailability(List<? extends URI> locations, boolean one, IProgressMonitor monitor) throws IOException, CoreException {
        if (locations.isEmpty() || locations.size() > 5) {
            throw new IllegalArgumentException();
        }
        int countFound = 0;
        for (URI uRI : locations) {
            block5: {
                try {
                    WebUtil.getLastModified(uRI, monitor);
                    if (!one) break block5;
                    return true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (one) continue;
                    return false;
                }
            }
            ++countFound;
        }
        return countFound == locations.size();
    }

    public static synchronized ITransportService getTransport() {
        if (transport == null) {
            if (Platform.isRunning()) {
                try {
                    transport = new P2TransportService();
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (transport == null) {
                transport = new HttpClientTransportService();
            }
        }
        return transport;
    }

    public static IStatus download(URI uri, OutputStream out, IProgressMonitor monitor) {
        return WebUtil.getTransport().download(uri, out, monitor);
    }

    public static InputStream stream(URI uri, IProgressMonitor monitor) throws IOException, CoreException {
        return WebUtil.getTransport().stream(uri, monitor);
    }

    private static long getLastModified(URI location, IProgressMonitor monitor) throws CoreException, IOException {
        return WebUtil.getTransport().getLastModified(location, monitor);
    }

    public static interface TextContentProcessor {
        public void process(Reader var1) throws IOException;
    }
}

