/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.service.Category;
import org.eclipse.epp.internal.mpc.core.service.DefaultMarketplaceService;
import org.eclipse.epp.internal.mpc.core.service.Market;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.AbstractDiscoveryItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseCatalogItem
extends AbstractDiscoveryItem<CatalogDescriptor> {
    private static final String TID = "tid:";
    private static final String UTF_8 = "UTF-8";
    private final MarketplaceViewer viewer;
    private final DiscoveryResources resources;
    private final IShellProvider shellProvider;
    private final MarketplaceCategory category;
    private final IMarketplaceWebBrowser browser;

    public BrowseCatalogItem(Composite parent, DiscoveryResources resources, IShellProvider shellProvider, IMarketplaceWebBrowser browser, MarketplaceCategory category, CatalogDescriptor element, MarketplaceViewer viewer) {
        super(parent, 0, resources, (Object)element);
        this.resources = resources;
        this.shellProvider = shellProvider;
        this.browser = browser;
        this.category = category;
        this.viewer = viewer;
        this.createContent();
    }

    private void createContent() {
        BrowseCatalogItem parent = this;
        GridLayoutFactory.swtDefaults().applyTo((Composite)parent);
        Link link = new Link((Composite)parent, 0);
        if (this.viewer.getQueryContentType() == MarketplaceViewer.ContentType.SEARCH) {
            link.setText(NLS.bind((String)Messages.BrowseCatalogItem_browseMoreLink, (Object)this.category.getMatchCount()));
        } else {
            link.setText(Messages.BrowseCatalogItem_browseMoreLinkNoCount);
        }
        link.setToolTipText(NLS.bind((String)Messages.BrowseCatalogItem_openUrlBrowser, (Object)((CatalogDescriptor)this.getData()).getUrl()));
        link.setBackground(null);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BrowseCatalogItem.this.openMarketplace();
            }
        });
        GridDataFactory.swtDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)link);
    }

    protected void openMarketplace() {
        CatalogDescriptor catalogDescriptor = (CatalogDescriptor)this.getData();
        try {
            URL url = catalogDescriptor.getUrl();
            try {
                MarketplaceViewer.ContentType contentType = this.viewer.getQueryContentType();
                if (contentType == MarketplaceViewer.ContentType.SEARCH) {
                    String queryText = this.viewer.getQueryText();
                    Category queryCategory = this.viewer.getQueryCategory();
                    Market queryMarket = this.viewer.getQueryMarket();
                    String path = new DefaultMarketplaceService(url).computeRelativeSearchUrl(queryMarket, queryCategory, queryText, false);
                    if (path != null) {
                        url = new URL(url, path);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                MarketplaceClientUi.error(e);
            }
            catch (MalformedURLException e) {
                MarketplaceClientUi.error(e);
            }
            this.browser.openUrl(url.toURI().toString());
        }
        catch (URISyntaxException e) {
            String message = String.format(Messages.BrowseCatalogItem_cannotOpenBrowser, new Object[0]);
            Status status = new Status(4, "org.eclipse.epp.mpc.ui", 4, message, (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 7);
        }
    }

    protected void refresh() {
    }
}

