/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.search.util.ArtifactInfo;
import org.eclipse.m2e.core.ui.internal.search.util.Packaging;
import org.eclipse.m2e.core.ui.internal.search.util.SearchEngine;
import org.eclipse.m2e.editor.xml.PomTemplateContextUtil;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.m2e.editor.xml.internal.XmlUtils;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PomTemplateContext
extends Enum<PomTemplateContext> {
    public static final /* enum */ PomTemplateContext UNKNOWN = new PomTemplateContext("unknown");
    public static final /* enum */ PomTemplateContext DOCUMENT = new PomTemplateContext("#document");
    public static final /* enum */ PomTemplateContext PROJECT = new PomTemplateContext("project");
    public static final /* enum */ PomTemplateContext BUILD = new PomTemplateContext("build");
    public static final /* enum */ PomTemplateContext PARENT = new PomTemplateContext("parent");
    public static final /* enum */ PomTemplateContext RELATIVE_PATH = new PomTemplateContext("relativePath");
    public static final /* enum */ PomTemplateContext MODULES = new PomTemplateContext("modules");
    public static final /* enum */ PomTemplateContext PROPERTIES = new PomTemplateContext("properties");
    public static final /* enum */ PomTemplateContext DEPENDENCIES = new PomTemplateContext("dependencies");
    public static final /* enum */ PomTemplateContext DEPENDENCY_MANAGEMENT = new PomTemplateContext("dependencyManagement");
    public static final /* enum */ PomTemplateContext EXCLUSIONS = new PomTemplateContext("exclusions");
    public static final /* enum */ PomTemplateContext PLUGINS = new PomTemplateContext("plugins");
    public static final /* enum */ PomTemplateContext PLUGIN = new PomTemplateContext("plugin");
    public static final /* enum */ PomTemplateContext PLUGIN_MANAGEMENT = new PomTemplateContext("pluginManagement");
    public static final /* enum */ PomTemplateContext EXECUTIONS = new PomTemplateContext("executions");
    public static final /* enum */ PomTemplateContext PROFILES = new PomTemplateContext("profiles");
    public static final /* enum */ PomTemplateContext PROFILE = new PomTemplateContext("profile");
    public static final /* enum */ PomTemplateContext REPOSITORIES = new PomTemplateContext("repositories");
    public static final /* enum */ PomTemplateContext CONFIGURATION = new PomTemplateContext("configuration"){

        @Override
        protected void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) throws CoreException {
            String groupId;
            if ("execution".equals(node.getParentNode().getNodeName()) || "reportSet".equals(node.getParentNode().getNodeName())) {
                node = node.getParentNode().getParentNode();
            }
            if ((groupId = this.getGroupId(node)) == null) {
                groupId = "org.apache.maven.plugins";
            }
            String artifactId = 1.getArtifactId(node);
            String version = 1.extractVersion(project, eclipseprj, 1.getVersion(node), groupId, artifactId, EXTRACT_STRATEGY_PLUGIN | EXTRACT_STRATEGY_SEARCH);
            if (version == null) {
                return;
            }
            PluginDescriptor descriptor = PomTemplateContextUtil.INSTANCE.getPluginDescriptor(groupId, artifactId, version);
            if (descriptor != null) {
                List mojos = descriptor.getMojos();
                HashSet<String> params = new HashSet<String>();
                for (MojoDescriptor mojo : mojos) {
                    List parameters = mojo.getParameters();
                    for (Parameter parameter : parameters) {
                        String defaultValue;
                        String name;
                        boolean editable = parameter.isEditable();
                        if (!editable || params.contains(name = parameter.getName()) || !name.startsWith(prefix)) continue;
                        params.add(name);
                        String text = NLS.bind((String)Messages.PomTemplateContext_param, (Object)parameter.isRequired(), (Object)parameter.getType());
                        String expression = parameter.getExpression();
                        if (expression != null) {
                            text = String.valueOf(text) + NLS.bind((String)Messages.PomTemplateContext_param_expr, (Object)expression);
                        }
                        if ((defaultValue = parameter.getDefaultValue()) != null) {
                            text = String.valueOf(text) + NLS.bind((String)Messages.PomTemplateContext_param_def, (Object)defaultValue);
                        }
                        String desc = parameter.getDescription().trim();
                        text = String.valueOf(text) + (desc.startsWith("<p>") ? desc : "<br>" + desc);
                        proposals.add(new Template(name, text, this.getContextTypeId(), "<" + name + ">${cursor}</" + name + ">", false));
                    }
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext GROUP_ID = new PomTemplateContext("groupId"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) throws CoreException {
            String contextTypeId = this.getContextTypeId();
            for (String groupId : PomTemplateContext.getSearchEngine(eclipseprj).findGroupIds(prefix, this.getPackaging(node), this.getContainingArtifact(node))) {
                PomTemplateContext.add(proposals, contextTypeId, groupId);
            }
        }
    };
    public static final /* enum */ PomTemplateContext ARTIFACT_ID = new PomTemplateContext("artifactId"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) throws CoreException {
            String groupId = this.getGroupId(node);
            if ((groupId == null || groupId.trim().length() == 0) && "plugin".equals(node.getParentNode().getNodeName())) {
                groupId = "org.apache.maven.plugins";
            }
            if (groupId != null) {
                String contextTypeId = this.getContextTypeId();
                for (String artifactId : PomTemplateContext.getSearchEngine(eclipseprj).findArtifactIds(groupId, prefix, this.getPackaging(node), this.getContainingArtifact(node))) {
                    PomTemplateContext.add(proposals, contextTypeId, artifactId, String.valueOf(groupId) + ":" + artifactId);
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext VERSION = new PomTemplateContext("version"){

        /*
         * WARNING - void declaration
         */
        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) throws CoreException {
            String groupId = this.getGroupId(node);
            if ((groupId == null || groupId.trim().length() == 0) && "plugin".equals(node.getParentNode().getNodeName())) {
                groupId = "org.apache.maven.plugins";
            }
            String artifactId = 4.getArtifactId(node);
            if (groupId != null && artifactId != null) {
                String contextTypeId = this.getContextTypeId();
                for (String version : PomTemplateContext.getSearchEngine(eclipseprj).findVersions(groupId, artifactId, prefix, this.getPackaging(node))) {
                    PomTemplateContext.add(proposals, contextTypeId, version, String.valueOf(groupId) + ":" + artifactId + ":" + version);
                }
            }
            if ("dependency".equals(node.getParentNode().getNodeName())) {
                ArrayList<String> keys = new ArrayList<String>();
                String contextTypeId = this.getContextTypeId();
                MavenProject mvn = project;
                if (mvn != null) {
                    Properties props;
                    if (groupId.equals(mvn.getGroupId())) {
                        proposals.add(new Template("${project.version}", Messages.PomTemplateContext_project_version_hint, contextTypeId, "$${project.version}", false));
                    }
                    if ((props = mvn.getProperties()) != null) {
                        for (Object object : props.keySet()) {
                            if (!object.toString().endsWith(".version") && !object.toString().endsWith("Version")) continue;
                            keys.add(object.toString());
                        }
                        Collections.sort(keys);
                        if (keys.size() > 0) {
                            for (String string : keys) {
                                String expr = "${" + string + "}";
                                proposals.add(new Template(expr, Messages.PomTemplateContext_expression_description, contextTypeId, "$" + expr, false));
                            }
                        }
                    }
                } else {
                    Element root = node.getOwnerDocument().getDocumentElement();
                    if (root != null && "project".equals(root.getNodeName())) {
                        void var12_20;
                        Element parEl;
                        String string = XmlUtils.getTextValue(XmlUtils.findChild(root, "groupId"));
                        if (string == null && (parEl = XmlUtils.findChild(root, "parent")) != null) {
                            String string2 = XmlUtils.getTextValue(XmlUtils.findChild(parEl, "groupId"));
                        }
                        if (groupId.equals(var12_20)) {
                            proposals.add(new Template("${project.version}", Messages.PomTemplateContext_project_version_hint, contextTypeId, "$${project.version}", false));
                        }
                    }
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext CLASSIFIER = new PomTemplateContext("classifier"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) throws CoreException {
            String groupId = this.getGroupId(node);
            String artifactId = 5.getArtifactId(node);
            String version = 5.getVersion(node);
            if (groupId != null && artifactId != null && version != null) {
                String contextTypeId = this.getContextTypeId();
                for (String classifier : PomTemplateContext.getSearchEngine(eclipseprj).findClassifiers(groupId, artifactId, version, prefix, this.getPackaging(node))) {
                    PomTemplateContext.add(proposals, contextTypeId, classifier, String.valueOf(groupId) + ":" + artifactId + ":" + version + ":" + classifier);
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext TYPE = new PomTemplateContext("type"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) throws CoreException {
            String groupId = this.getGroupId(node);
            String artifactId = 6.getArtifactId(node);
            String version = 6.getVersion(node);
            String contextTypeId = this.getContextTypeId();
            if (groupId != null && artifactId != null && version != null) {
                for (String type : PomTemplateContext.getSearchEngine(eclipseprj).findTypes(groupId, artifactId, version, prefix, this.getPackaging(node))) {
                    PomTemplateContext.add(proposals, contextTypeId, type, String.valueOf(groupId) + ":" + artifactId + ":" + version + ":" + type);
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext PACKAGING = new PomTemplateContext("packaging"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            String contextTypeId = this.getContextTypeId();
            PomTemplateContext.add(proposals, contextTypeId, "pom");
            PomTemplateContext.add(proposals, contextTypeId, "jar");
            PomTemplateContext.add(proposals, contextTypeId, "war");
            PomTemplateContext.add(proposals, contextTypeId, "ear");
            PomTemplateContext.add(proposals, contextTypeId, "ejb");
            PomTemplateContext.add(proposals, contextTypeId, "maven-plugin");
            PomTemplateContext.add(proposals, contextTypeId, "maven-archetype");
        }
    };
    public static final /* enum */ PomTemplateContext SCOPE = new PomTemplateContext("scope"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            String contextTypeId = this.getContextTypeId();
            PomTemplateContext.add(proposals, contextTypeId, "compile");
            PomTemplateContext.add(proposals, contextTypeId, "test");
            PomTemplateContext.add(proposals, contextTypeId, "provided");
            PomTemplateContext.add(proposals, contextTypeId, "runtime");
            PomTemplateContext.add(proposals, contextTypeId, "system");
            PomTemplateContext.add(proposals, contextTypeId, "import");
        }
    };
    public static final /* enum */ PomTemplateContext SYSTEM_PATH = new PomTemplateContext("systemPath");
    public static final /* enum */ PomTemplateContext PHASE = new PomTemplateContext("phase"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            String contextTypeId = this.getContextTypeId();
            PomTemplateContext.add(proposals, contextTypeId, "pre-clean", Messages.PomTemplateContext_preclean);
            PomTemplateContext.add(proposals, contextTypeId, "clean", Messages.PomTemplateContext_clean);
            PomTemplateContext.add(proposals, contextTypeId, "post-clean", Messages.PomTemplateContext_postclean);
            PomTemplateContext.add(proposals, contextTypeId, "validate", Messages.PomTemplateContext_validate);
            PomTemplateContext.add(proposals, contextTypeId, "generate-sources", Messages.PomTemplateContext_generatesources);
            PomTemplateContext.add(proposals, contextTypeId, "process-sources", Messages.PomTemplateContext_processsources);
            PomTemplateContext.add(proposals, contextTypeId, "generate-resources", Messages.PomTemplateContext_generateresources);
            PomTemplateContext.add(proposals, contextTypeId, "process-resources", Messages.PomTemplateContext_processresources);
            PomTemplateContext.add(proposals, contextTypeId, "compile", Messages.PomTemplateContext_compile);
            PomTemplateContext.add(proposals, contextTypeId, "process-classes", Messages.PomTemplateContext_processclasses);
            PomTemplateContext.add(proposals, contextTypeId, "generate-test-sources", Messages.PomTemplateContext_generatetestsources);
            PomTemplateContext.add(proposals, contextTypeId, "process-test-sources", Messages.PomTemplateContext_processtestsources);
            PomTemplateContext.add(proposals, contextTypeId, "generate-test-resources", Messages.PomTemplateContext_generatetestresources);
            PomTemplateContext.add(proposals, contextTypeId, "process-test-resources", Messages.PomTemplateContext_processtestresources);
            PomTemplateContext.add(proposals, contextTypeId, "test-compile", Messages.PomTemplateContext_testcompile);
            PomTemplateContext.add(proposals, contextTypeId, "process-test-classes", Messages.PomTemplateContext_processtestclasses);
            PomTemplateContext.add(proposals, contextTypeId, "test", Messages.PomTemplateContext_test);
            PomTemplateContext.add(proposals, contextTypeId, "prepare-package", Messages.PomTemplateContext_preparepackage);
            PomTemplateContext.add(proposals, contextTypeId, "package", Messages.PomTemplateContext_package);
            PomTemplateContext.add(proposals, contextTypeId, "pre-integration-test", Messages.PomTemplateContext_preintegrationtest);
            PomTemplateContext.add(proposals, contextTypeId, "integration-test", Messages.PomTemplateContext_integrationtest);
            PomTemplateContext.add(proposals, contextTypeId, "post-integration-test", Messages.PomTemplateContext_postintegrationtest);
            PomTemplateContext.add(proposals, contextTypeId, "verify", Messages.PomTemplateContext_verify);
            PomTemplateContext.add(proposals, contextTypeId, "install", Messages.PomTemplateContext_install);
            PomTemplateContext.add(proposals, contextTypeId, "deploy", Messages.PomTemplateContext_deploy);
            PomTemplateContext.add(proposals, contextTypeId, "pre-site", Messages.PomTemplateContext_presite);
            PomTemplateContext.add(proposals, contextTypeId, "site", Messages.PomTemplateContext_site);
            PomTemplateContext.add(proposals, contextTypeId, "post-site", Messages.PomTemplateContext_postsite);
            PomTemplateContext.add(proposals, contextTypeId, "site-deploy", Messages.PomTemplateContext_sitedeploy);
        }
    };
    public static final /* enum */ PomTemplateContext GOAL = new PomTemplateContext("goal"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) throws CoreException {
            List mojos;
            if (!"goals".equals(node.getParentNode().getNodeName())) {
                return;
            }
            if (!"execution".equals((node = node.getParentNode()).getParentNode().getNodeName())) {
                return;
            }
            if (!"executions".equals((node = node.getParentNode()).getParentNode().getNodeName())) {
                return;
            }
            String groupId = this.getGroupId(node = node.getParentNode());
            if (groupId == null) {
                groupId = "org.apache.maven.plugins";
            }
            String artifactId = 10.getArtifactId(node);
            String version = 10.extractVersion(project, eclipseprj, 10.getVersion(node), groupId, artifactId, EXTRACT_STRATEGY_PLUGIN | EXTRACT_STRATEGY_SEARCH);
            if (version == null) {
                return;
            }
            PluginDescriptor descriptor = PomTemplateContextUtil.INSTANCE.getPluginDescriptor(groupId, artifactId, version);
            if (descriptor != null && (mojos = descriptor.getMojos()) != null) {
                String contextTypeId = this.getContextTypeId();
                for (MojoDescriptor mojo : mojos) {
                    PomTemplateContext.add(proposals, contextTypeId, mojo.getGoal(), mojo.getDescription());
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext MODULE = new PomTemplateContext("module"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) throws CoreException {
            Node modulesNode;
            if (project == null) {
                return;
            }
            ArrayList<String> existings = new ArrayList<String>();
            Node moduleNode = node;
            if (moduleNode != null && (modulesNode = moduleNode.getParentNode()) != null) {
                for (Element el : XmlUtils.findChilds((Element)modulesNode, "module")) {
                    String val;
                    if (el == moduleNode || (val = XmlUtils.getTextValue(el)) == null) continue;
                    existings.add(val);
                }
            }
            File directory = new File(eclipseprj.getLocationURI());
            final File currentPom = new File(directory, "pom.xml");
            String path = prefix;
            boolean endingSlash = path.endsWith("/");
            String[] elems = StringUtils.split((String)path, (String)"/");
            String lastElement = null;
            int i = 0;
            while (i < elems.length) {
                if ("..".equals(elems[i])) {
                    directory = directory != null ? directory.getParentFile() : null;
                } else if (i < elems.length - (endingSlash ? 0 : 1)) {
                    directory = directory != null ? new File(directory, elems[i]) : null;
                } else {
                    lastElement = elems[i];
                }
                ++i;
            }
            path = lastElement != null ? path.substring(0, path.length() - lastElement.length()) : path;
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        File pom = new File(pathname, "pom.xml");
                        return pom.exists() && pom.isFile() && !pom.equals(currentPom);
                    }
                    return false;
                }
            };
            if (directory != null && directory.exists() && directory.isDirectory()) {
                File currentParent;
                File[] offerings;
                File[] fileArray = offerings = directory.listFiles(filter);
                int n = offerings.length;
                int n2 = 0;
                while (n2 < n) {
                    String val;
                    File candidate = fileArray[n2];
                    if ((lastElement == null || candidate.getName().startsWith(lastElement)) && !existings.contains(val = String.valueOf(path) + candidate.getName())) {
                        PomTemplateContext.add(proposals, this.getContextTypeId(), val, NLS.bind((String)Messages.PomTemplateContext_candidate, (Object)candidate));
                    }
                    ++n2;
                }
                if (path.length() == 0 && directory.equals(currentPom.getParentFile()) && (currentParent = directory.getParentFile()) != null && currentParent.exists()) {
                    File[] fileArray2 = offerings = currentParent.listFiles(filter);
                    int n3 = offerings.length;
                    n = 0;
                    while (n < n3) {
                        File candidate = fileArray2[n];
                        String val = "../" + candidate.getName();
                        if (!existings.contains(val)) {
                            PomTemplateContext.add(proposals, this.getContextTypeId(), val, NLS.bind((String)Messages.PomTemplateContext_candidate, (Object)candidate));
                        }
                        ++n;
                    }
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext LICENSES = new PomTemplateContext("licenses");
    private static final Logger log;
    private static final String PREFIX = "org.eclipse.m2e.editor.xml.templates.contextType.";
    private final String nodeName;
    private static SearchEngine searchEngineForTests;
    static int EXTRACT_STRATEGY_PLUGIN;
    static int EXTRACT_STRATEGY_DEPENDENCY;
    static int EXTRACT_STRATEGY_SEARCH;
    private static final /* synthetic */ PomTemplateContext[] ENUM$VALUES;

    static {
        ENUM$VALUES = new PomTemplateContext[]{UNKNOWN, DOCUMENT, PROJECT, BUILD, PARENT, RELATIVE_PATH, MODULES, PROPERTIES, DEPENDENCIES, DEPENDENCY_MANAGEMENT, EXCLUSIONS, PLUGINS, PLUGIN, PLUGIN_MANAGEMENT, EXECUTIONS, PROFILES, PROFILE, REPOSITORIES, CONFIGURATION, GROUP_ID, ARTIFACT_ID, VERSION, CLASSIFIER, TYPE, PACKAGING, SCOPE, SYSTEM_PATH, PHASE, GOAL, MODULE, LICENSES};
        log = LoggerFactory.getLogger(PomTemplateContext.class);
        EXTRACT_STRATEGY_PLUGIN = 1;
        EXTRACT_STRATEGY_DEPENDENCY = 2;
        EXTRACT_STRATEGY_SEARCH = 4;
    }

    private PomTemplateContext(String nodeName) {
        this.nodeName = nodeName;
    }

    public Template[] getTemplates(MavenProject project, IProject eclipsePrj, Node node, String prefix) {
        ArrayList<Template> templates = new ArrayList<Template>();
        try {
            this.addTemplates(project, eclipsePrj, templates, node, prefix);
        }
        catch (CoreException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return templates.toArray(new Template[templates.size()]);
    }

    protected void addTemplates(MavenProject project, IProject eclipsePrj, Collection<Template> templates, Node currentNode, String prefix) throws CoreException {
    }

    protected String getNodeName() {
        return this.nodeName;
    }

    public String getContextTypeId() {
        return PREFIX + this.nodeName;
    }

    public static PomTemplateContext fromId(String contextTypeId) {
        PomTemplateContext[] pomTemplateContextArray = PomTemplateContext.values();
        int n = pomTemplateContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            PomTemplateContext context = pomTemplateContextArray[n2];
            if (context.getContextTypeId().equals(contextTypeId)) {
                return context;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public static PomTemplateContext fromNodeName(String idSuffix) {
        PomTemplateContext[] pomTemplateContextArray = PomTemplateContext.values();
        int n = pomTemplateContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            PomTemplateContext context = pomTemplateContextArray[n2];
            if (context.getNodeName().equals(idSuffix)) {
                return context;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    private static SearchEngine getSearchEngine(IProject project) throws CoreException {
        if (searchEngineForTests != null) {
            return searchEngineForTests;
        }
        return M2EUIPluginActivator.getDefault().getSearchEngine(project);
    }

    public static void setSearchEngineForTests(SearchEngine _searchEngineForTests) {
        searchEngineForTests = _searchEngineForTests;
    }

    protected ArtifactInfo getContainingArtifact(Node currentNode) {
        if (this.isExclusion(currentNode)) {
            Node node = currentNode.getParentNode().getParentNode();
            return this.getArtifactInfo(node);
        }
        return null;
    }

    private ArtifactInfo getArtifactInfo(Node node) {
        return new ArtifactInfo(this.getGroupId(node), PomTemplateContext.getArtifactId(node), PomTemplateContext.getVersion(node), PomTemplateContext.getSiblingTextValue(node, "classifier"), PomTemplateContext.getSiblingTextValue(node, "type"));
    }

    protected Packaging getPackaging(Node currentNode) {
        if (this.isPlugin(currentNode)) {
            return Packaging.PLUGIN;
        }
        if (this.isParent(currentNode)) {
            return Packaging.POM;
        }
        return Packaging.ALL;
    }

    private boolean isPlugin(Node currentNode) {
        return "plugin".equals(currentNode.getParentNode().getNodeName());
    }

    private boolean isExclusion(Node currentNode) {
        return "exclusion".equals(currentNode.getParentNode().getNodeName());
    }

    private boolean isParent(Node currentNode) {
        return "parent".equals(currentNode.getParentNode().getNodeName());
    }

    protected String getGroupId(Node currentNode) {
        return PomTemplateContext.getSiblingTextValue(currentNode, "groupId");
    }

    static String extractVersion(MavenProject mp, IProject project, String version, String groupId, String artifactId, int strategy) throws CoreException {
        assert (mp != null);
        if ((version = PomTemplateContext.simpleInterpolate(mp, version)) == null) {
            Packaging pack = Packaging.ALL;
            if ((strategy & EXTRACT_STRATEGY_PLUGIN) != 0) {
                version = PomTemplateContext.searchPM(mp, groupId, artifactId);
                pack = Packaging.PLUGIN;
            }
            if ((strategy & EXTRACT_STRATEGY_DEPENDENCY) != 0) {
                version = PomTemplateContext.searchDM(mp, groupId, artifactId);
            }
            if (version == null && (strategy & EXTRACT_STRATEGY_SEARCH) != 0) {
                Collection versions = PomTemplateContext.getSearchEngine(project).findVersions(groupId, artifactId, "", pack);
                if (versions.isEmpty()) {
                    return null;
                }
                version = (String)versions.iterator().next();
            }
        }
        return version;
    }

    static String simpleInterpolate(MavenProject project, String text) {
        if (text != null && text.contains("${")) {
            if (project == null) {
                return null;
            }
            Properties props = project.getProperties();
            RegexBasedInterpolator inter = new RegexBasedInterpolator();
            if (props != null) {
                inter.addValueSource((ValueSource)new PropertiesBasedValueSource(props));
            }
            inter.addValueSource((ValueSource)new PrefixedObjectValueSource(Arrays.asList("pom.", "project."), (Object)project.getModel(), false));
            try {
                text = inter.interpolate(text);
            }
            catch (InterpolationException interpolationException) {
                text = null;
            }
        }
        return text;
    }

    static String searchPM(MavenProject project, String groupId, String artifactId) {
        if (project == null) {
            return null;
        }
        String version = null;
        String id = Plugin.constructKey((String)groupId, (String)artifactId);
        PluginManagement pm = project.getPluginManagement();
        if (pm != null) {
            for (Plugin pl : pm.getPlugins()) {
                if (!id.equals(pl.getKey())) continue;
                version = pl.getVersion();
                break;
            }
        }
        return version;
    }

    static String searchDM(MavenProject project, String groupId, String artifactId) {
        if (project == null) {
            return null;
        }
        String version = null;
        String id = String.valueOf(groupId) + ":" + artifactId + ":";
        DependencyManagement dm = project.getDependencyManagement();
        if (dm != null) {
            for (Dependency dep : dm.getDependencies()) {
                if (!dep.getManagementKey().startsWith(id)) continue;
                version = dep.getVersion();
                break;
            }
        }
        return version;
    }

    protected static String getArtifactId(Node currentNode) {
        return PomTemplateContext.getSiblingTextValue(currentNode, "artifactId");
    }

    protected static String getVersion(Node currentNode) {
        return PomTemplateContext.getSiblingTextValue(currentNode, "version");
    }

    private static String getSiblingTextValue(Node sibling, String name) {
        Node node = PomTemplateContext.getSiblingWithName(sibling, name);
        return XmlUtils.getTextValue(node);
    }

    private static Node getSiblingWithName(Node node, String name) {
        NodeList nodeList = node.getParentNode().getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (name.equals(nodeList.item(i).getNodeName())) {
                return nodeList.item(i);
            }
            ++i;
        }
        return null;
    }

    private static void add(Collection<Template> proposals, String contextTypeId, String name) {
        PomTemplateContext.add(proposals, contextTypeId, name, name);
    }

    private static void add(Collection<Template> proposals, String contextTypeId, String name, String description) {
        proposals.add(new Template(name, description, contextTypeId, name, false));
    }

    public static PomTemplateContext[] values() {
        PomTemplateContext[] pomTemplateContextArray = ENUM$VALUES;
        int n = pomTemplateContextArray.length;
        PomTemplateContext[] pomTemplateContextArray2 = new PomTemplateContext[n];
        System.arraycopy(ENUM$VALUES, 0, pomTemplateContextArray2, 0, n);
        return pomTemplateContextArray2;
    }

    public static PomTemplateContext valueOf(String string) {
        return Enum.valueOf(PomTemplateContext.class, string);
    }

    /* synthetic */ PomTemplateContext(String string, int n, String string2, PomTemplateContext pomTemplateContext) {
        this(string2);
    }
}

