/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.command.InterruptibleParameterizedCommand;
import org.eclipse.jpt.common.utility.command.ParameterizedCommand;
import org.eclipse.jpt.common.utility.internal.CharArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.Range;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.ArrayIterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayTools {
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final Class<Object> OBJECT_CLASS = Object.class;
    private static final Random RANDOM = new Random();

    public static <E> E[] newInstance(E[] array) {
        return ArrayTools.newInstance(array, array.length);
    }

    public static <E> E[] newInstance(E[] array, int length) {
        return ArrayTools.newInstance(ArrayTools.componentType(array), length);
    }

    public static <E> E[] newInstance(Class<E> componentType, int length) {
        if (componentType.isPrimitive()) {
            throw new IllegalArgumentException("Array class cannot be primitive: " + componentType);
        }
        return ArrayTools.newInstance_(componentType, length);
    }

    private static <E> E[] newInstance_(Class<E> componentType, int length) {
        return componentType == OBJECT_CLASS ? (length == 0 ? ObjectTools.EMPTY_OBJECT_ARRAY : new Object[length]) : Array.newInstance(componentType, length);
    }

    public static Object[] array(Iterable<?> iterable) {
        return ArrayTools.array(iterable.iterator());
    }

    public static Object[] array(Iterable<?> iterable, int iterableSize) {
        return ArrayTools.array(iterable.iterator(), iterableSize);
    }

    public static <E> E[] array(Iterable<?> iterable, Class<E> componentType) {
        return ArrayTools.array(iterable.iterator(), componentType);
    }

    public static <E> E[] array(Iterable<?> iterable, int iterableSize, Class<E> componentType) {
        return ArrayTools.array(iterable.iterator(), iterableSize, componentType);
    }

    public static <E> E[] array(Iterable<? extends E> iterable, E[] array) {
        return ArrayTools.array(iterable.iterator(), array);
    }

    public static <E> E[] array(Iterable<? extends E> iterable, int iterableSize, E[] array) {
        return ArrayTools.array(iterable.iterator(), iterableSize, array);
    }

    public static Object[] array(Iterator<?> iterator) {
        return iterator.hasNext() ? ListTools.list(iterator).toArray() : ObjectTools.EMPTY_OBJECT_ARRAY;
    }

    public static Object[] array(Iterator<?> iterator, int iteratorSize) {
        return iterator.hasNext() ? ListTools.list(iterator, iteratorSize).toArray() : ObjectTools.EMPTY_OBJECT_ARRAY;
    }

    public static <E> E[] array(Iterator<?> iterator, Class<E> componentType) {
        E[] array = ArrayTools.newInstance(componentType, 0);
        return iterator.hasNext() ? ListTools.list(iterator).toArray(array) : array;
    }

    public static <E> E[] array(Iterator<?> iterator, int iteratorSize, Class<E> componentType) {
        return iterator.hasNext() ? ListTools.list(iterator, iteratorSize).toArray(ArrayTools.newInstance(componentType, iteratorSize)) : ArrayTools.newInstance(componentType, 0);
    }

    public static <E> E[] array(Iterator<? extends E> iterator, E[] array) {
        return iterator.hasNext() ? ListTools.list(iterator).toArray(array) : ArrayTools.emptyArray(array);
    }

    public static <E> E[] array(Iterator<? extends E> iterator, int iteratorSize, E[] array) {
        return iterator.hasNext() ? ListTools.list(iterator, iteratorSize).toArray(array) : ArrayTools.emptyArray(array);
    }

    private static <E> E[] emptyArray(E[] array) {
        return array.length == 0 ? array : ArrayTools.clearFirst(array);
    }

    private static <E> E[] clearFirst(E[] array) {
        array[0] = null;
        return array;
    }

    public static <E> E[] add(E[] array, E value) {
        int len = array.length;
        E[] result = ArrayTools.newInstance(array, len + 1);
        if (len > 0) {
            System.arraycopy(array, 0, result, 0, len);
        }
        result[len] = value;
        return result;
    }

    public static <E> E[] add(E[] array, int index, E value) {
        int len = array.length;
        E[] result = ArrayTools.newInstance(array, len + 1);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        result[index] = value;
        if (index < len) {
            System.arraycopy(array, index, result, index + 1, len - index);
        }
        return result;
    }

    public static char[] add(char[] array, char value) {
        int len = array.length;
        char[] result = new char[len + 1];
        if (len > 0) {
            System.arraycopy(array, 0, result, 0, len);
        }
        result[len] = value;
        return result;
    }

    public static char[] add(char[] array, int index, char value) {
        int len = array.length;
        char[] result = new char[len + 1];
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        result[index] = value;
        if (index < len) {
            System.arraycopy(array, index, result, index + 1, len - index);
        }
        return result;
    }

    public static int[] add(int[] array, int value) {
        int len = array.length;
        int[] result = new int[len + 1];
        if (len > 0) {
            System.arraycopy(array, 0, result, 0, len);
        }
        result[len] = value;
        return result;
    }

    public static int[] add(int[] array, int index, int value) {
        int len = array.length;
        int[] result = new int[len + 1];
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        result[index] = value;
        if (index < len) {
            System.arraycopy(array, index, result, index + 1, len - index);
        }
        return result;
    }

    public static <E> E[] addAll(E[] array, Collection<? extends E> collection) {
        return ArrayTools.addAll(array, collection, collection.size());
    }

    private static <E> E[] addAll(E[] array, Collection<? extends E> collection, int collectionSize) {
        return collectionSize == 0 ? array : ArrayTools.addAll_(array, collection, collectionSize);
    }

    private static <E> E[] addAll_(E[] array, Collection<? extends E> collection) {
        return ArrayTools.addAll_(array, collection, collection.size());
    }

    private static <E> E[] addAll_(E[] array, Collection<? extends E> collection, int collectionSize) {
        return ArrayTools.addAll(array, collection, array.length, collectionSize);
    }

    private static <E> E[] addAll(E[] array, Collection<? extends E> collection, int arrayLength, int collectionSize) {
        return arrayLength == 0 ? collection.toArray(ArrayTools.newInstance(array, collectionSize)) : ArrayTools.addAll_(array, collection, arrayLength, collectionSize);
    }

    private static <E> E[] addAll_(E[] array, Collection<? extends E> collection, int arrayLength, int collectionSize) {
        E[] result = ArrayTools.newInstance(array, arrayLength + collectionSize);
        System.arraycopy(array, 0, result, 0, arrayLength);
        int i = arrayLength;
        for (E element : collection) {
            result[i++] = element;
        }
        return result;
    }

    public static <E> E[] addAll(E[] array, Iterable<? extends E> iterable) {
        return ArrayTools.addAll(array, iterable.iterator());
    }

    public static <E> E[] addAll(E[] array, Iterable<? extends E> iterable, int iterableSize) {
        return ArrayTools.addAll(array, iterable.iterator(), iterableSize);
    }

    public static <E> E[] addAll(E[] array, Iterator<? extends E> iterator) {
        return iterator.hasNext() ? ArrayTools.addAll_(array, ListTools.list(iterator)) : array;
    }

    public static <E> E[] addAll(E[] array, Iterator<? extends E> iterator, int iteratorSize) {
        return iterator.hasNext() ? ArrayTools.addAll_(array, ListTools.list(iterator, iteratorSize)) : array;
    }

    public static <E> E[] addAll(E[] array1, E ... array2) {
        return ArrayTools.addAll(array1, array2, array2.length);
    }

    private static <E> E[] addAll(E[] array1, E[] array2, int array2Length) {
        return array2Length == 0 ? array1 : ArrayTools.addAll_(array1, array2, array2Length);
    }

    private static <E> E[] addAll_(E[] array1, E[] array2, int array2Length) {
        return ArrayTools.addAll(array1, array2, array1.length, array2Length);
    }

    private static <E> E[] addAll(E[] array1, E[] array2, int array1Length, int array2Length) {
        return array1Length == 0 ? array2 : ArrayTools.addAll_(array1, array2, array1Length, array2Length);
    }

    private static <E> E[] addAll_(E[] array1, E[] array2, int array1Length, int array2Length) {
        E[] result = ArrayTools.newInstance(array1, array1Length + array2Length);
        System.arraycopy(array1, 0, result, 0, array1Length);
        System.arraycopy(array2, 0, result, array1Length, array2Length);
        return result;
    }

    public static <E> E[] addAll(E[] array1, int index, E ... array2) {
        return ArrayTools.addAll(array1, index, array2, array2.length);
    }

    private static <E> E[] addAll(E[] array1, int index, E[] array2, int array2Length) {
        return array2Length == 0 ? array1 : ArrayTools.addAll_(array1, index, array2, array2Length);
    }

    private static <E> E[] addAll_(E[] array1, int index, E[] array2, int array2Length) {
        return ArrayTools.addAll(array1, index, array2, array1.length, array2Length);
    }

    private static <E> E[] addAll(E[] array1, int index, E[] array2, int array1Length, int array2Length) {
        return array1Length == 0 ? array2 : (index == array1Length ? ArrayTools.addAll_(array1, array2, array1Length, array2Length) : ArrayTools.addAll_(array1, index, array2, array1Length, array2Length));
    }

    private static <E> E[] addAll_(E[] array1, int index, E[] array2, int array1Length, int array2Length) {
        E[] result = ArrayTools.newInstance(array1, array1Length + array2Length);
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, array2Length);
        System.arraycopy(array1, index, result, index + array2Length, array1Length - index);
        return result;
    }

    public static <E> E[] addAll(E[] array, int index, Collection<? extends E> collection) {
        return ArrayTools.addAll(array, index, collection, collection.size());
    }

    private static <E> E[] addAll(E[] array, int index, Collection<? extends E> collection, int collectionSize) {
        return collectionSize == 0 ? array : ArrayTools.addAll_(array, index, collection, collectionSize);
    }

    private static <E> E[] addAll_(E[] array, int index, Collection<? extends E> collection, int collectionSize) {
        return ArrayTools.addAll(array, index, collection, array.length, collectionSize);
    }

    private static <E> E[] addAll(E[] array, int index, Collection<? extends E> collection, int arrayLength, int collectionSize) {
        if (arrayLength == 0) {
            if (index == 0) {
                return collection.toArray(ArrayTools.newInstance(array, collectionSize));
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
        }
        return index == arrayLength ? ArrayTools.addAll_(array, collection, arrayLength, collectionSize) : ArrayTools.addAll_(array, index, collection, arrayLength, collectionSize);
    }

    private static <E> E[] addAll_(E[] array, int index, Collection<? extends E> collection, int arrayLength, int collectionSize) {
        E[] result = ArrayTools.newInstance(array, arrayLength + collectionSize);
        System.arraycopy(array, 0, result, 0, index);
        int i = index;
        for (E item : collection) {
            result[i++] = item;
        }
        System.arraycopy(array, index, result, index + collectionSize, arrayLength - index);
        return result;
    }

    public static <E> E[] addAll(E[] array, int index, Iterable<? extends E> iterable) {
        return ArrayTools.addAll(array, index, iterable.iterator());
    }

    public static <E> E[] addAll(E[] array, int index, Iterable<? extends E> iterable, int iterableSize) {
        return ArrayTools.addAll(array, index, iterable.iterator(), iterableSize);
    }

    public static <E> E[] addAll(E[] array, int index, Iterator<? extends E> iterator) {
        return iterator.hasNext() ? ArrayTools.addAll_(array, index, ListTools.list(iterator)) : array;
    }

    public static <E> E[] addAll(E[] array, int index, Iterator<? extends E> iterator, int iteratorSize) {
        return iterator.hasNext() ? ArrayTools.addAll_(array, index, ListTools.list(iterator, iteratorSize)) : array;
    }

    private static <E> E[] addAll_(E[] array, int index, Collection<? extends E> collection) {
        return ArrayTools.addAll_(array, index, collection, collection.size());
    }

    public static char[] addAll(char[] array1, char ... array2) {
        return ArrayTools.addAll(array1, array2, array2.length);
    }

    private static char[] addAll(char[] array1, char[] array2, int array2Length) {
        return array2Length == 0 ? array1 : ArrayTools.addAll_(array1, array2, array2Length);
    }

    private static char[] addAll_(char[] array1, char[] array2, int array2Length) {
        return ArrayTools.addAll(array1, array2, array1.length, array2Length);
    }

    private static char[] addAll(char[] array1, char[] array2, int array1Length, int array2Length) {
        return array1Length == 0 ? array2 : ArrayTools.addAll_(array1, array2, array1Length, array2Length);
    }

    private static char[] addAll_(char[] array1, char[] array2, int array1Length, int array2Length) {
        char[] result = new char[array1Length + array2Length];
        System.arraycopy(array1, 0, result, 0, array1Length);
        System.arraycopy(array2, 0, result, array1Length, array2Length);
        return result;
    }

    public static char[] addAll(char[] array1, int index, char ... array2) {
        return ArrayTools.addAll(array1, index, array2, array2.length);
    }

    private static char[] addAll(char[] array1, int index, char[] array2, int array2Length) {
        return array2Length == 0 ? array1 : ArrayTools.addAll_(array1, index, array2, array2Length);
    }

    private static char[] addAll_(char[] array1, int index, char[] array2, int array2Length) {
        return ArrayTools.addAll(array1, index, array2, array1.length, array2Length);
    }

    private static char[] addAll(char[] array1, int index, char[] array2, int array1Length, int array2Length) {
        return array1Length == 0 ? array2 : (index == array1Length ? ArrayTools.addAll_(array1, array2, array1Length, array2Length) : ArrayTools.addAll_(array1, index, array2, array1Length, array2Length));
    }

    private static char[] addAll_(char[] array1, int index, char[] array2, int array1Length, int array2Length) {
        char[] result = new char[array1Length + array2Length];
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, array2Length);
        System.arraycopy(array1, index, result, index + array2Length, array1Length - index);
        return result;
    }

    public static int[] addAll(int[] array1, int ... array2) {
        return ArrayTools.addAll(array1, array2, array2.length);
    }

    private static int[] addAll(int[] array1, int[] array2, int array2Length) {
        return array2Length == 0 ? array1 : ArrayTools.addAll_(array1, array2, array2Length);
    }

    private static int[] addAll_(int[] array1, int[] array2, int array2Length) {
        return ArrayTools.addAll(array1, array2, array1.length, array2Length);
    }

    private static int[] addAll(int[] array1, int[] array2, int array1Length, int array2Length) {
        return array1Length == 0 ? array2 : ArrayTools.addAll_(array1, array2, array1Length, array2Length);
    }

    private static int[] addAll_(int[] array1, int[] array2, int array1Length, int array2Length) {
        int[] result = new int[array1Length + array2Length];
        System.arraycopy(array1, 0, result, 0, array1Length);
        System.arraycopy(array2, 0, result, array1Length, array2Length);
        return result;
    }

    public static int[] addAll(int[] array1, int index, int ... array2) {
        return ArrayTools.addAll(array1, index, array2, array2.length);
    }

    private static int[] addAll(int[] array1, int index, int[] array2, int array2Length) {
        return array2Length == 0 ? array1 : ArrayTools.addAll_(array1, index, array2, array2Length);
    }

    private static int[] addAll_(int[] array1, int index, int[] array2, int array2Length) {
        return ArrayTools.addAll(array1, index, array2, array1.length, array2Length);
    }

    private static int[] addAll(int[] array1, int index, int[] array2, int array1Length, int array2Length) {
        return array1Length == 0 ? array2 : (index == array1Length ? ArrayTools.addAll_(array1, array2, array1Length, array2Length) : ArrayTools.addAll_(array1, index, array2, array1Length, array2Length));
    }

    private static int[] addAll_(int[] array1, int index, int[] array2, int array1Length, int array2Length) {
        int[] result = new int[array1Length + array2Length];
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, array2Length);
        System.arraycopy(array1, index, result, index + array2Length, array1Length - index);
        return result;
    }

    public static <E> E[] clear(E[] array) {
        return array.length == 0 ? array : ArrayTools.newInstance(array, 0);
    }

    public static <E> Class<? extends E> componentType(E[] array) {
        Class<?> rawComponentType;
        Class<?> componentType = rawComponentType = array.getClass().getComponentType();
        return componentType;
    }

    public static <E> E[] concatenate(E[] ... arrays) {
        int len = 0;
        E[][] EArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            E[] array = EArray[n2];
            len += array.length;
            ++n2;
        }
        E[] result = ArrayTools.newInstance(arrays[0], len);
        if (len == 0) {
            return result;
        }
        int current = 0;
        E[][] EArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            E[] array = EArray2[n4];
            int arrayLength = array.length;
            if (arrayLength > 0) {
                System.arraycopy(array, 0, result, current, arrayLength);
                current += arrayLength;
            }
            ++n4;
        }
        return result;
    }

    public static char[] concatenate(char[] ... arrays) {
        int len = 0;
        char[][] cArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            char[] array = cArray[n2];
            len += array.length;
            ++n2;
        }
        if (len == 0) {
            return CharArrayTools.EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[len];
        int current = 0;
        char[][] cArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            char[] array = cArray2[n4];
            int arrayLength = array.length;
            if (arrayLength > 0) {
                System.arraycopy(array, 0, result, current, arrayLength);
                current += arrayLength;
            }
            ++n4;
        }
        return result;
    }

    public static int[] concatenate(int[] ... arrays) {
        int len = 0;
        int[][] nArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            int[] array = nArray[n2];
            len += array.length;
            ++n2;
        }
        if (len == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[len];
        int current = 0;
        int[][] nArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            int[] array = nArray2[n4];
            int arrayLength = array.length;
            if (arrayLength > 0) {
                System.arraycopy(array, 0, result, current, arrayLength);
                current += arrayLength;
            }
            ++n4;
        }
        return result;
    }

    public static boolean contains(Object[] array, Object value) {
        return ArrayTools.contains(array, value, array.length);
    }

    private static boolean contains(Object[] array, Object value, int arrayLength) {
        return arrayLength == 0 ? false : ArrayTools.contains_(array, value, arrayLength);
    }

    private static boolean contains_(Object[] array, Object value, int arrayLength) {
        if (value == null) {
            int i = arrayLength;
            while (i-- > 0) {
                if (array[i] != null) continue;
                return true;
            }
        } else {
            int i = arrayLength;
            while (i-- > 0) {
                if (!value.equals(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(char[] array, char value) {
        return ArrayTools.contains(array, value, array.length);
    }

    private static boolean contains(char[] array, char value, int arrayLength) {
        return arrayLength == 0 ? false : ArrayTools.contains_(array, value, arrayLength);
    }

    private static boolean contains_(char[] array, char value, int arrayLength) {
        int i = arrayLength;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array, int value) {
        return ArrayTools.contains(array, value, array.length);
    }

    private static boolean contains(int[] array, int value, int arrayLength) {
        return arrayLength == 0 ? false : ArrayTools.contains_(array, value, arrayLength);
    }

    private static boolean contains_(int[] array, int value, int arrayLength) {
        int i = arrayLength;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Object[] array, Collection<?> collection) {
        return ArrayTools.containsAll(array, collection.iterator());
    }

    public static boolean containsAll(Object[] array, Iterable<?> iterable) {
        return ArrayTools.containsAll(array, iterable.iterator());
    }

    public static boolean containsAll(Object[] array, Iterator<?> iterator) {
        HashSet<Object> set = CollectionTools.set(array);
        while (iterator.hasNext()) {
            if (set.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Object[] array1, Object ... array2) {
        HashSet<Object> set = CollectionTools.set(array1);
        int i = array2.length;
        while (i-- > 0) {
            if (set.contains(array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(char[] array1, char ... array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (ArrayTools.contains(array1, array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(int[] array1, int ... array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (ArrayTools.contains(array1, array2[i])) continue;
            return false;
        }
        return true;
    }

    public static Range differenceRange(Object[] array1, Object[] array2) {
        int end = ArrayTools.lastIndexOfDifference(array1, array2);
        if (end == -1) {
            return new Range(array1.length, end);
        }
        return new Range(ArrayTools.indexOfDifference(array1, array2), end);
    }

    public static int indexOfDifference(Object[] array1, Object[] array2) {
        int end = Math.min(array1.length, array2.length);
        int i = 0;
        while (i < end) {
            Object o = array1[i];
            if (o == null ? array2[i] != null : !o.equals(array2[i])) {
                return i;
            }
            ++i;
        }
        return end;
    }

    public static int lastIndexOfDifference(Object[] array1, Object[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        if (len1 != len2) {
            return Math.max(len1, len2) - 1;
        }
        int i = len1 - 1;
        while (i > -1) {
            Object o = array1[i];
            if (o == null ? array2[i] != null : !o.equals(array2[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static Range identityDifferenceRange(Object[] array1, Object[] array2) {
        int end = ArrayTools.lastIndexOfIdentityDifference(array1, array2);
        if (end == -1) {
            return new Range(array1.length, end);
        }
        return new Range(ArrayTools.indexOfIdentityDifference(array1, array2), end);
    }

    public static int indexOfIdentityDifference(Object[] array1, Object[] array2) {
        int end = Math.min(array1.length, array2.length);
        int i = 0;
        while (i < end) {
            if (array1[i] != array2[i]) {
                return i;
            }
            ++i;
        }
        return end;
    }

    public static int lastIndexOfIdentityDifference(Object[] array1, Object[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        if (len1 != len2) {
            return Math.max(len1, len2) - 1;
        }
        int i = len1 - 1;
        while (i > -1) {
            if (array1[i] != array2[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static boolean elementsAreIdentical(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        int length = array1.length;
        if (array2.length != length) {
            return false;
        }
        int i = length;
        while (i-- > 0) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(Object[] array, Object value) {
        int len = array.length;
        if (value == null) {
            int i = 0;
            while (i < len) {
                if (array[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (value.equals(array[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int identityIndexOf(Object[] array, Object value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(char[] array, char value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <E extends Comparable<? super E>> int insertionIndexOf(E[] sortedArray, Comparable<E> value) {
        int len = sortedArray.length;
        int i = 0;
        while (i < len) {
            if (value.compareTo(sortedArray[i]) <= 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static <E> int insertionIndexOf(E[] sortedArray, E value, Comparator<? super E> comparator) {
        int len = sortedArray.length;
        int i = 0;
        while (i < len) {
            if (comparator.compare(value, sortedArray[i]) <= 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static <E> ArrayIterable<E> iterable(E[] array) {
        return IterableTools.iterable(array);
    }

    public static <E> ArrayIterable<E> iterable(E[] array, int start) {
        return IterableTools.iterable(array, start);
    }

    public static <E> ArrayIterable<E> iterable(E[] array, int start, int end) {
        return IterableTools.iterable(array, start, end);
    }

    public static <E> ArrayIterator<E> iterator(E[] array) {
        return IteratorTools.iterator(array);
    }

    public static <E> ArrayIterator<E> iterator(E[] array, int start) {
        return IteratorTools.iterator(array, start);
    }

    public static <E> ArrayIterator<E> iterator(E[] array, int start, int end) {
        return IteratorTools.iterator(array, start, end);
    }

    public static <E extends Comparable<? super E>> int lastInsertionIndexOf(E[] sortedArray, Comparable<E> value) {
        int len = sortedArray.length;
        int i = 0;
        while (i < len) {
            if (value.compareTo(sortedArray[i]) < 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static <E> int lastInsertionIndexOf(E[] sortedArray, E value, Comparator<? super E> comparator) {
        int len = sortedArray.length;
        int i = 0;
        while (i < len) {
            if (comparator.compare(value, sortedArray[i]) < 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static int lastIndexOf(Object[] array, Object value) {
        int len = array.length;
        if (value == null) {
            int i = len;
            while (i-- > 0) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            int i = len;
            while (i-- > 0) {
                if (!value.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static <E extends Comparable<? super E>> E min(E[] array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int last = len - 1;
        E min = array[last];
        int i = last;
        while (i-- > 0) {
            E e = array[i];
            if (min.compareTo(e) <= 0) continue;
            min = e;
        }
        return min;
    }

    public static <E extends Comparable<? super E>> E min(E[] array, Comparator<? super E> comparator) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int last = len - 1;
        E min = array[last];
        int i = last;
        while (i-- > 0) {
            E e = array[i];
            if (comparator.compare(min, e) <= 0) continue;
            min = e;
        }
        return min;
    }

    public static char min(char ... array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int last = len - 1;
        char min = array[last];
        int i = last;
        while (i-- > 0) {
            char c = array[i];
            if (c >= min) continue;
            min = c;
        }
        return min;
    }

    public static int min(int ... array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int last = len - 1;
        int min = array[last];
        int i = last;
        while (i-- > 0) {
            int x = array[i];
            if (x >= min) continue;
            min = x;
        }
        return min;
    }

    public static <E extends Comparable<? super E>> E max(E[] array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int last = len - 1;
        E max = array[last];
        int i = last;
        while (i-- > 0) {
            E e = array[i];
            if (max.compareTo(e) >= 0) continue;
            max = e;
        }
        return max;
    }

    public static <E extends Comparable<? super E>> E max(E[] array, Comparator<? super E> comparator) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int last = len - 1;
        E max = array[last];
        int i = last;
        while (i-- > 0) {
            E e = array[i];
            if (comparator.compare(max, e) >= 0) continue;
            max = e;
        }
        return max;
    }

    public static char max(char ... array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int last = len - 1;
        char max = array[last];
        int i = last;
        while (i-- > 0) {
            char c = array[i];
            if (c <= max) continue;
            max = c;
        }
        return max;
    }

    public static int max(int ... array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int last = len - 1;
        int max = array[last];
        int i = last;
        while (i-- > 0) {
            int x = array[i];
            if (x <= max) continue;
            max = x;
        }
        return max;
    }

    public static <E> E[] move(E[] array, int targetIndex, E element) {
        return ArrayTools.move(array, targetIndex, ArrayTools.indexOf(array, element));
    }

    public static <E> E[] move(E[] array, int targetIndex, int sourceIndex) {
        return targetIndex == sourceIndex ? array : ArrayTools.move_(array, targetIndex, sourceIndex);
    }

    private static <E> E[] move_(E[] array, int targetIndex, int sourceIndex) {
        E temp = array[sourceIndex];
        if (targetIndex < sourceIndex) {
            System.arraycopy(array, targetIndex, array, targetIndex + 1, sourceIndex - targetIndex);
        } else {
            System.arraycopy(array, sourceIndex + 1, array, sourceIndex, targetIndex - sourceIndex);
        }
        array[targetIndex] = temp;
        return array;
    }

    public static <E> E[] move(E[] array, int targetIndex, int sourceIndex, int length) {
        if (targetIndex == sourceIndex || length == 0) {
            return array;
        }
        if (length == 1) {
            return ArrayTools.move_(array, targetIndex, sourceIndex);
        }
        E[] temp = ArrayTools.newInstance(array, length);
        System.arraycopy(array, sourceIndex, temp, 0, length);
        if (targetIndex < sourceIndex) {
            System.arraycopy(array, targetIndex, array, targetIndex + length, sourceIndex - targetIndex);
        } else {
            System.arraycopy(array, sourceIndex + length, array, sourceIndex, targetIndex - sourceIndex);
        }
        System.arraycopy(temp, 0, array, targetIndex, length);
        return array;
    }

    public static int[] move(int[] array, int targetIndex, int sourceIndex) {
        return targetIndex == sourceIndex ? array : ArrayTools.move_(array, targetIndex, sourceIndex);
    }

    private static int[] move_(int[] array, int targetIndex, int sourceIndex) {
        int temp = array[sourceIndex];
        if (targetIndex < sourceIndex) {
            System.arraycopy(array, targetIndex, array, targetIndex + 1, sourceIndex - targetIndex);
        } else {
            System.arraycopy(array, sourceIndex + 1, array, sourceIndex, targetIndex - sourceIndex);
        }
        array[targetIndex] = temp;
        return array;
    }

    public static int[] move(int[] array, int targetIndex, int sourceIndex, int length) {
        if (targetIndex == sourceIndex || length == 0) {
            return array;
        }
        if (length == 1) {
            return ArrayTools.move_(array, targetIndex, sourceIndex);
        }
        int[] temp = new int[length];
        System.arraycopy(array, sourceIndex, temp, 0, length);
        if (targetIndex < sourceIndex) {
            System.arraycopy(array, targetIndex, array, targetIndex + length, sourceIndex - targetIndex);
        } else {
            System.arraycopy(array, sourceIndex + length, array, sourceIndex, targetIndex - sourceIndex);
        }
        System.arraycopy(temp, 0, array, targetIndex, length);
        return array;
    }

    public static char[] move(char[] array, int targetIndex, int sourceIndex) {
        return targetIndex == sourceIndex ? array : ArrayTools.move_(array, targetIndex, sourceIndex);
    }

    private static char[] move_(char[] array, int targetIndex, int sourceIndex) {
        char temp = array[sourceIndex];
        if (targetIndex < sourceIndex) {
            System.arraycopy(array, targetIndex, array, targetIndex + 1, sourceIndex - targetIndex);
        } else {
            System.arraycopy(array, sourceIndex + 1, array, sourceIndex, targetIndex - sourceIndex);
        }
        array[targetIndex] = temp;
        return array;
    }

    public static char[] move(char[] array, int targetIndex, int sourceIndex, int length) {
        if (targetIndex == sourceIndex || length == 0) {
            return array;
        }
        if (length == 1) {
            return ArrayTools.move_(array, targetIndex, sourceIndex);
        }
        char[] temp = new char[length];
        System.arraycopy(array, sourceIndex, temp, 0, length);
        if (targetIndex < sourceIndex) {
            System.arraycopy(array, targetIndex, array, targetIndex + length, sourceIndex - targetIndex);
        } else {
            System.arraycopy(array, sourceIndex + length, array, sourceIndex, targetIndex - sourceIndex);
        }
        System.arraycopy(temp, 0, array, targetIndex, length);
        return array;
    }

    public static <E> E[] remove(E[] array, Object value) {
        return ArrayTools.removeElementAtIndex(array, ArrayTools.indexOf(array, value));
    }

    public static char[] remove(char[] array, char value) {
        return ArrayTools.removeElementAtIndex(array, ArrayTools.indexOf(array, value));
    }

    public static int[] remove(int[] array, int value) {
        return ArrayTools.removeElementAtIndex(array, ArrayTools.indexOf(array, value));
    }

    public static <E> E[] removeFirst(E[] array) {
        return ArrayTools.removeElementAtIndex(array, 0);
    }

    public static char[] removeFirst(char[] array) {
        return ArrayTools.removeElementAtIndex(array, 0);
    }

    public static int[] removeFirst(int[] array) {
        return ArrayTools.removeElementAtIndex(array, 0);
    }

    public static <E> E[] removeLast(E[] array) {
        return ArrayTools.removeElementAtIndex(array, array.length - 1);
    }

    public static char[] removeLast(char[] array) {
        return ArrayTools.removeElementAtIndex(array, array.length - 1);
    }

    public static int[] removeLast(int[] array) {
        return ArrayTools.removeElementAtIndex(array, array.length - 1);
    }

    public static <E> E[] removeAll(E[] array, Iterable<?> iterable) {
        return ArrayTools.removeAll(array, iterable.iterator());
    }

    public static <E> E[] removeAll(E[] array, Iterable<?> iterable, int iterableSize) {
        return ArrayTools.removeAll(array, iterable.iterator(), iterableSize);
    }

    public static <E> E[] removeAll(E[] array, Iterator<?> iterator) {
        return iterator.hasNext() ? ArrayTools.removeAll_(array, CollectionTools.set(iterator)) : array;
    }

    public static <E> E[] removeAll(E[] array, Iterator<?> iterator, int iteratorSize) {
        return iterator.hasNext() ? ArrayTools.removeAll_(array, CollectionTools.set(iterator, iteratorSize)) : array;
    }

    public static <E> E[] removeAll(E[] array, Collection<?> collection) {
        return collection.isEmpty() ? array : ArrayTools.removeAll_(array, collection);
    }

    private static <E> E[] removeAll_(E[] array, Collection<?> collection) {
        return ArrayTools.removeAll(array, collection, array.length);
    }

    private static <E> E[] removeAll(E[] array, Collection<?> collection, int arrayLength) {
        return arrayLength == 0 ? array : ArrayTools.removeAll_(array, collection, arrayLength);
    }

    private static <E> E[] removeAll_(E[] array, Collection<?> collection, int arrayLength) {
        int[] indices = new int[arrayLength];
        int j = 0;
        int i = 0;
        while (i < arrayLength) {
            if (!collection.contains(array[i])) {
                indices[j++] = i;
            }
            ++i;
        }
        if (j == arrayLength) {
            return array;
        }
        E[] result = ArrayTools.newInstance(array, j);
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static <E> E[] removeAll(E[] array1, Object ... array2) {
        return array2.length == 0 ? array1 : ArrayTools.removeAll_(array1, CollectionTools.set(array2));
    }

    public static char[] removeAll(char[] array1, char ... array2) {
        if (array2.length == 0) {
            return array1;
        }
        int array1Length = array1.length;
        if (array1Length == 0) {
            return array1;
        }
        int[] indices = new int[array1Length];
        int j = 0;
        int i = 0;
        while (i < array1Length) {
            if (!ArrayTools.contains(array2, array1[i])) {
                indices[j++] = i;
            }
            ++i;
        }
        if (j == array1Length) {
            return array1;
        }
        char[] result = new char[j];
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array1[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static int[] removeAll(int[] array1, int ... array2) {
        if (array2.length == 0) {
            return array1;
        }
        int array1Length = array1.length;
        if (array1Length == 0) {
            return array1;
        }
        int[] indices = new int[array1Length];
        int j = 0;
        int i = 0;
        while (i < array1Length) {
            if (!ArrayTools.contains(array2, array1[i])) {
                indices[j++] = i;
            }
            ++i;
        }
        if (j == array1Length) {
            return array1;
        }
        int[] result = new int[j];
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array1[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static <E> E[] removeAllOccurrences(E[] array, Object value) {
        int i;
        int arrayLength = array.length;
        if (arrayLength == 0) {
            return array;
        }
        int[] indices = new int[arrayLength];
        int j = 0;
        if (value == null) {
            i = arrayLength;
            while (i-- > 0) {
                if (array[i] == null) continue;
                indices[j++] = i;
            }
        } else {
            i = array.length;
            while (i-- > 0) {
                if (value.equals(array[i])) continue;
                indices[j++] = i;
            }
        }
        if (j == arrayLength) {
            return array;
        }
        E[] result = ArrayTools.newInstance(array, j);
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static char[] removeAllOccurrences(char[] array, char value) {
        int arrayLength = array.length;
        if (arrayLength == 0) {
            return array;
        }
        int[] indices = new int[arrayLength];
        int j = 0;
        int i = arrayLength;
        while (i-- > 0) {
            if (array[i] == value) continue;
            indices[j++] = i;
        }
        if (j == arrayLength) {
            return array;
        }
        char[] result = new char[j];
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static int[] removeAllOccurrences(int[] array, int value) {
        int arrayLength = array.length;
        if (arrayLength == 0) {
            return array;
        }
        int[] indices = new int[arrayLength];
        int j = 0;
        int i = arrayLength;
        while (i-- > 0) {
            if (array[i] == value) continue;
            indices[j++] = i;
        }
        if (j == arrayLength) {
            return array;
        }
        int[] result = new int[j];
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static <E> E[] removeDuplicateElements(E ... array) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        LinkedHashSet<E> temp = new LinkedHashSet<E>(len);
        boolean modified = false;
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            if (!temp.add(item)) {
                modified = true;
            }
            ++n2;
        }
        return modified ? temp.toArray(ArrayTools.newInstance(array, temp.size())) : array;
    }

    public static <E> E[] removeElementAtIndex(E[] array, int index) {
        return ArrayTools.removeElementsAtIndex(array, index, 1);
    }

    public static char[] removeElementAtIndex(char[] array, int index) {
        return ArrayTools.removeElementsAtIndex(array, index, 1);
    }

    public static int[] removeElementAtIndex(int[] array, int index) {
        return ArrayTools.removeElementsAtIndex(array, index, 1);
    }

    public static <E> E[] removeElementsAtIndex(E[] array, int index, int length) {
        int length2;
        if (length == 0) {
            return array;
        }
        int arrayLength = array.length;
        int newLength = arrayLength - length;
        E[] result = ArrayTools.newInstance(array, newLength);
        if (newLength == 0 && index == 0) {
            return result;
        }
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if ((length2 = newLength - index) > 0) {
            System.arraycopy(array, index + length, result, index, length2);
        }
        return result;
    }

    public static char[] removeElementsAtIndex(char[] array, int index, int length) {
        int length2;
        if (length == 0) {
            return array;
        }
        int arrayLength = array.length;
        int newLength = arrayLength - length;
        if (newLength == 0 && index == 0) {
            return CharArrayTools.EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[newLength];
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if ((length2 = newLength - index) > 0) {
            System.arraycopy(array, index + length, result, index, length2);
        }
        return result;
    }

    public static int[] removeElementsAtIndex(int[] array, int index, int length) {
        int length2;
        if (length == 0) {
            return array;
        }
        int arrayLength = array.length;
        int newLength = arrayLength - length;
        if (newLength == 0 && index == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[newLength];
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if ((length2 = newLength - index) > 0) {
            System.arraycopy(array, index + length, result, index, length2);
        }
        return result;
    }

    public static <E> E[] replaceAll(E[] array, Object oldValue, E newValue) {
        if (oldValue == null) {
            int i = array.length;
            while (i-- > 0) {
                if (array[i] != null) continue;
                array[i] = newValue;
            }
        } else {
            int i = array.length;
            while (i-- > 0) {
                if (!oldValue.equals(array[i])) continue;
                array[i] = newValue;
            }
        }
        return array;
    }

    public static int[] replaceAll(int[] array, int oldValue, int newValue) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != oldValue) continue;
            array[i] = newValue;
        }
        return array;
    }

    public static char[] replaceAll(char[] array, char oldValue, char newValue) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != oldValue) continue;
            array[i] = newValue;
        }
        return array;
    }

    public static <E> E[] resize(E[] array, int length) {
        int arrayLength = array.length;
        if (arrayLength == length) {
            return array;
        }
        if (arrayLength > length) {
            return ArrayTools.subArray(array, 0, length);
        }
        return ArrayTools.expand(array, arrayLength, length);
    }

    public static <E> E[] expand(E[] array, int expansionSize) {
        if (expansionSize == 0) {
            return array;
        }
        int arrayLength = array.length;
        return ArrayTools.expand(array, arrayLength, arrayLength + expansionSize);
    }

    private static <E> E[] expand(E[] array, int arrayLength, int length) {
        E[] result = ArrayTools.newInstance(array, length);
        if (arrayLength > 0) {
            System.arraycopy(array, 0, result, 0, arrayLength);
        }
        return result;
    }

    public static <E> E[] retainAll(E[] array, Iterable<?> iterable) {
        int arrayLength = array.length;
        return arrayLength == 0 ? array : ArrayTools.retainAll(array, arrayLength, iterable.iterator());
    }

    public static <E> E[] retainAll(E[] array, Iterable<?> iterable, int iterableSize) {
        int arrayLength = array.length;
        return arrayLength == 0 ? array : ArrayTools.retainAll(array, arrayLength, iterable.iterator(), iterableSize);
    }

    public static <E> E[] retainAll(E[] array, Iterator<?> iterator) {
        int arrayLength = array.length;
        return arrayLength == 0 ? array : ArrayTools.retainAll(array, arrayLength, iterator);
    }

    public static <E> E[] retainAll(E[] array, Iterator<?> iterator, int iteratorSize) {
        int arrayLength = array.length;
        return arrayLength == 0 ? array : ArrayTools.retainAll(array, arrayLength, iterator, iteratorSize);
    }

    private static <E> E[] retainAll(E[] array, int arrayLength, Iterator<?> iterator) {
        return iterator.hasNext() ? ArrayTools.retainAll_(array, CollectionTools.set(iterator), arrayLength) : ArrayTools.newInstance(array, 0);
    }

    private static <E> E[] retainAll(E[] array, int arrayLength, Iterator<?> iterator, int iteratorSize) {
        return iterator.hasNext() ? ArrayTools.retainAll_(array, CollectionTools.set(iterator, iteratorSize), arrayLength) : ArrayTools.newInstance(array, 0);
    }

    public static <E> E[] retainAll(E[] array, Collection<?> collection) {
        int arrayLength = array.length;
        return arrayLength == 0 ? array : ArrayTools.retainAll(array, collection, arrayLength);
    }

    private static <E> E[] retainAll(E[] array, Collection<?> collection, int arrayLength) {
        return collection.isEmpty() ? ArrayTools.newInstance(array, 0) : ArrayTools.retainAll_(array, collection, arrayLength);
    }

    private static <E> E[] retainAll_(E[] array, Collection<?> collection, int arrayLength) {
        int[] indices = new int[arrayLength];
        int j = 0;
        int i = 0;
        while (i < arrayLength) {
            if (collection.contains(array[i])) {
                indices[j++] = i;
            }
            ++i;
        }
        if (j == arrayLength) {
            return array;
        }
        E[] result = ArrayTools.newInstance(array, j);
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static <E> E[] retainAll(E[] array1, Object[] array2) {
        int array1Length = array1.length;
        return array1Length == 0 ? array1 : (array2.length == 0 ? ArrayTools.newInstance(array1, 0) : ArrayTools.retainAll(array1, CollectionTools.set(array2), array1Length));
    }

    public static char[] retainAll(char[] array1, char ... array2) {
        int array1Length = array1.length;
        return array1Length == 0 ? array1 : ArrayTools.retainAll(array1, array2, array1Length);
    }

    private static char[] retainAll(char[] array1, char[] array2, int array1Length) {
        int array2Length = array2.length;
        return array2Length == 0 ? CharArrayTools.EMPTY_CHAR_ARRAY : ArrayTools.retainAll(array1, array2, array1Length, array2Length);
    }

    private static char[] retainAll(char[] array1, char[] array2, int array1Length, int array2Length) {
        int[] indices = new int[array1Length];
        int j = 0;
        int i = 0;
        while (i < array1Length) {
            if (ArrayTools.contains_(array2, array1[i], array2Length)) {
                indices[j++] = i;
            }
            ++i;
        }
        if (j == array1Length) {
            return array1;
        }
        char[] result = new char[j];
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array1[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static int[] retainAll(int[] array1, int ... array2) {
        int array1Length = array1.length;
        return array1Length == 0 ? array1 : ArrayTools.retainAll(array1, array2, array1Length);
    }

    private static int[] retainAll(int[] array1, int[] array2, int array1Length) {
        int array2Length = array2.length;
        return array2Length == 0 ? EMPTY_INT_ARRAY : ArrayTools.retainAll(array1, array2, array1Length, array2Length);
    }

    private static int[] retainAll(int[] array1, int[] array2, int array1Length, int array2Length) {
        int[] indices = new int[array1Length];
        int j = 0;
        int i = 0;
        while (i < array1Length) {
            if (ArrayTools.contains_(array2, array1[i], array2Length)) {
                indices[j++] = i;
            }
            ++i;
        }
        if (j == array1Length) {
            return array1;
        }
        int[] result = new int[j];
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array1[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static <E> E[] reverse(E ... array) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        int i = 0;
        int mid = len >> 1;
        int j = len - 1;
        while (i < mid) {
            ArrayTools.swap(array, i, j);
            ++i;
            --j;
        }
        return array;
    }

    public static char[] reverse(char ... array) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        int i = 0;
        int mid = len >> 1;
        int j = len - 1;
        while (i < mid) {
            ArrayTools.swap(array, i, j);
            ++i;
            --j;
        }
        return array;
    }

    public static int[] reverse(int ... array) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        int i = 0;
        int mid = len >> 1;
        int j = len - 1;
        while (i < mid) {
            ArrayTools.swap(array, i, j);
            ++i;
            --j;
        }
        return array;
    }

    public static <E> E[] rotate(E ... array) {
        return ArrayTools.rotate(array, 1);
    }

    public static <E> E[] rotate(E[] array, int distance) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return array;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != len) {
            E displaced = array[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                E temp = array[i];
                array[i] = displaced;
                displaced = temp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
        return array;
    }

    public static char[] rotate(char ... array) {
        return ArrayTools.rotate(array, 1);
    }

    public static char[] rotate(char[] array, int distance) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return array;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != len) {
            char displaced = array[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                char temp = array[i];
                array[i] = displaced;
                displaced = temp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
        return array;
    }

    public static int[] rotate(int ... array) {
        return ArrayTools.rotate(array, 1);
    }

    public static int[] rotate(int[] array, int distance) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return array;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != len) {
            int displaced = array[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                int temp = array[i];
                array[i] = displaced;
                displaced = temp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
        return array;
    }

    public static <E> E[] shuffle(E ... array) {
        return ArrayTools.shuffle(array, RANDOM);
    }

    public static <E> E[] shuffle(E[] array, Random random) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        int i = len;
        while (i-- > 0) {
            ArrayTools.swap(array, i, random.nextInt(len));
        }
        return array;
    }

    public static char[] shuffle(char ... array) {
        return ArrayTools.shuffle(array, RANDOM);
    }

    public static char[] shuffle(char[] array, Random random) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        int i = len;
        while (i-- > 0) {
            ArrayTools.swap(array, i, random.nextInt(len));
        }
        return array;
    }

    public static int[] shuffle(int ... array) {
        return ArrayTools.shuffle(array, RANDOM);
    }

    public static int[] shuffle(int[] array, Random random) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        int i = len;
        while (i-- > 0) {
            ArrayTools.swap(array, i, random.nextInt(len));
        }
        return array;
    }

    public static <E> E[] subArray(E[] array, int index) {
        return index == 0 ? array : ArrayTools.subArray_(array, index, array.length);
    }

    public static <E> E[] subArray(E[] array, int fromIndex, int toIndex) {
        return fromIndex == 0 && toIndex == array.length ? array : ArrayTools.subArray_(array, fromIndex, toIndex);
    }

    private static <E> E[] subArray_(E[] array, int fromIndex, int toIndex) {
        int len = toIndex - fromIndex;
        E[] result = ArrayTools.newInstance(array, len);
        if (len > 0) {
            System.arraycopy(array, fromIndex, result, 0, len);
        }
        return result;
    }

    public static int[] subArray(int[] array, int index) {
        return index == 0 ? array : ArrayTools.subArray_(array, index, array.length);
    }

    public static int[] subArray(int[] array, int fromIndex, int toIndex) {
        return fromIndex == 0 && toIndex == array.length ? array : ArrayTools.subArray_(array, fromIndex, toIndex);
    }

    private static int[] subArray_(int[] array, int fromIndex, int toIndex) {
        int len = toIndex - fromIndex;
        if (len == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[len];
        System.arraycopy(array, fromIndex, result, 0, len);
        return result;
    }

    public static char[] subArray(char[] array, int index) {
        return index == 0 ? array : ArrayTools.subArray_(array, index, array.length);
    }

    public static char[] subArray(char[] array, int fromIndex, int toIndex) {
        return fromIndex == 0 && toIndex == array.length ? array : ArrayTools.subArray_(array, fromIndex, toIndex);
    }

    private static char[] subArray_(char[] array, int fromIndex, int toIndex) {
        int len = toIndex - fromIndex;
        return len == 0 ? CharArrayTools.EMPTY_CHAR_ARRAY : ArrayTools.subArrayLength(array, fromIndex, len);
    }

    static char[] subArrayLength(char[] array, int fromIndex, int length) {
        char[] result = new char[length];
        System.arraycopy(array, fromIndex, result, 0, length);
        return result;
    }

    public static <E> E[] swap(E[] array, int i, int j) {
        return i == j ? array : ArrayTools.swap_(array, i, j);
    }

    private static <E> E[] swap_(E[] array, int i, int j) {
        E temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        return array;
    }

    public static char[] swap(char[] array, int i, int j) {
        return i == j ? array : ArrayTools.swap_(array, i, j);
    }

    private static char[] swap_(char[] array, int i, int j) {
        char temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        return array;
    }

    public static int[] swap(int[] array, int i, int j) {
        return i == j ? array : ArrayTools.swap_(array, i, j);
    }

    private static int[] swap_(int[] array, int i, int j) {
        int temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        return array;
    }

    public static <E> void execute(E[] array, ParameterizedCommand<E> command) {
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            command.execute(e);
            ++n2;
        }
    }

    public static <E> void execute(E[] array, ParameterizedCommand<E> command, ExceptionHandler exceptionHandler) {
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            try {
                command.execute(e);
            }
            catch (Throwable ex) {
                exceptionHandler.handleException(ex);
            }
            ++n2;
        }
    }

    public static <E> void execute(E[] array, InterruptibleParameterizedCommand<E> command) throws InterruptedException {
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            command.execute(e);
            ++n2;
        }
    }

    public static <E> void execute(E[] array, InterruptibleParameterizedCommand<E> command, ExceptionHandler exceptionHandler) throws InterruptedException {
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            try {
                command.execute(e);
            }
            catch (InterruptedException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                exceptionHandler.handleException(ex);
            }
            ++n2;
        }
    }

    public static <E> E[] filter(E[] array, Predicate<E> filter) {
        int length = array.length;
        E[] result = ArrayTools.newInstance(array, length);
        int resultLength = 0;
        int i = 0;
        while (i < length) {
            E e = array[i];
            if (filter.evaluate(e)) {
                result[resultLength++] = e;
            }
            ++i;
        }
        return resultLength < length ? ArrayTools.subArray(result, 0, resultLength) : result;
    }

    public static <E> Object[] transform(E[] array, Transformer<E, ?> transformer) {
        return ArrayTools.transform(array, transformer, OBJECT_CLASS);
    }

    public static <E1, E2> E2[] transform(E1[] array, Transformer<E1, ? extends E2> transformer, Class<E2> componentType) {
        int length = array.length;
        E2[] result = ArrayTools.newInstance(componentType, length);
        int i = length;
        while (i-- > 0) {
            result[i] = transformer.transform(array[i]);
        }
        return result;
    }

    public static boolean notEquals(boolean[] array1, boolean[] array2) {
        return !Arrays.equals(array1, array2);
    }

    public static boolean notEquals(byte[] array1, byte[] array2) {
        return !Arrays.equals(array1, array2);
    }

    public static boolean notEquals(char[] array1, char[] array2) {
        return !Arrays.equals(array1, array2);
    }

    public static boolean notEquals(double[] array1, double[] array2) {
        return !Arrays.equals(array1, array2);
    }

    public static boolean notEquals(float[] array1, float[] array2) {
        return !Arrays.equals(array1, array2);
    }

    public static boolean notEquals(int[] array1, int[] array2) {
        return !Arrays.equals(array1, array2);
    }

    public static boolean notEquals(Object[] array1, Object[] array2) {
        return !Arrays.equals(array1, array2);
    }

    public static boolean notEquals(long[] array1, long[] array2) {
        return !Arrays.equals(array1, array2);
    }

    public static boolean notEquals(short[] array1, short[] array2) {
        return !Arrays.equals(array1, array2);
    }

    public static boolean[] fill(boolean[] array, boolean value) {
        Arrays.fill(array, value);
        return array;
    }

    public static boolean[] fill(boolean[] array, int fromIndex, int toIndex, boolean value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static byte[] fill(byte[] array, byte value) {
        Arrays.fill(array, value);
        return array;
    }

    public static byte[] fill(byte[] array, int fromIndex, int toIndex, byte value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static char[] fill(char[] array, char value) {
        Arrays.fill(array, value);
        return array;
    }

    public static char[] fill(char[] array, int fromIndex, int toIndex, char value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static double[] fill(double[] array, double value) {
        Arrays.fill(array, value);
        return array;
    }

    public static double[] fill(double[] array, int fromIndex, int toIndex, double value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static float[] fill(float[] array, float value) {
        Arrays.fill(array, value);
        return array;
    }

    public static float[] fill(float[] array, int fromIndex, int toIndex, float value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static int[] fill(int[] array, int value) {
        Arrays.fill(array, value);
        return array;
    }

    public static int[] fill(int[] array, int fromIndex, int toIndex, int value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static <E> E[] fill(E[] array, E value) {
        Arrays.fill(array, value);
        return array;
    }

    public static <E> E[] fill(E[] array, int fromIndex, int toIndex, E value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static long[] fill(long[] array, long value) {
        Arrays.fill(array, value);
        return array;
    }

    public static long[] fill(long[] array, int fromIndex, int toIndex, long value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static short[] fill(short[] array, short value) {
        Arrays.fill(array, value);
        return array;
    }

    public static short[] fill(short[] array, int fromIndex, int toIndex, short value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static byte[] sort(byte ... array) {
        Arrays.sort(array);
        return array;
    }

    public static byte[] sort(byte[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static char[] sort(char ... array) {
        Arrays.sort(array);
        return array;
    }

    public static char[] sort(char[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static double[] sort(double ... array) {
        Arrays.sort(array);
        return array;
    }

    public static double[] sort(double[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static float[] sort(float ... array) {
        Arrays.sort(array);
        return array;
    }

    public static float[] sort(float[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static int[] sort(int ... array) {
        Arrays.sort(array);
        return array;
    }

    public static int[] sort(int[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static <E> E[] sort(E ... array) {
        Arrays.sort(array);
        return array;
    }

    public static <E> E[] sort(E[] array, Comparator<? super E> comparator) {
        Arrays.sort(array, comparator);
        return array;
    }

    public static <E> E[] sort(E[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static <E> E[] sort(E[] array, int fromIndex, int toIndex, Comparator<? super E> comparator) {
        Arrays.sort(array, fromIndex, toIndex, comparator);
        return array;
    }

    public static long[] sort(long ... array) {
        Arrays.sort(array);
        return array;
    }

    public static long[] sort(long[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static short[] sort(short ... array) {
        Arrays.sort(array);
        return array;
    }

    public static short[] sort(short[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static boolean binarySearch(byte[] array, byte value) {
        return Arrays.binarySearch(array, value) >= 0;
    }

    public static boolean binarySearch(char[] array, char value) {
        return Arrays.binarySearch(array, value) >= 0;
    }

    public static boolean binarySearch(double[] array, double value) {
        return Arrays.binarySearch(array, value) >= 0;
    }

    public static boolean binarySearch(float[] array, float value) {
        return Arrays.binarySearch(array, value) >= 0;
    }

    public static boolean binarySearch(int[] array, int value) {
        return Arrays.binarySearch(array, value) >= 0;
    }

    public static boolean binarySearch(long[] array, long value) {
        return Arrays.binarySearch(array, value) >= 0;
    }

    public static boolean binarySearch(Object[] array, Object value) {
        return Arrays.binarySearch(array, value) >= 0;
    }

    public static <T> boolean binarySearch(T[] array, T value, Comparator<? super T> comparator) {
        return Arrays.binarySearch(array, value, comparator) >= 0;
    }

    public static boolean binarySearch(short[] array, short value) {
        return Arrays.binarySearch(array, value) >= 0;
    }

    private ArrayTools() {
        throw new UnsupportedOperationException();
    }
}

