/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.util.concurrent.ThreadFactory;
import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.SimpleThreadFactory;

public class ConsumerThreadCoordinator {
    private final Runnable runnable;
    private final ThreadFactory threadFactory;
    private final String threadName;
    private volatile Thread thread;
    final ExceptionHandler exceptionHandler;

    public ConsumerThreadCoordinator(Consumer consumer, ExceptionHandler exceptionHandler) {
        this(consumer, null, exceptionHandler);
    }

    public ConsumerThreadCoordinator(Consumer consumer, String threadName, ExceptionHandler exceptionHandler) {
        this(consumer, SimpleThreadFactory.instance(), threadName, exceptionHandler);
    }

    public ConsumerThreadCoordinator(Consumer consumer, ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
        this.runnable = this.buildRunnable(consumer);
        if (threadFactory == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
        this.threadName = threadName;
        this.exceptionHandler = exceptionHandler;
    }

    private Runnable buildRunnable(Consumer consumer) {
        return new RunnableConsumer(consumer);
    }

    public synchronized void start() {
        if (this.thread != null) {
            throw new IllegalStateException("Not stopped.");
        }
        this.thread = this.buildThread();
        this.thread.start();
    }

    private Thread buildThread() {
        Thread t = this.threadFactory.newThread(this.runnable);
        if (this.threadName != null) {
            t.setName(this.threadName);
        }
        return t;
    }

    public synchronized void stop() throws InterruptedException {
        if (this.thread == null) {
            throw new IllegalStateException("Not started.");
        }
        this.thread.interrupt();
        this.thread.join();
        this.thread = null;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.thread);
    }

    public static interface Consumer {
        public void waitForProducer() throws InterruptedException;

        public void consume();
    }

    private class RunnableConsumer
    implements Runnable {
        private final Consumer consumer;

        RunnableConsumer(Consumer consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            this.consumer = consumer;
        }

        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.consumer.waitForProducer();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (Throwable ex) {
                    ConsumerThreadCoordinator.this.exceptionHandler.handleException(ex);
                    return;
                }
                this.consume();
            }
        }

        private void consume() {
            try {
                this.consumer.consume();
            }
            catch (Throwable ex) {
                ConsumerThreadCoordinator.this.exceptionHandler.handleException(ex);
            }
        }
    }
}

