/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTrace
implements Serializable {
    private final Thread thread;
    private final StackTraceElement[] elements;
    private volatile String string;
    private static final long serialVersionUID = 1L;

    public StackTrace() {
        this(StringTools.EMPTY_STRING_ARRAY);
    }

    public StackTrace(Class<?> ... traceClasses) {
        this(StackTrace.convertToNames(traceClasses));
    }

    public StackTrace(String ... traceClasses) {
        this(Thread.currentThread(), traceClasses);
    }

    public StackTrace(Thread thread) {
        this(thread, StringTools.EMPTY_STRING_ARRAY);
    }

    public StackTrace(Thread thread, Class<?> ... traceClasses) {
        this(thread, StackTrace.convertToNames(traceClasses));
    }

    public StackTrace(Thread thread, String ... traceClasses) {
        if (thread == null || traceClasses == null) {
            throw new NullPointerException();
        }
        this.thread = thread;
        this.elements = this.buildElements(traceClasses);
    }

    private static String[] convertToNames(Class<?>[] classes) {
        int len = classes.length;
        if (len == 0) {
            return StringTools.EMPTY_STRING_ARRAY;
        }
        String[] names = new String[len];
        int i = 0;
        while (i < len) {
            names[i] = classes[i].getName();
            ++i;
        }
        return names;
    }

    private StackTraceElement[] buildElements(String[] traceClasses) {
        StackTraceElement[] result = this.thread.getStackTrace();
        int len = result.length;
        if (len == 0) {
            return result;
        }
        traceClasses = ArrayTools.add(traceClasses, this.getClass().getName());
        boolean found = false;
        int i = 0;
        while (i < len) {
            if (ArrayTools.contains(traceClasses, result[i].getClassName())) {
                found = true;
            } else if (found) break;
            ++i;
        }
        return found ? ArrayTools.subArray(result, i, len) : result;
    }

    public Thread getThread() {
        return this.thread;
    }

    public Iterable<StackTraceElement> getElements() {
        return IterableTools.iterable(this.elements);
    }

    public void appendTo(Appendable stream) throws IOException {
        this.appendTo(stream, null);
    }

    public void appendTo(Appendable stream, String prefix) throws IOException {
        StackTraceElement[] stackTraceElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            if (prefix != null) {
                stream.append(prefix);
            }
            stream.append(String.valueOf(element)).append(StringTools.CR);
            ++n2;
        }
    }

    public String toString() {
        return this.getString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getString() {
        if (this.string == null) {
            StackTrace stackTrace = this;
            synchronized (stackTrace) {
                if (this.string == null) {
                    this.string = this.buildString();
                }
            }
        }
        return this.string;
    }

    private String buildString() {
        StringBuffer sb = new StringBuffer(1000);
        try {
            this.appendTo(sb);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sb.toString();
    }
}

