/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.common.utility.internal.NullExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSafeCommandContext<E extends CommandContext>
implements CommandContext {
    protected final E commandContext;
    protected final ExceptionHandler exceptionHandler;

    protected AbstractSafeCommandContext(E commandContext) {
        this(commandContext, NullExceptionHandler.instance());
    }

    protected AbstractSafeCommandContext(E commandContext, ExceptionHandler exceptionHandler) {
        if (commandContext == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.commandContext = commandContext;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void execute(Command command) {
        try {
            this.commandContext.execute(command);
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.commandContext);
    }
}

