/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import java.util.ArrayList;
import java.util.concurrent.ThreadFactory;
import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.RepeatingCommand;
import org.eclipse.jpt.common.utility.internal.ConsumerThreadCoordinator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.RuntimeExceptionHandler;
import org.eclipse.jpt.common.utility.internal.SimpleThreadFactory;
import org.eclipse.jpt.common.utility.internal.StackTrace;
import org.eclipse.jpt.common.utility.internal.reference.SynchronizedBoolean;

public class AsynchronousRepeatingCommandWrapper
implements RepeatingCommand {
    final SynchronizedBoolean executeFlag = new SynchronizedBoolean(false);
    private final ConsumerThreadCoordinator consumerThreadCoordinator;
    private final ArrayList<StackTrace> stackTraces = null;
    private static final boolean DEBUG = false;

    public AsynchronousRepeatingCommandWrapper(Command command, ExceptionHandler exceptionHandler) {
        this(command, null, null, exceptionHandler);
    }

    public AsynchronousRepeatingCommandWrapper(Command command, String threadName, ExceptionHandler exceptionHandler) {
        this(command, null, threadName, exceptionHandler);
    }

    public AsynchronousRepeatingCommandWrapper(Config config) {
        this(config.getCommand(), config.getThreadFactory(), config.getThreadName(), config.getExceptionHandler());
    }

    public AsynchronousRepeatingCommandWrapper(Command command, ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
        this.consumerThreadCoordinator = new ConsumerThreadCoordinator(this.buildConsumer(command), threadFactory, threadName, exceptionHandler);
    }

    ConsumerThreadCoordinator.Consumer buildConsumer(Command command) {
        return new Consumer(command);
    }

    public void start() {
        this.consumerThreadCoordinator.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        SynchronizedBoolean synchronizedBoolean = this.executeFlag;
        synchronized (synchronizedBoolean) {
            this.executeFlag.setTrue();
        }
    }

    public void stop() throws InterruptedException {
        this.consumerThreadCoordinator.stop();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.consumerThreadCoordinator);
    }

    public static interface Config {
        public Command getCommand();

        public ThreadFactory getThreadFactory();

        public String getThreadName();

        public ExceptionHandler getExceptionHandler();
    }

    class Consumer
    implements ConsumerThreadCoordinator.Consumer {
        private final Command command;

        Consumer(Command command) {
            if (command == null) {
                throw new NullPointerException();
            }
            this.command = command;
        }

        public void waitForProducer() throws InterruptedException {
            AsynchronousRepeatingCommandWrapper.this.executeFlag.waitToSetFalse();
        }

        public void consume() {
            this.command.execute();
        }

        public String toString() {
            return ObjectTools.toString((Object)this, this.command);
        }
    }

    protected static abstract class SimpleConfig
    implements Config {
        private volatile Command command;
        private volatile ThreadFactory threadFactory;
        private volatile String threadName;
        private volatile ExceptionHandler exceptionHandler;

        protected SimpleConfig() {
            this.command = this.buildDefaultCommand();
            this.threadFactory = this.buildDefaultThreadFactory();
            this.threadName = this.buildDefaultThreadName();
            this.exceptionHandler = this.buildDefaultExceptionHandler();
        }

        protected SimpleConfig(Command command, ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
            this.command = command;
            this.threadFactory = threadFactory;
            this.threadName = threadName;
            this.exceptionHandler = exceptionHandler;
        }

        public void setCommand(Command command) {
            this.command = command;
        }

        public Command getCommand() {
            return this.command;
        }

        protected abstract Command buildDefaultCommand();

        public void setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        protected ThreadFactory buildDefaultThreadFactory() {
            return SimpleThreadFactory.instance();
        }

        public void setThreadName(String threadName) {
            this.threadName = threadName;
        }

        public String getThreadName() {
            return this.threadName;
        }

        protected String buildDefaultThreadName() {
            return null;
        }

        public void setExceptionHandler(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
        }

        public ExceptionHandler getExceptionHandler() {
            return this.exceptionHandler;
        }

        protected ExceptionHandler buildDefaultExceptionHandler() {
            return RuntimeExceptionHandler.instance();
        }
    }
}

