/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.command.NullCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalCommand
implements Command {
    protected final ThreadLocal<Command> threadLocal;
    protected final Command defaultCommand;

    public ThreadLocalCommand() {
        this(NullCommand.instance());
    }

    public ThreadLocalCommand(Command defaultCommand) {
        if (defaultCommand == null) {
            throw new NullPointerException();
        }
        this.defaultCommand = defaultCommand;
        this.threadLocal = this.buildThreadLocal();
    }

    protected ThreadLocal<Command> buildThreadLocal() {
        return new ThreadLocal<Command>();
    }

    @Override
    public void execute() {
        this.get().execute();
    }

    protected Command get() {
        Command command = this.threadLocal.get();
        return command != null ? command : this.defaultCommand;
    }

    public void set(Command command) {
        this.threadLocal.set(command);
    }

    public String toString() {
        return this.get().toString();
    }
}

