/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.model.value.PropertyValueModelWrapper;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.predicate.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicatePropertyValueModel<V>
extends PropertyValueModelWrapper<V>
implements PropertyValueModel<Boolean> {
    protected volatile Boolean value;
    protected final Predicate<? super V> predicate;

    public PredicatePropertyValueModel(PropertyValueModel<? extends V> valueModel, Predicate<? super V> predicate) {
        super(valueModel);
        if (predicate == null) {
            throw new NullPointerException();
        }
        this.predicate = predicate;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    protected void wrappedValueChanged(V oldValue, V newValue) {
        Boolean old = this.value;
        this.value = this.evaluate(newValue);
        this.firePropertyChanged("value", old, this.value);
    }

    protected Boolean evaluate(V v) {
        return this.predicate.evaluate(v);
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.value = this.evaluate(this.valueModel.getValue());
    }

    @Override
    protected void disengageModel() {
        this.value = null;
        super.disengageModel();
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }
}

