/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.predicate;

import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationPredicate<I, O>
implements Predicate<I> {
    protected final Predicate<? super O> predicate;
    protected final Transformer<? super I, O> transformer;

    public TransformationPredicate(Predicate<? super O> predicate, Transformer<? super I, O> transformer) {
        if (predicate == null || transformer == null) {
            throw new NullPointerException();
        }
        this.predicate = predicate;
        this.transformer = transformer;
    }

    @Override
    public boolean evaluate(I variable) {
        return this.predicate.evaluate(this.transformer.transform(variable));
    }

    public Predicate<? super O> getPredicate() {
        return this.predicate;
    }

    public Transformer<? super I, O> getTransformer() {
        return this.transformer;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TransformationPredicate)) {
            return false;
        }
        TransformationPredicate other = (TransformationPredicate)o;
        return this.predicate.equals(other.predicate) && this.transformer.equals(other.transformer);
    }

    public int hashCode() {
        return this.predicate.hashCode() ^ this.transformer.hashCode();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.predicate);
    }
}

