/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.reference;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.jpt.common.utility.command.InterruptibleCommand;
import org.eclipse.jpt.common.utility.command.InterruptibleCommandContext;
import org.eclipse.jpt.common.utility.reference.ModifiableBooleanReference;

public class SynchronizedBoolean
implements InterruptibleCommandContext,
ModifiableBooleanReference,
Cloneable,
Serializable {
    private boolean value;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedBoolean(boolean value, Object mutex) {
        this.value = value;
        this.mutex = mutex;
    }

    public SynchronizedBoolean(boolean value) {
        this.value = value;
        this.mutex = this;
    }

    public SynchronizedBoolean(Object mutex) {
        this(false, mutex);
    }

    public SynchronizedBoolean() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getValue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean is(boolean b) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value == b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNot(boolean b) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value ^ b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTrue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFalse() {
        Object object = this.mutex;
        synchronized (object) {
            return !this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setValue(boolean value) {
        Object object = this.mutex;
        synchronized (object) {
            return value == this.value ? value : !this.setChangedValue_(value);
        }
    }

    private boolean setChangedValue_(boolean v) {
        this.value = v;
        this.mutex.notifyAll();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flip() {
        Object object = this.mutex;
        synchronized (object) {
            return this.setChangedValue_(!this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean and(boolean b) {
        Object object = this.mutex;
        synchronized (object) {
            return this.setValue_(this.value & b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean or(boolean b) {
        Object object = this.mutex;
        synchronized (object) {
            return this.setValue_(this.value | b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean xor(boolean b) {
        Object object = this.mutex;
        synchronized (object) {
            return this.setValue_(this.value ^ b);
        }
    }

    private boolean setValue_(boolean v) {
        return v == this.value ? v : this.setChangedValue_(v);
    }

    public boolean setNot(boolean b) {
        return this.setValue(!b);
    }

    public boolean setTrue() {
        return this.setValue(true);
    }

    public boolean setFalse() {
        return this.setValue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit(boolean expectedValue, boolean newValue) {
        Object object = this.mutex;
        synchronized (object) {
            boolean success;
            boolean bl = success = this.value == expectedValue;
            if (success) {
                this.setValue_(newValue);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swap(SynchronizedBoolean other) {
        if (other == this) {
            return this.getValue();
        }
        boolean thisFirst = System.identityHashCode(this) < System.identityHashCode(other);
        SynchronizedBoolean first = thisFirst ? this : other;
        SynchronizedBoolean second = thisFirst ? other : this;
        Object object = first.mutex;
        synchronized (object) {
            Object object2 = second.mutex;
            synchronized (object2) {
                boolean thisValue = this.value;
                boolean otherValue = other.value;
                if (thisValue == otherValue) {
                    return thisValue;
                }
                other.setChangedValue_(thisValue);
                return this.setChangedValue_(otherValue);
            }
        }
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIs(boolean b) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs_(b);
        }
    }

    private void waitUntilValueIs_(boolean b) throws InterruptedException {
        while (this.value != b) {
            this.mutex.wait();
        }
    }

    public void waitUntilValueIsNot(boolean b) throws InterruptedException {
        this.waitUntilValueIs(!b);
    }

    public void waitUntilTrue() throws InterruptedException {
        this.waitUntilValueIs(true);
    }

    public void waitUntilFalse() throws InterruptedException {
        this.waitUntilValueIs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetValue(boolean b) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs_(!b);
            this.setChangedValue_(b);
        }
    }

    public void waitToSetTrue() throws InterruptedException {
        this.waitToSetValue(true);
    }

    public void waitToSetFalse() throws InterruptedException {
        this.waitToSetValue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whenEqual(boolean b, InterruptibleCommand command) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs_(b);
            command.execute();
        }
    }

    public void whenNotEqual(boolean b, InterruptibleCommand command) throws InterruptedException {
        this.whenEqual(!b, command);
    }

    public void whenTrue(InterruptibleCommand command) throws InterruptedException {
        this.whenEqual(true, command);
    }

    public void whenFalse(InterruptibleCommand command) throws InterruptedException {
        this.whenEqual(false, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIs(boolean b, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIs_(b, timeout);
        }
    }

    private boolean waitUntilValueIs_(boolean b, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilValueIs_(b);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (this.value != b && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.value == b;
    }

    public boolean waitUntilValueIsNot(boolean b, long timeout) throws InterruptedException {
        return this.waitUntilValueIs(!b, timeout);
    }

    public boolean waitUntilTrue(long timeout) throws InterruptedException {
        return this.waitUntilValueIs(true, timeout);
    }

    public boolean waitUntilFalse(long timeout) throws InterruptedException {
        return this.waitUntilValueIs(false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetValue(boolean b, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilValueIs_(!b, timeout);
            if (success) {
                this.setChangedValue_(b);
            }
            return success;
        }
    }

    public boolean waitToSetTrue(long timeout) throws InterruptedException {
        return this.waitToSetValue(true, timeout);
    }

    public boolean waitToSetFalse(long timeout) throws InterruptedException {
        return this.waitToSetValue(false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean whenEqual(boolean b, InterruptibleCommand command, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilValueIs_(b, timeout);
            if (success) {
                command.execute();
            }
            return success;
        }
    }

    public boolean whenNotEqual(boolean b, InterruptibleCommand command, long timeout) throws InterruptedException {
        return this.whenEqual(!b, command, timeout);
    }

    public boolean whenTrue(InterruptibleCommand command, long timeout) throws InterruptedException {
        return this.whenEqual(true, command, timeout);
    }

    public boolean whenFalse(InterruptibleCommand command, long timeout) throws InterruptedException {
        return this.whenEqual(false, command, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(InterruptibleCommand command) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedBoolean clone() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                return (SynchronizedBoolean)super.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.getValue()) + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            s.defaultWriteObject();
        }
    }
}

