/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.beans.Introspector;
import java.util.List;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.context.AbstractQName;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.TypeKind;
import org.eclipse.jpt.jaxb.core.context.TypeName;
import org.eclipse.jpt.jaxb.core.context.XmlRootElement;
import org.eclipse.jpt.jaxb.core.context.XmlSeeAlso;
import org.eclipse.jpt.jaxb.core.context.java.JavaType;
import org.eclipse.jpt.jaxb.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractQNameAnnotationProxy;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlSeeAlso;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRootElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSeeAlsoAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTransientAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTypeAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTypeMapping
extends AbstractJavaContextNode
implements JavaTypeMapping {
    protected boolean xmlTransient;
    protected final JaxbQName qName;
    protected XmlRootElement xmlRootElement;
    protected XmlSeeAlso xmlSeeAlso;

    protected AbstractJavaTypeMapping(JavaType parent) {
        super(parent);
        this.initXmlTransient();
        this.qName = this.buildQName();
        this.initXmlRootElement();
        this.initializeXmlSeeAlso();
    }

    @Override
    public JavaType getJavaType() {
        return (JavaType)this.getParent();
    }

    protected JavaResourceAbstractType getJavaResourceType() {
        return this.getJavaType().getJavaResourceType();
    }

    @Override
    public TypeKind getTypeKind() {
        return this.getJavaType().getKind();
    }

    @Override
    public TypeName getTypeName() {
        return this.getJavaType().getTypeName();
    }

    @Override
    public JaxbPackage getJaxbPackage() {
        return this.getJavaType().getJaxbPackage();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncXmlTransient();
        this.qName.synchronizeWithResourceModel();
        this.syncXmlRootElement();
        this.syncXmlSeeAlso();
    }

    @Override
    public void update() {
        super.update();
        this.qName.update();
        this.updateXmlRootElement();
        this.updateXmlSeeAlso();
    }

    @Override
    public boolean isXmlTransient() {
        return this.xmlTransient;
    }

    @Override
    public void setXmlTransient(boolean newValue) {
        if (newValue) {
            this.getJavaResourceType().addAnnotation("javax.xml.bind.annotation.XmlTransient");
        } else {
            this.getJavaResourceType().removeAnnotation("javax.xml.bind.annotation.XmlTransient");
        }
        this.setXmlTransient_(newValue);
    }

    protected void setXmlTransient_(boolean newValue) {
        boolean old = this.xmlTransient;
        this.xmlTransient = newValue;
        this.firePropertyChanged("xmlTransient", old, newValue);
    }

    protected XmlTransientAnnotation getXmlTransientAnnotation() {
        return (XmlTransientAnnotation)this.getJavaResourceType().getAnnotation("javax.xml.bind.annotation.XmlTransient");
    }

    protected void initXmlTransient() {
        this.xmlTransient = this.getXmlTransientAnnotation() != null;
    }

    protected void syncXmlTransient() {
        this.setXmlTransient_(this.getXmlTransientAnnotation() != null);
    }

    @Override
    public JaxbQName getQName() {
        return this.qName;
    }

    protected JaxbQName buildQName() {
        return new XmlTypeQName(this);
    }

    protected XmlTypeAnnotation getXmlTypeAnnotation() {
        return (XmlTypeAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlType");
    }

    @Override
    public XmlRootElement getXmlRootElement() {
        return this.xmlRootElement;
    }

    protected void setXmlRootElement_(XmlRootElement rootElement) {
        XmlRootElement old = this.xmlRootElement;
        this.xmlRootElement = rootElement;
        this.firePropertyChanged("xmlRootElement", old, rootElement);
    }

    @Override
    public XmlRootElement addXmlRootElement() {
        if (this.xmlRootElement != null) {
            throw new IllegalStateException();
        }
        XmlRootElementAnnotation annotation = (XmlRootElementAnnotation)this.getJavaResourceType().addAnnotation("javax.xml.bind.annotation.XmlRootElement");
        XmlRootElement xmlRootElement = this.buildXmlRootElement(annotation);
        this.setXmlRootElement_(xmlRootElement);
        return xmlRootElement;
    }

    @Override
    public void removeXmlRootElement() {
        if (this.xmlRootElement == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceType().removeAnnotation("javax.xml.bind.annotation.XmlRootElement");
        this.setXmlRootElement_(null);
    }

    protected XmlRootElementAnnotation getXmlRootElementAnnotation() {
        return (XmlRootElementAnnotation)this.getJavaResourceType().getAnnotation("javax.xml.bind.annotation.XmlRootElement");
    }

    protected XmlRootElement buildXmlRootElement() {
        XmlRootElementAnnotation annotation = this.getXmlRootElementAnnotation();
        return annotation == null ? null : this.buildXmlRootElement(annotation);
    }

    protected XmlRootElement buildXmlRootElement(XmlRootElementAnnotation resourceRootElement) {
        return this.getFactory().buildJavaXmlRootElement(this, resourceRootElement);
    }

    protected void initXmlRootElement() {
        this.xmlRootElement = this.buildXmlRootElement();
    }

    protected void syncXmlRootElement() {
        XmlRootElementAnnotation annotation = this.getXmlRootElementAnnotation();
        if (annotation != null) {
            if (this.xmlRootElement != null) {
                this.xmlRootElement.synchronizeWithResourceModel();
            } else {
                this.setXmlRootElement_(this.buildXmlRootElement(annotation));
            }
        } else if (this.xmlRootElement != null) {
            this.setXmlRootElement_(null);
        }
    }

    protected void updateXmlRootElement() {
        if (this.xmlRootElement != null) {
            this.xmlRootElement.update();
        }
    }

    @Override
    public XmlSeeAlso getXmlSeeAlso() {
        return this.xmlSeeAlso;
    }

    protected void setXmlSeeAlso_(XmlSeeAlso xmlSeeAlso) {
        XmlSeeAlso old = this.xmlSeeAlso;
        this.xmlSeeAlso = xmlSeeAlso;
        this.firePropertyChanged("xmlSeeAlso", old, xmlSeeAlso);
    }

    @Override
    public XmlSeeAlso addXmlSeeAlso() {
        if (this.xmlSeeAlso != null) {
            throw new IllegalStateException();
        }
        XmlSeeAlsoAnnotation annotation = (XmlSeeAlsoAnnotation)this.getJavaResourceType().addAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        XmlSeeAlso xmlSeeAlso = this.buildXmlSeeAlso(annotation);
        this.setXmlSeeAlso_(xmlSeeAlso);
        return xmlSeeAlso;
    }

    @Override
    public void removeXmlSeeAlso() {
        if (this.xmlSeeAlso == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceType().removeAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        this.setXmlSeeAlso_(null);
    }

    protected XmlSeeAlsoAnnotation getXmlSeeAlsoAnnotation() {
        return (XmlSeeAlsoAnnotation)this.getJavaResourceType().getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
    }

    protected XmlSeeAlso buildXmlSeeAlso(XmlSeeAlsoAnnotation annotation) {
        return new GenericJavaXmlSeeAlso(this, annotation);
    }

    protected void initializeXmlSeeAlso() {
        XmlSeeAlsoAnnotation annotation = this.getXmlSeeAlsoAnnotation();
        this.xmlSeeAlso = annotation == null ? null : this.buildXmlSeeAlso(annotation);
    }

    protected void syncXmlSeeAlso() {
        XmlSeeAlsoAnnotation annotation = this.getXmlSeeAlsoAnnotation();
        if (annotation != null) {
            if (this.xmlSeeAlso != null) {
                this.xmlSeeAlso.synchronizeWithResourceModel();
            } else {
                this.setXmlSeeAlso_(this.buildXmlSeeAlso(annotation));
            }
        } else {
            this.setXmlSeeAlso_(null);
        }
    }

    protected void updateXmlSeeAlso() {
        if (this.xmlSeeAlso != null) {
            this.xmlSeeAlso.update();
        }
    }

    @Override
    public final Iterable<String> getReferencedXmlTypeNames() {
        return this.xmlTransient ? this.getTransientReferencedXmlTypeNames() : this.getNonTransientReferencedXmlTypeNames();
    }

    protected Iterable<String> getTransientReferencedXmlTypeNames() {
        return EmptyIterable.instance();
    }

    protected Iterable<String> getNonTransientReferencedXmlTypeNames() {
        if (this.xmlSeeAlso != null) {
            return this.xmlSeeAlso.getReferencedXmlTypeNames();
        }
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result;
        JaxbPackage jaxbPackage = this.getJaxbPackage();
        if (jaxbPackage != null) {
            this.getJaxbProject().getSchemaLibrary().refreshSchema(jaxbPackage.getNamespace());
        }
        if (!IterableTools.isEmpty(result = super.getCompletionProposals(pos))) {
            return result;
        }
        result = this.qName.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        if (this.xmlRootElement != null && !IterableTools.isEmpty(result = this.xmlRootElement.getCompletionProposals(pos))) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlTypeAnnotation().getTextRange();
        return textRange != null ? textRange : this.getJavaType().getValidationTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (!this.xmlTransient) {
            this.qName.validate(messages, reporter);
            if (this.xmlRootElement != null) {
                this.xmlRootElement.validate(messages, reporter);
            }
        }
    }

    @Override
    public XsdTypeDefinition getXsdTypeDefinition() {
        XsdElementDeclaration xsdElement;
        XsdSchema xsdSchema;
        JaxbPackage jaxbPackage = this.getJaxbPackage();
        XsdSchema xsdSchema2 = xsdSchema = jaxbPackage == null ? null : jaxbPackage.getXsdSchema();
        if (xsdSchema == null) {
            return null;
        }
        if (!StringTools.isBlank((String)this.qName.getName())) {
            return xsdSchema.getTypeDefinition(this.qName.getNamespace(), this.qName.getName());
        }
        if (this.xmlRootElement != null && (xsdElement = xsdSchema.getElementDeclaration(this.xmlRootElement.getQName().getNamespace(), this.xmlRootElement.getQName().getName())) != null) {
            return xsdElement.getType();
        }
        return null;
    }

    @Override
    public boolean hasRootElementInHierarchy() {
        return this.xmlRootElement != null;
    }

    protected class QNameAnnotationProxy
    extends AbstractQNameAnnotationProxy {
        protected QNameAnnotationProxy() {
        }

        protected QNameAnnotation getAnnotation(boolean createIfNull) {
            return AbstractJavaTypeMapping.this.getXmlTypeAnnotation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlTypeQName
    extends AbstractQName {
        protected XmlTypeQName(JaxbContextNode parent) {
            super(parent, new QNameAnnotationProxy());
        }

        @Override
        protected JaxbPackage getJaxbPackage() {
            return AbstractJavaTypeMapping.this.getJavaType().getJaxbPackage();
        }

        @Override
        protected String buildDefaultNamespace() {
            JaxbPackage jaxbPackage = AbstractJavaTypeMapping.this.getJavaType().getJaxbPackage();
            return jaxbPackage == null ? null : jaxbPackage.getNamespace();
        }

        @Override
        protected String buildDefaultName() {
            return Introspector.decapitalize(AbstractJavaTypeMapping.this.getJavaType().getTypeName().getSimpleName());
        }

        @Override
        protected Iterable<String> getNamespaceProposals() {
            XsdSchema schema = this.getXsdSchema();
            if (schema == null) {
                return EmptyIterable.instance();
            }
            return schema.getNamespaceProposals();
        }

        @Override
        protected Iterable<String> getNameProposals() {
            XsdSchema schema = this.getXsdSchema();
            if (schema == null) {
                return EmptyIterable.instance();
            }
            return schema.getTypeNameProposals(this.getNamespace());
        }

        @Override
        public String getReferencedComponentTypeDescription() {
            return JptJaxbCoreMessages.XML_TYPE_DESC;
        }

        @Override
        protected void validateName(List<IMessage> messages, IReporter reporter) {
            if ("".equals(this.getName()) && !ObjectTools.equals((Object)this.getNamespace(), (Object)this.buildDefaultNamespace())) {
                messages.add(this.buildValidationMessage(AbstractJavaTypeMapping.this.getXmlTypeAnnotation().getNamespaceValidationTextRange(), JptJaxbCoreValidationMessages.XML_TYPE__UNMATCHING_NAMESPACE_FOR_ANONYMOUS_TYPE));
            }
        }

        @Override
        protected void validateReference(List<IMessage> messages, IReporter reporter) {
            XsdTypeDefinition schemaType;
            XsdSchema schema;
            String name = this.getName();
            String namespace = this.getNamespace();
            if (!StringTools.isBlank((String)name) && (schema = this.getXsdSchema()) != null && (schemaType = schema.getTypeDefinition(namespace, name)) == null) {
                messages.add(this.getUnresolveSchemaComponentMessage());
            }
        }
    }
}

