/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.context.AbstractQName;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.XmlSchemaType;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractQNameAnnotationProxy;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaTypeAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericJavaXmlSchemaType
extends AbstractJavaContextNode
implements XmlSchemaType {
    protected final XmlSchemaTypeAnnotation annotation;
    protected JaxbQName qName;
    protected String type;

    protected GenericJavaXmlSchemaType(JaxbContextNode parent, XmlSchemaTypeAnnotation annotation) {
        super(parent);
        this.annotation = annotation;
        this.qName = this.buildQName();
        this.type = this.getResourceTypeString();
    }

    protected JaxbQName buildQName() {
        return new XmlSchemaTypeQName(this);
    }

    @Override
    public JaxbQName getQName() {
        return this.qName;
    }

    @Override
    public XmlSchemaTypeAnnotation getXmlSchemaTypeAnnotation() {
        return this.annotation;
    }

    protected abstract JaxbPackage getJaxbPackage();

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.qName.synchronizeWithResourceModel();
        this.setType_(this.getResourceTypeString());
    }

    @Override
    public void update() {
        super.update();
        this.qName.update();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String location) {
        this.annotation.setType(location);
        this.setType_(location);
    }

    protected void setType_(String type) {
        String old = this.type;
        this.type = type;
        this.firePropertyChanged("type", old, type);
    }

    protected String getResourceTypeString() {
        return this.annotation.getType();
    }

    @Override
    public String getFullyQualifiedType() {
        return this.getXmlSchemaTypeAnnotation().getFullyQualifiedType();
    }

    @Override
    public XsdTypeDefinition getXsdTypeDefinition() {
        XsdSchema xsdSchema;
        JaxbPackage pkg = this.getJaxbPackage();
        XsdSchema xsdSchema2 = xsdSchema = pkg == null ? null : pkg.getXsdSchema();
        if (xsdSchema == null) {
            return null;
        }
        if (!StringTools.isBlank((String)this.qName.getName())) {
            return xsdSchema.getTypeDefinition(this.qName.getNamespace(), this.qName.getName());
        }
        return null;
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        result = this.qName.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.annotation.getTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.qName.validate(messages, reporter);
        XsdTypeDefinition xsdType = this.getXsdTypeDefinition();
        if (xsdType != null && xsdType.getKind() != XsdTypeDefinition.Kind.SIMPLE) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_SCHEMA_TYPE__NON_SIMPLE_TYPE, this.qName.getName()));
        }
    }

    protected TextRange getTypeTextRange() {
        return this.getXmlSchemaTypeAnnotation().getTypeTextRange();
    }

    protected class QNameAnnotationProxy
    extends AbstractQNameAnnotationProxy {
        protected QNameAnnotationProxy() {
        }

        protected QNameAnnotation getAnnotation(boolean createIfNull) {
            return GenericJavaXmlSchemaType.this.annotation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlSchemaTypeQName
    extends AbstractQName {
        protected XmlSchemaTypeQName(JaxbContextNode parent) {
            super(parent, new QNameAnnotationProxy());
        }

        @Override
        protected JaxbPackage getJaxbPackage() {
            return GenericJavaXmlSchemaType.this.getJaxbPackage();
        }

        @Override
        protected String getReferencedComponentTypeDescription() {
            return JptJaxbCoreMessages.XML_TYPE_DESC;
        }

        @Override
        protected String buildDefaultName() {
            return null;
        }

        @Override
        protected String buildDefaultNamespace() {
            return "http://www.w3.org/2001/XMLSchema";
        }

        @Override
        protected Iterable<String> getNamespaceProposals() {
            XsdSchema schema = this.getXsdSchema();
            if (schema == null) {
                return EmptyIterable.instance();
            }
            return schema.getNamespaceProposals();
        }

        @Override
        protected Iterable<String> getNameProposals() {
            XsdSchema schema = this.getXsdSchema();
            if (schema == null) {
                return EmptyIterable.instance();
            }
            return schema.getSimpleTypeNameProposals(this.getNamespace());
        }

        @Override
        protected void validateReference(List<IMessage> messages, IReporter reporter) {
            XsdTypeDefinition schemaType;
            XsdSchema schema;
            String name = this.getName();
            String namespace = this.getNamespace();
            if (!StringTools.isBlank((String)name) && (schema = this.getXsdSchema()) != null && (schemaType = schema.getTypeDefinition(namespace, name)) == null) {
                messages.add(this.getUnresolveSchemaComponentMessage());
            }
        }
    }
}

