/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring.exclude;

import org.apache.maven.project.MavenProject;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.components.PomHierarchyComposite;
import org.eclipse.m2e.refactoring.Messages;
import org.eclipse.m2e.refactoring.exclude.ExcludeArtifactRefactoring;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ExcludeWizardPage
extends UserInputWizardPage
implements SelectionListener,
ISelectionChangedListener {
    private PomHierarchyComposite pomHierarchy;
    private Button currentPom;
    private Button hierarchy;
    private IMavenProjectFacade facade;
    private CLabel status;

    protected ExcludeWizardPage(IMavenProjectFacade facade) {
        super(Messages.ExcludeWizardPage_title);
        this.facade = facade;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(16384, 128, true, false));
        label.setText(Messages.ExcludeWizardPage_location);
        this.currentPom = new Button(composite, 16);
        GridData gd_currentPom = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_currentPom.horizontalIndent = 15;
        this.currentPom.setLayoutData((Object)gd_currentPom);
        this.currentPom.setText(this.facade.getArtifactKey().toString());
        this.currentPom.setSelection(true);
        this.currentPom.addSelectionListener((SelectionListener)this);
        this.hierarchy = new Button(composite, 16);
        GridData gd_hierarchy = new GridData(16384, 128, false, false);
        gd_hierarchy.horizontalIndent = 15;
        this.hierarchy.setLayoutData((Object)gd_hierarchy);
        this.hierarchy.setText(Messages.ExcludeWizardPage_selectFromHierarchy);
        this.hierarchy.addSelectionListener((SelectionListener)this);
        this.pomHierarchy = new PomHierarchyComposite(composite, 2048);
        GridData gd_pomHierarchy = new GridData(4, 4, true, true);
        gd_pomHierarchy.horizontalIndent = 35;
        this.pomHierarchy.setLayoutData((Object)gd_pomHierarchy);
        this.pomHierarchy.setEnabled(false);
        this.pomHierarchy.addSelectionChangedListener((ISelectionChangedListener)this);
        this.status = new CLabel(composite, 64);
        this.status.setLayoutData((Object)new GridData(4, 1024, true, false));
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExcludeWizardPage.this.pomHierarchy.computeHeirarchy(ExcludeWizardPage.this.facade, (IRunnableContext)ExcludeWizardPage.this.getContainer());
                ((ExcludeArtifactRefactoring)ExcludeWizardPage.this.getRefactoring()).setHierarchy(ExcludeWizardPage.this.pomHierarchy.getHierarchy());
            }
        });
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.currentPom) {
            this.pomHierarchy.setEnabled(false);
        } else if (e.getSource() == this.hierarchy) {
            this.pomHierarchy.setEnabled(true);
        }
        this.updateState();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void setStatus(String msg) {
        if (msg == null) {
            this.status.setImage(null);
            this.status.setText("");
        } else {
            this.status.setText(msg);
            this.status.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
        }
    }

    private void updateState() {
        ExcludeArtifactRefactoring refactoring = (ExcludeArtifactRefactoring)this.getRefactoring();
        if (this.hierarchy.getSelection()) {
            MavenProject project = this.pomHierarchy.fromSelection();
            this.updateStatusBar(project);
            refactoring.setExclusionPoint(project);
        } else {
            this.updateStatusBar(this.facade.getMavenProject());
            refactoring.setExclusionPoint(this.facade.getMavenProject());
        }
    }

    private void updateStatusBar(MavenProject project) {
        if (project == null) {
            this.setStatus(Messages.ExcludeWizardPage_errorSelectPom);
            this.setPageComplete(false);
        } else if (project.getFile() == null) {
            this.setStatus(Messages.ExcludeWizardPage_errorNonWorkspacePom);
            this.setPageComplete(false);
        } else if ((project = this.isAboveDependencyManagement(project)) != null) {
            this.setStatus(NLS.bind((String)Messages.ExcludeWizardPage_dependenciesManagedIn, (Object)ExcludeWizardPage.toString(project)));
            this.setPageComplete(false);
        } else {
            this.setStatus(null);
            this.setPageComplete(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateState();
    }

    private MavenProject isAboveDependencyManagement(MavenProject project) {
        for (MavenProject cProject : this.pomHierarchy.getHierarchy()) {
            if (project == cProject) {
                return null;
            }
            if (cProject.getOriginalModel().getDependencyManagement() == null || cProject.getOriginalModel().getDependencyManagement().getDependencies().isEmpty()) continue;
            return cProject;
        }
        return null;
    }

    private static String toString(MavenProject project) {
        return NLS.bind((String)"{0}:{1}:{2}", (Object[])new String[]{project.getGroupId(), project.getArtifactId(), project.getVersion()});
    }
}

