/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.debug;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IBreakpointProvider;

public class JSBreakpointProvider
implements IBreakpointProvider {
    private static final String SCRIPT_REGION = "org.eclipse.wst.html.SCRIPT";
    private static final String EXTENSION_POINT = "org.eclipse.wst.jsdt.web.ui.breakpointAdapter";
    IToggleBreakpointsTargetExtension[] fDelegates;
    private IEditorPart fPart;
    private ITextSelection fSelection;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    IToggleBreakpointsTargetExtension[] getDelegates() {
        if (this.fDelegates == null) {
            IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
            ArrayList<Object> adapters = new ArrayList<Object>();
            int i = 0;
            while (i < configurationElements.length) {
                Object o = null;
                try {
                    o = configurationElements[i].createExecutableExtension("class");
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
                if (o instanceof IToggleBreakpointsTargetExtension) {
                    adapters.add(o);
                }
                ++i;
            }
            this.fDelegates = adapters.toArray(new IToggleBreakpointsTargetExtension[adapters.size()]);
        }
        return this.fDelegates;
    }

    public IStatus addBreakpoint(IDocument document, IEditorInput input, int editorLineNumber, int offset) throws CoreException {
        IToggleBreakpointsTargetExtension[] delegates;
        IEditorPart part;
        IResource resource = this.getResource(input);
        Object object = part = this.fPart == null ? this.getPart(input) : this.fPart;
        if (resource != null && offset > -1 && part != null && (delegates = this.getDelegates()).length > 0) {
            try {
                ITextSelection selection = this.fSelection != null ? this.fSelection : new TextSelection(document.getLineOffset(editorLineNumber - 1) + offset, 1);
                ITypedRegion[] partitions = document.computePartitioning(selection.getOffset(), selection.getLength());
                boolean scriptSectionFound = false;
                int i = 0;
                while (i < partitions.length) {
                    scriptSectionFound |= SCRIPT_REGION.equals(partitions[i].getType());
                    ++i;
                }
                if (scriptSectionFound) {
                    i = 0;
                    while (i < delegates.length) {
                        delegates[i].toggleLineBreakpoints((IWorkbenchPart)part, (ISelection)selection);
                        ++i;
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        this.fPart = null;
        this.fSelection = null;
        return Status.OK_STATUS;
    }

    private IWorkbenchPart getPart(IEditorInput input) throws PartInitException {
        IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < workbenchWindows.length) {
            IWorkbenchPage[] pages = workbenchWindows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IEditorReference[] editorReferences = pages[j].getEditorReferences();
                int k = 0;
                while (k < editorReferences.length) {
                    if (editorReferences[k].getEditorInput() == input) {
                        return editorReferences[k].getPart(false);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public IResource getResource(IEditorInput input) {
        IResource resource;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)input.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)input.getAdapter((Class)clazz2);
        }
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    public void setSourceEditingTextTools(ISourceEditingTextTools tool) {
        if (tool != null) {
            this.fPart = tool.getEditorPart();
            this.fSelection = tool.getSelection();
        }
    }
}

