/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.classrealm.ClassRealmConstituent;
import org.apache.maven.classrealm.ClassRealmManagerDelegate;
import org.apache.maven.classrealm.ClassRealmRequest;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;

@Component(role=ClassRealmManagerDelegate.class)
public class EclipseClassRealmManagerDelegate
implements ClassRealmManagerDelegate {
    public static final String ROLE_HINT = EclipseClassRealmManagerDelegate.class.getName();
    @Requirement
    private PlexusContainer plexus;
    private final ArtifactVersion currentBuildApiVersion;

    public EclipseClassRealmManagerDelegate() {
        Properties props;
        block6: {
            props = new Properties();
            InputStream is = this.getClass().getResourceAsStream("/org/sonatype/plexus/build/incremental/version.properties");
            if (is != null) {
                try {
                    try {
                        props.load(is);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        IOUtil.close((InputStream)is);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close((InputStream)is);
                    throw throwable;
                }
                IOUtil.close((InputStream)is);
            }
        }
        this.currentBuildApiVersion = new DefaultArtifactVersion(props.getProperty("api.version", "0.0.5"));
    }

    public void setupRealm(ClassRealm realm, ClassRealmRequest request) {
        if (this.supportsBuildApi(request.getConstituents())) {
            ClassRealm coreRealm = this.plexus.getContainerRealm();
            realm.importFrom((ClassLoader)coreRealm, "org.codehaus.plexus.util.AbstractScanner");
            realm.importFrom((ClassLoader)coreRealm, "org.codehaus.plexus.util.Scanner");
            realm.importFrom((ClassLoader)coreRealm, "org.sonatype.plexus.build.incremental");
        }
    }

    private boolean supportsBuildApi(List<ClassRealmConstituent> constituents) {
        Iterator<ClassRealmConstituent> it = constituents.iterator();
        while (it.hasNext()) {
            boolean compatible;
            ClassRealmConstituent constituent = it.next();
            if (!"org.sonatype.plexus".equals(constituent.getGroupId()) || !"plexus-build-api".equals(constituent.getArtifactId())) continue;
            DefaultArtifactVersion version = new DefaultArtifactVersion(constituent.getVersion());
            boolean bl = compatible = this.currentBuildApiVersion.compareTo((Object)version) >= 0;
            if (compatible) {
                it.remove();
            }
            return compatible;
        }
        return false;
    }
}

