/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.io.File;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.ILocalRepositoryListener;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.sonatype.aether.AbstractRepositoryListener;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.artifact.Artifact;

@Component(role=RepositoryListener.class, hint="EclipseRepositoryListener")
public class EclipseRepositoryListener
extends AbstractRepositoryListener
implements RepositoryListener {
    public static final String ROLE_HINT = "EclipseRepositoryListener";

    public void artifactInstalled(RepositoryEvent event) {
        this.notifyListeners(event);
    }

    public void artifactDownloaded(RepositoryEvent event) {
        this.notifyListeners(event);
    }

    private void notifyListeners(RepositoryEvent event) {
        File file = event.getFile();
        if (file != null) {
            MavenImpl maven = (MavenImpl)MavenPlugin.getMaven();
            Artifact artifact = event.getArtifact();
            ArtifactKey key = new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), EclipseRepositoryListener.nes(artifact.getClassifier()));
            ArtifactKey baseKey = new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), EclipseRepositoryListener.nes(artifact.getClassifier()));
            File basedir = event.getSession().getLocalRepository().getBasedir();
            for (ILocalRepositoryListener listener : maven.getLocalRepositoryListeners()) {
                listener.artifactInstalled(basedir, baseKey, key, file);
            }
        }
    }

    private static String nes(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return str.trim();
    }
}

