/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations;

import java.util.List;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations.AbstractLabelAndHelpOperation;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.model.SelectItem;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.model.SelectItemModel;
import org.w3c.dom.Element;

public class SelectListboxChoiceOperation
extends AbstractLabelAndHelpOperation {
    private boolean isMultiple;
    private boolean showSize;

    public Element transform(Element srcElement, Element curElement) {
        if (this.getParameters().length < 2) {
            this.getLog().error("Warning.TransformOperationFactory.TooFewParameters", this.getTransformOperationID());
            return null;
        }
        this.isMultiple = Boolean.parseBoolean(this.getParameters()[0]);
        this.showSize = Boolean.parseBoolean(this.getParameters()[1]);
        return super.transform(srcElement, curElement);
    }

    protected void appendControl(Element srcElement, Element parentElement) {
        Element selectElement = this.appendChildElement("select", parentElement);
        if (this.isMultiple) {
            this.appendAttribute(selectElement, "multiple", "");
        }
        List<SelectItem> selectItems = SelectItemModel.getModel(srcElement);
        if (this.showSize) {
            int size;
            String attrSize = srcElement.getAttribute("size");
            if (attrSize != null && attrSize.length() > 0) {
                try {
                    size = Integer.parseInt(attrSize);
                }
                catch (NumberFormatException numberFormatException) {
                    size = 1;
                }
            } else {
                size = 1;
            }
            size = Math.max(size, selectItems.size());
            this.appendAttribute(selectElement, "size", String.valueOf(size));
        }
        boolean isFirstSelectItem = !this.isMultiple;
        for (SelectItem selectItem : selectItems) {
            Element optionElement = this.appendChildElement("option", selectElement);
            if (isFirstSelectItem) {
                this.appendAttribute(optionElement, "selected", "");
                isFirstSelectItem = false;
            }
            this.appendChildText(selectItem.getLabel(), optionElement);
        }
        this.appendAttribute(selectElement, "class", "af_inputText_content");
        String contentStyle = this.calculateStyle(null, srcElement, "contentStyle");
        if (contentStyle != null) {
            this.appendAttribute(selectElement, "style", contentStyle);
        }
    }
}

