/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import java.util.Hashtable;
import org.eclipse.wst.dtd.core.internal.AttributeEnumList;
import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.text.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class Attribute
extends DTDNode {
    public static final String CDATA = DTDCoreMessages._UI_CHARACTER_DATA_DESC;
    public static final String ENTITIES = DTDCoreMessages._UI_ENTITY_NAMES_DESC;
    public static final String ENTITY = DTDCoreMessages._UI_ENTITY_NAME_DESC;
    public static final String ENUMERATED_NAME = DTDCoreMessages._UI_ENUM_NAME_TOKENS_DESC;
    public static final String ENUMERATED_NOTATION = DTDCoreMessages._UI_ENUM_NOTATION_DESC;
    public static final String FIXED = "#FIXED";
    public static final String ID = DTDCoreMessages._UI_IDENTIFIER_DESC;
    public static final String IDREF = DTDCoreMessages._UI_ID_REFERENCE_DESC;
    public static final String IDREFS = DTDCoreMessages._UI_ID_REFERENCES_DESC;
    public static final String IMPLIED = "#IMPLIED";
    public static final String NMTOKEN = DTDCoreMessages._UI_NAME_TOKEN_DESC;
    public static final String NMTOKENS = DTDCoreMessages._UI_NAME_TOKENS_DESC;
    public static final String REQUIRED = "#REQUIRED";
    protected static Hashtable typeHash = new Hashtable();
    public static final String[] types = new String[]{CDATA, ID, IDREF, IDREFS, ENTITY, ENTITIES, NMTOKEN, NMTOKENS, ENUMERATED_NAME, ENUMERATED_NOTATION};
    private AttributeEnumList enumList;

    public Attribute(DTDFile file, IStructuredDocumentRegion flatNode) {
        super(file, flatNode);
        typeHash.put("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.CDATA_KEYWORD", CDATA);
        typeHash.put("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ID_KEYWORD", ID);
        typeHash.put("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.IDREF_KEYWORD", IDREF);
        typeHash.put("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.IDREFS_KEYWORD", IDREFS);
        typeHash.put("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_KEYWORD", ENTITY);
        typeHash.put("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITIES_KEYWORD", ENTITIES);
        typeHash.put("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NMTOKEN_KEYWORD", NMTOKEN);
        typeHash.put("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NMTOKENS_KEYWORD", NMTOKENS);
        typeHash.put("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NOTATION_KEYWORD", ENUMERATED_NOTATION);
        typeHash.put("()", ENUMERATED_NAME);
        typeHash.put(CDATA, "CDATA");
        typeHash.put(ID, "ID");
        typeHash.put(IDREF, "IDREF");
        typeHash.put(IDREFS, "IDREFS");
        typeHash.put(ENTITY, "ENTITY");
        typeHash.put(ENTITIES, "ENTITIES");
        typeHash.put(NMTOKEN, "NMTOKEN");
        typeHash.put(NMTOKENS, "NMTOKENS");
        typeHash.put(ENUMERATED_NAME, "");
        typeHash.put(ENUMERATED_NOTATION, "NOTATION");
        this.enumList = null;
    }

    public String getDefaultKind() {
        ITextRegion defaultKindRegion = this.getDefaultKindRegion();
        if (defaultKindRegion != null) {
            return this.getStructuredDTDDocumentRegion().getText(defaultKindRegion);
        }
        return "";
    }

    public ITextRegion getDefaultKindRegion() {
        RegionIterator iter = this.iterator();
        while (iter.hasNext()) {
            ITextRegion region = iter.next();
            if (region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.IMPLIED_KEYWORD" && region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.REQUIRED_KEYWORD" && region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.FIXED_KEYWORD") continue;
            return region;
        }
        return null;
    }

    public String getDefaultValue() {
        ITextRegion defaultValue = this.getNextQuotedLiteral(this.iterator());
        if (defaultValue != null) {
            return this.getValueFromQuotedRegion(defaultValue);
        }
        return "";
    }

    public AttributeEnumList getEnumList() {
        return this.enumList;
    }

    public String getImagePath() {
        return "icons/full/obj16/attribute.gif";
    }

    public ITextRegion getNameRegion() {
        return this.getNextRegion(this.iterator(), "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ATTRIBUTE_NAME");
    }

    public ITextRegion getNextQuotedLiteral(RegionIterator iter) {
        while (iter.hasNext()) {
            ITextRegion region = iter.next();
            if (!region.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.SINGLEQUOTED_LITERAL") && !region.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.DOUBLEQUOTED_LITERAL")) continue;
            return region;
        }
        return null;
    }

    protected int getOffsetAfterType() {
        boolean isEnumeration;
        ITextRegion typeRegion = this.getTypeRegion();
        String type = this.getType();
        boolean bl = isEnumeration = type.equals(ENUMERATED_NAME) || type.equals(ENUMERATED_NOTATION);
        if (isEnumeration && this.getEnumList() != null) {
            return this.getEnumList().getEndOffset();
        }
        if (typeRegion != null) {
            return this.getStructuredDTDDocumentRegion().getEndOffset(typeRegion);
        }
        ITextRegion nameRegion = this.getNameRegion();
        return this.getStructuredDTDDocumentRegion().getEndOffset(nameRegion);
    }

    public String getType() {
        ITextRegion region = this.getTypeRegion();
        if (region != null) {
            String type = (String)typeHash.get(region.getType());
            if (type == null) {
                return this.getStructuredDTDDocumentRegion().getText(region);
            }
            return type;
        }
        if (this.getEnumList() != null) {
            return (String)typeHash.get("()");
        }
        return "";
    }

    public ITextRegion getTypeRegion() {
        RegionIterator iter = this.iterator();
        while (iter.hasNext()) {
            ITextRegion region = iter.next();
            if (region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.CDATA_KEYWORD" && region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ID_KEYWORD" && region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.IDREF_KEYWORD" && region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.IDREFS_KEYWORD" && region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_KEYWORD" && region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITIES_KEYWORD" && region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NMTOKEN_KEYWORD" && region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NMTOKENS_KEYWORD" && region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NOTATION_KEYWORD" && region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.PARM_ENTITY_TYPE") continue;
            return region;
        }
        return null;
    }

    public String getValueFromQuotedRegion(ITextRegion region) {
        String type = region.getType();
        if (type.equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.SINGLEQUOTED_LITERAL") || type.equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.DOUBLEQUOTED_LITERAL")) {
            String text = this.getStructuredDTDDocumentRegion().getText(region);
            return text.substring(1, text.length() - 1);
        }
        return "";
    }

    public void resolveRegions() {
        this.removeChildNodes();
        RegionIterator iter = this.iterator();
        while (iter.hasNext()) {
            ITextRegion currentRegion = iter.next();
            if (currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.LEFT_PAREN")) {
                this.enumList = new AttributeEnumList(this.getDTDFile(), this.getStructuredDTDDocumentRegion());
            }
            if (this.enumList == null) continue;
            this.enumList.addRegion(currentRegion);
            if (currentRegion.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.RIGHT_PAREN") continue;
            return;
        }
    }

    public void setDefaultKind(Object requestor, String kind) {
        String oldDefaultKind;
        ITextRegion defaultKindRegion = this.getDefaultKindRegion();
        String string = oldDefaultKind = defaultKindRegion == null ? "" : this.getStructuredDTDDocumentRegion().getText(defaultKindRegion);
        if (!kind.equals(oldDefaultKind)) {
            String newText = kind;
            int startOffset = 0;
            int length = 0;
            if (defaultKindRegion != null) {
                startOffset = this.getStructuredDTDDocumentRegion().getStartOffset(defaultKindRegion);
                length = this.getStructuredDTDDocumentRegion().getEndOffset(defaultKindRegion) - startOffset;
            } else {
                startOffset = this.getOffsetAfterType();
                newText = " " + newText;
            }
            ITextRegion defaultValue = this.getNextQuotedLiteral(this.iterator());
            if (kind.equals(FIXED) || kind.equals("")) {
                if (defaultValue == null) {
                    newText = String.valueOf(newText) + " \"\"";
                }
            } else if (defaultValue != null) {
                length = this.getStructuredDTDDocumentRegion().getEndOffset(defaultValue) - startOffset;
            }
            this.replaceText(requestor, startOffset, length, newText);
        }
    }

    public void setDefaultKind(String kind) {
        this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_ATTR_DEFAULT_KIND);
        this.setDefaultKind((Object)this, kind);
        this.endRecording((Object)this);
    }

    public void setDefaultValue(Object requestor, String value, boolean fixed) {
        ITextRegion defaultKindRegion;
        ITextRegion defaultValue = this.getNextQuotedLiteral(this.iterator());
        String quoteChar = value.indexOf("\"") == -1 ? "\"" : "'";
        int startOffset = 0;
        int endOffset = 0;
        String newText = "";
        String oldValue = this.getDefaultValue();
        boolean oldKindIsFixed = this.getDefaultKind().equals(FIXED);
        if (oldValue.equals(value) && fixed == oldKindIsFixed) {
            return;
        }
        if (defaultValue != null) {
            startOffset = this.getStructuredDTDDocumentRegion().getStartOffset(defaultValue);
            endOffset = this.getStructuredDTDDocumentRegion().getEndOffset(defaultValue);
        }
        if ((defaultKindRegion = this.getDefaultKindRegion()) != null) {
            startOffset = this.getStructuredDTDDocumentRegion().getStartOffset(defaultKindRegion);
            endOffset = endOffset == 0 ? this.getStructuredDTDDocumentRegion().getEndOffset(defaultKindRegion) : endOffset;
        } else {
            ITextRegion typeRegion;
            if (startOffset == 0) {
                endOffset = startOffset = this.getOffsetAfterType();
                newText = String.valueOf(newText) + " ";
            }
            if ((typeRegion = this.getTypeRegion()) == null) {
                this.getEnumList();
            }
        }
        if (fixed) {
            newText = String.valueOf(newText) + "#FIXED ";
        } else if (this.getDefaultKind().equals("") && value.equals("")) {
            newText = String.valueOf(newText) + IMPLIED;
        }
        if (!this.getType().equals("") && !value.equals("")) {
            newText = String.valueOf(newText) + quoteChar + value + quoteChar;
        }
        this.replaceText(requestor, startOffset, endOffset - startOffset, newText);
    }

    public void setDefaultValue(String value, boolean fixed) {
        this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_ATTR_DEFAULT_VAL);
        this.setDefaultValue((Object)this, value, fixed);
        this.endRecording((Object)this);
    }

    public void setType(Object requestor, String type) {
        String oldType = this.getType();
        if (!type.equals(oldType)) {
            String newTypeWord;
            ITextRegion region;
            AttributeEnumList enumList;
            boolean wasEnumeration = oldType.equals(ENUMERATED_NAME) || oldType.equals(ENUMERATED_NOTATION);
            boolean isEnumeration = type.equals(ENUMERATED_NAME) || type.equals(ENUMERATED_NOTATION);
            String newText = "";
            int startOffset = 0;
            int endOffset = 0;
            if (wasEnumeration && !isEnumeration && (enumList = this.getEnumList()) != null) {
                startOffset = enumList.getStartOffset();
                endOffset = enumList.getEndOffset();
            }
            if ((region = this.getTypeRegion()) != null) {
                startOffset = this.getStructuredDTDDocumentRegion().getStartOffset(region);
                if (endOffset == 0) {
                    endOffset = this.getStructuredDTDDocumentRegion().getEndOffset(region);
                }
            } else if (startOffset == 0) {
                ITextRegion nameRegion = this.getNameRegion();
                newText = String.valueOf(newText) + " ";
                endOffset = startOffset = this.getStructuredDTDDocumentRegion().getEndOffset(nameRegion);
            }
            if ((newTypeWord = (String)typeHash.get(type)) == null) {
                newTypeWord = type;
            }
            newText = String.valueOf(newText) + newTypeWord;
            if (isEnumeration && !wasEnumeration) {
                boolean isSpaceNeeded = !type.equals(ENUMERATED_NAME);
                newText = String.valueOf(newText) + (isSpaceNeeded ? " " : "");
                newText = String.valueOf(newText) + "()";
            }
            this.replaceText(requestor, startOffset, endOffset - startOffset, newText);
            if (newTypeWord.equals("") && !type.equals(ENUMERATED_NAME)) {
                this.setDefaultValue(requestor, "", false);
            }
        }
    }

    public void setType(String type) {
        this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_ATTR_TYPE);
        this.setType((Object)this, type);
        this.endRecording((Object)this);
    }
}

