/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.ui.internal.navigator;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jpt.common.ui.internal.jface.StaticItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmFile;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlEnum;
import org.eclipse.jpt.jaxb.eclipselink.ui.JptJaxbEclipseLinkUiImages;
import org.eclipse.jpt.jaxb.eclipselink.ui.internal.navigator.ELJaxbJavaPersistentAttributeLabelProvider;
import org.eclipse.jpt.jaxb.eclipselink.ui.internal.navigator.OxmJavaAttributeLabelProvider;
import org.eclipse.jpt.jaxb.eclipselink.ui.internal.navigator.OxmJavaTypeLabelProvider;
import org.eclipse.jpt.jaxb.eclipselink.ui.internal.navigator.OxmXmlEnumLabelProvider;
import org.eclipse.jpt.jaxb.ui.internal.jaxb21.GenericJaxb_2_1_NavigatorItemLabelProviderFactory;

public class ELJaxbNavigatorItemLabelProviderFactory
extends GenericJaxb_2_1_NavigatorItemLabelProviderFactory {
    private static ELJaxbNavigatorItemLabelProviderFactory INSTANCE = new ELJaxbNavigatorItemLabelProviderFactory();

    public static GenericJaxb_2_1_NavigatorItemLabelProviderFactory instance() {
        return INSTANCE;
    }

    private ELJaxbNavigatorItemLabelProviderFactory() {
    }

    public ItemExtendedLabelProvider buildProvider(Object item, ItemExtendedLabelProvider.Manager manager) {
        if (item instanceof JavaPersistentAttribute) {
            return new ELJaxbJavaPersistentAttributeLabelProvider((JavaPersistentAttribute)item, manager);
        }
        if (item instanceof OxmFile) {
            return this.buildOxmFileLabelProvider((OxmFile)item, manager);
        }
        if (item instanceof OxmXmlEnum) {
            return this.buildOxmXmlEnumLabelProvider((OxmXmlEnum)item, manager);
        }
        if (item instanceof OxmJavaType) {
            return this.buildOxmJavaTypeLabelProvider((OxmJavaType)item, manager);
        }
        if (item instanceof OxmJavaAttribute) {
            return this.buildOxmJavaAttributeLabelProvider((OxmJavaAttribute)item, manager);
        }
        return super.buildProvider(item, manager);
    }

    protected ItemExtendedLabelProvider buildOxmFileLabelProvider(OxmFile file, ItemExtendedLabelProvider.Manager manager) {
        return new StaticItemExtendedLabelProvider(JptJaxbEclipseLinkUiImages.OXM_FILE, this.buildOxmFileText(file), this.buildOxmFileDescription(file), manager);
    }

    private String buildOxmFileText(OxmFile file) {
        StringBuffer text = new StringBuffer();
        IPath path = file.getOxmResource().getFile().getRawLocation();
        text.append(path.lastSegment());
        text.append(" - ");
        text.append(path.removeLastSegments(1).toOSString());
        return text.toString();
    }

    private String buildOxmFileDescription(OxmFile file) {
        return this.buildOxmFileText(file);
    }

    protected ItemExtendedLabelProvider buildOxmJavaTypeLabelProvider(OxmJavaType item, ItemExtendedLabelProvider.Manager manager) {
        return new OxmJavaTypeLabelProvider(item, manager);
    }

    protected ItemExtendedLabelProvider buildOxmXmlEnumLabelProvider(OxmXmlEnum item, ItemExtendedLabelProvider.Manager manager) {
        return new OxmXmlEnumLabelProvider(item, manager);
    }

    protected ItemExtendedLabelProvider buildOxmJavaAttributeLabelProvider(OxmJavaAttribute item, ItemExtendedLabelProvider.Manager manager) {
        return new OxmJavaAttributeLabelProvider(item, manager);
    }
}

