/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.jpa.JPAQuery;
import org.eclipse.persistence.internal.xr.Invocation;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.UnitOfWork;

public class DeleteOperation
extends Operation {
    protected String descriptorName;
    protected ClassDescriptor classDescriptor;

    public String getDescriptorName() {
        return this.descriptorName;
    }

    public void setDescriptorName(String descriptorName) {
        this.descriptorName = descriptorName;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @Override
    public void validate(XRServiceAdapter xrService) {
        super.validate(xrService);
        if (this.descriptorName == null) {
            throw DBWSException.couldNotLocateDescriptorForOperation((String)this.descriptorName, (String)this.getName());
        }
        if (!xrService.getORSession().getProject().getAliasDescriptors().containsKey(this.descriptorName)) {
            throw DBWSException.couldNotLocateDescriptorForOperation((String)this.descriptorName, (String)this.getName());
        }
        this.classDescriptor = xrService.getORSession().getProject().getDescriptorForAlias(this.descriptorName);
    }

    @Override
    public Object invoke(XRServiceAdapter xrService, Invocation invocation) {
        Object toBeDeleted;
        DatabaseQuery query = this.classDescriptor.getQueryManager().getQuery("findByPrimaryKey_" + this.descriptorName + "Type");
        if (query instanceof JPAQuery) {
            query = ((JPAQuery)query).processSQLQuery(xrService.getORSession().getActiveSession());
        }
        UnitOfWork uow = xrService.getORSession().acquireUnitOfWork();
        if (query.getArguments().size() == 0) {
            int idx = 0;
            for (Parameter param : this.getParameters()) {
                query.addArgument(Integer.toString(++idx), Util.SCHEMA_2_CLASS.get(param.getType()));
                query.addArgumentValue(invocation.getParameter(param.getName()));
            }
            toBeDeleted = uow.executeQuery(query);
        } else {
            List queryArguments = query.getArguments();
            int queryArgumentsSize = queryArguments.size();
            NonSynchronizedVector executeArguments = new NonSynchronizedVector();
            int i = 0;
            while (i < queryArgumentsSize) {
                String argName = (String)queryArguments.get(i);
                executeArguments.add(invocation.getParameter(argName));
                ++i;
            }
            toBeDeleted = uow.executeQuery(query, (List)executeArguments);
        }
        if (!this.isCollection() && toBeDeleted instanceof Vector) {
            toBeDeleted = ((Vector)toBeDeleted).isEmpty() ? null : ((Vector)toBeDeleted).firstElement();
        }
        if (toBeDeleted != null) {
            uow.deleteObject(toBeDeleted);
            uow.commit();
        }
        return null;
    }
}

