/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronize;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithWorkingTreeHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(this.getPage());
        if (selection.isEmpty()) {
            return null;
        }
        RevCommit commit = (RevCommit)selection.getFirstElement();
        Object input = this.getPage().getInputInternal().getSingleFile();
        Repository repository = this.getRepository(event);
        try {
            IWorkbenchPage workBenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
            if (input instanceof IFile) {
                IFile file = (IFile)input;
                if (CompareUtils.canDirectlyOpenInCompare(file)) {
                    CompareUtils.compareWorkspaceWithRef(repository, file, commit.getId().getName(), workBenchPage);
                } else {
                    GitModelSynchronize.synchronizeModelWithWorkspace(file, repository, commit.getName());
                }
            } else {
                CompareUtils.compareLocalWithRef(repository, (File)input, commit.getId().getName(), workBenchPage);
            }
        }
        catch (IOException e) {
            Activator.handleError(UIText.CompareWithRefAction_errorOnSynchronize, e, true);
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        int size = this.getSelection(page).size();
        if (size != 1) {
            return false;
        }
        return page.getInputInternal().isSingleFile();
    }
}

