/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.m2e.core.ui.internal.preferences.MavenGoalSelectionAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class GoalsFieldEditor
extends FieldEditor {
    Text goalsText;
    String value;
    private Button goialsSelectButton;
    private final String buttonText;

    public GoalsFieldEditor(String name, String labelText, String buttonText, Composite parent) {
        this.init(name, labelText);
        this.buttonText = buttonText;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns > 1) {
            Label control = this.getLabelControl();
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
            ((GridData)this.goalsText.getLayoutData()).horizontalSpan = numColumns - 1;
        } else {
            Label control = this.getLabelControl();
            ((GridData)control.getLayoutData()).horizontalSpan = 2;
            ((GridData)this.goalsText.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label labelControl = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        labelControl.setLayoutData((Object)gd);
        Text goalsText = this.getTextControl(parent);
        gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        goalsText.setLayoutData((Object)gd);
        goalsText.setFont(parent.getFont());
        this.goialsSelectButton = new Button(parent, 0);
        this.goialsSelectButton.setText(this.buttonText);
        this.goialsSelectButton.addSelectionListener((SelectionListener)new MavenGoalSelectionAdapter(goalsText, parent.getShell()));
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        goalsText.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.value == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
        } else {
            this.getPreferenceStore().setValue(this.getPreferenceName(), this.value);
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    private Text getTextControl(Composite parent) {
        if (this.goalsText == null) {
            this.goalsText = new Text(parent, 2048);
            this.goalsText.setFont(parent.getFont());
            this.goalsText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyevent) {
                    String oldValue = GoalsFieldEditor.this.value;
                    GoalsFieldEditor.this.value = GoalsFieldEditor.this.goalsText.getText();
                    GoalsFieldEditor.this.setPresentsDefaultValue(false);
                    GoalsFieldEditor.this.fireValueChanged("field_editor_value", oldValue, GoalsFieldEditor.this.value);
                }
            });
        }
        return this.goalsText;
    }

    protected void setPresentsDefaultValue(boolean booleanValue) {
        super.setPresentsDefaultValue(booleanValue);
    }

    protected void fireValueChanged(String property, Object oldValue, Object newValue) {
        super.fireValueChanged(property, oldValue, newValue);
    }

    private void updateComboForValue(String value) {
        this.value = value;
        this.goalsText.setText(value);
    }
}

