/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details.orm;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.swt.bind.SWTBindTools;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.SequenceGenerator;
import org.eclipse.jpt.jpa.core.context.TableGenerator;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.jpa.ui.details.orm.JptJpaUiDetailsOrmMessages;
import org.eclipse.jpt.jpa.ui.internal.details.GeneratorComposite;
import org.eclipse.jpt.jpa.ui.internal.details.SequenceGeneratorComposite;
import org.eclipse.jpt.jpa.ui.internal.details.TableGeneratorComposite;
import org.eclipse.jpt.jpa.ui.internal.details.orm.AddGeneratorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMappingsGeneratorsComposite
extends Pane<EntityMappings> {
    GeneratorComposite<SequenceGenerator> sequenceGeneratorPane;
    TableGeneratorComposite tableGeneratorPane;
    ModifiableCollectionValueModel<OrmGenerator> selectedGeneratorsModel;
    PropertyValueModel<OrmGenerator> selectedGeneratorModel;

    public EntityMappingsGeneratorsComposite(Pane<? extends EntityMappings> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected void initialize() {
        super.initialize();
        this.selectedGeneratorsModel = this.buildSelectedGeneratorsModel();
        this.selectedGeneratorModel = this.buildSelectedGeneratorModel(this.selectedGeneratorsModel);
    }

    private ModifiableCollectionValueModel<OrmGenerator> buildSelectedGeneratorsModel() {
        return new SimpleCollectionValueModel();
    }

    protected PropertyValueModel<OrmGenerator> buildSelectedGeneratorModel(ModifiableCollectionValueModel<OrmGenerator> selectedGeneratorsModel) {
        return new CollectionPropertyValueModelAdapter<OrmGenerator, OrmGenerator>(selectedGeneratorsModel){

            protected OrmGenerator buildValue() {
                if (this.collectionModel.size() == 1) {
                    return (OrmGenerator)this.collectionModel.iterator().next();
                }
                return null;
            }
        };
    }

    OrmGenerator addGenerator() {
        return this.addGeneratorFromDialog(this.buildAddGeneratorDialog());
    }

    protected AddGeneratorDialog buildAddGeneratorDialog() {
        return new AddGeneratorDialog(this.getShell(), this.getResourceManager(), ((EntityMappings)this.getSubject()).getPersistenceUnit());
    }

    protected OrmGenerator addGeneratorFromDialog(AddGeneratorDialog dialog) {
        OrmTableGenerator generator;
        if (dialog.open() != 0) {
            return null;
        }
        String generatorType = dialog.getGeneratorType();
        if (generatorType == "tableGenerator") {
            generator = ((EntityMappings)this.getSubject()).addTableGenerator();
        } else if (generatorType == "sequenceGenerator") {
            generator = ((EntityMappings)this.getSubject()).addSequenceGenerator();
        } else {
            throw new IllegalArgumentException();
        }
        generator.setName(dialog.getName());
        return generator;
    }

    private ListValueModel<OrmGenerator> buildDisplayableGeneratorListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildGeneratorsListHolder(), new String[]{"name"});
    }

    private AddRemovePane.Adapter<OrmGenerator> buildGeneratorAdapter() {
        return new AddRemovePane.AbstractAdapter<OrmGenerator>(){

            public OrmGenerator addNewItem() {
                return EntityMappingsGeneratorsComposite.this.addGenerator();
            }

            public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<OrmGenerator> selectedItemsModel) {
                return this.buildSingleSelectedItemEnabledModel(selectedItemsModel);
            }

            public void removeSelectedItems(CollectionValueModel<OrmGenerator> selectedItemsModel) {
                OrmGenerator item = (OrmGenerator)selectedItemsModel.iterator().next();
                if (item instanceof OrmSequenceGenerator) {
                    ((EntityMappings)EntityMappingsGeneratorsComposite.this.getSubject()).removeSequenceGenerator((OrmSequenceGenerator)item);
                } else {
                    ((EntityMappings)EntityMappingsGeneratorsComposite.this.getSubject()).removeTableGenerator((OrmTableGenerator)item);
                }
            }
        };
    }

    private ILabelProvider buildGeneratorLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                OrmGenerator generator = (OrmGenerator)element;
                String name = generator.getName();
                if (name == null) {
                    int index = -1;
                    index = generator instanceof OrmSequenceGenerator ? IterableTools.indexOf((Iterable)((EntityMappings)EntityMappingsGeneratorsComposite.this.getSubject()).getSequenceGenerators(), (Object)generator) : IterableTools.indexOf((Iterable)((EntityMappings)EntityMappingsGeneratorsComposite.this.getSubject()).getTableGenerators(), (Object)generator);
                    name = NLS.bind((String)JptJpaUiDetailsOrmMessages.ORM_GENERATORS_COMPOSITE_DISPLAY_STRING, (Object)index);
                }
                return name;
            }
        };
    }

    private ListValueModel<OrmGenerator> buildGeneratorsListHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildSequenceGeneratorListHolder());
        list.add(this.buildTableGeneratorListHolder());
        return CompositeListValueModel.forModels(list);
    }

    private Transformer<OrmGenerator, Control> buildPaneTransformer(Composite container) {
        return new PaneTransformer(container);
    }

    private PropertyValueModel<SequenceGenerator> buildSequenceGeneratorHolder() {
        return new TransformationPropertyValueModel<OrmGenerator, SequenceGenerator>(this.selectedGeneratorModel){

            protected SequenceGenerator transform_(OrmGenerator value) {
                return value instanceof SequenceGenerator ? (SequenceGenerator)value : null;
            }
        };
    }

    private ListValueModel<OrmSequenceGenerator> buildSequenceGeneratorListHolder() {
        return new ListAspectAdapter<EntityMappings, OrmSequenceGenerator>(this.getSubjectHolder(), new String[]{"sequenceGenerators"}){

            protected ListIterable<OrmSequenceGenerator> getListIterable() {
                return ((EntityMappings)this.subject).getSequenceGenerators();
            }

            protected int size_() {
                return ((EntityMappings)this.subject).getSequenceGeneratorsSize();
            }
        };
    }

    private PropertyValueModel<TableGenerator> buildTableGeneratorHolder() {
        return new TransformationPropertyValueModel<OrmGenerator, TableGenerator>(this.selectedGeneratorModel){

            protected TableGenerator transform_(OrmGenerator value) {
                return value instanceof TableGenerator ? (TableGenerator)value : null;
            }
        };
    }

    private ListValueModel<OrmTableGenerator> buildTableGeneratorListHolder() {
        return new ListAspectAdapter<EntityMappings, OrmTableGenerator>(this.getSubjectHolder(), new String[]{"tableGenerators"}){

            protected ListIterable<OrmTableGenerator> getListIterable() {
                return ((EntityMappings)this.subject).getTableGenerators();
            }

            protected int size_() {
                return ((EntityMappings)this.subject).getTableGeneratorsSize();
            }
        };
    }

    protected void initializeLayout(Composite container) {
        this.addListPane(container);
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        this.installPaneSwitcher(pageBook);
    }

    protected GeneratorComposite<SequenceGenerator> getSequenceGeneratorComposite(Composite container) {
        if (this.sequenceGeneratorPane == null) {
            this.sequenceGeneratorPane = this.buildSequenceGeneratorComposite(container, this.buildSequenceGeneratorHolder(), this.buildSequenceGeneratorBuilder());
        }
        return this.sequenceGeneratorPane;
    }

    protected GeneratorComposite<SequenceGenerator> buildSequenceGeneratorComposite(Composite parent, PropertyValueModel<SequenceGenerator> sequenceGeneratorHolder, GeneratorComposite.GeneratorBuilder<SequenceGenerator> generatorBuilder) {
        return new SequenceGeneratorComposite((Pane<?>)this, sequenceGeneratorHolder, parent, generatorBuilder);
    }

    protected TableGeneratorComposite getTableGeneratorComposite(Composite container) {
        if (this.tableGeneratorPane == null) {
            this.tableGeneratorPane = new TableGeneratorComposite((Pane<?>)this, this.buildTableGeneratorHolder(), container, this.buildTableGeneratorBuilder());
        }
        return this.tableGeneratorPane;
    }

    private AddRemoveListPane<EntityMappings, OrmGenerator> addListPane(Composite container) {
        return new AddRemoveListPane((Pane)this, container, this.buildGeneratorAdapter(), this.buildDisplayableGeneratorListHolder(), this.selectedGeneratorsModel, this.buildGeneratorLabelProvider());
    }

    private void installPaneSwitcher(PageBook pageBook) {
        SWTBindTools.bind(this.selectedGeneratorModel, this.buildPaneTransformer((Composite)pageBook), (PageBook)pageBook);
    }

    private GeneratorComposite.GeneratorBuilder<SequenceGenerator> buildSequenceGeneratorBuilder() {
        return new GeneratorComposite.GeneratorBuilder<SequenceGenerator>(){

            @Override
            public SequenceGenerator addGenerator() {
                throw new UnsupportedOperationException("The sequence generator will never be null so we do not need to implement this");
            }
        };
    }

    private GeneratorComposite.GeneratorBuilder<TableGenerator> buildTableGeneratorBuilder() {
        return new GeneratorComposite.GeneratorBuilder<TableGenerator>(){

            @Override
            public TableGenerator addGenerator() {
                throw new UnsupportedOperationException("The table generator will never be null so we do not need to implement this");
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PaneTransformer
    extends AbstractTransformer<OrmGenerator, Control> {
        private final Composite container;

        protected PaneTransformer(Composite container) {
            this.container = container;
        }

        public Control transform_(OrmGenerator generator) {
            if (generator instanceof OrmSequenceGenerator) {
                return EntityMappingsGeneratorsComposite.this.getSequenceGeneratorComposite(this.container).getControl();
            }
            return EntityMappingsGeneratorsComposite.this.getTableGeneratorComposite(this.container).getControl();
        }
    }
}

