/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.navigator;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.core.internal.utility.ProjectTools;
import org.eclipse.jpt.common.core.internal.utility.ResourceChangeAdapter;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.jface.NavigatorContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.ui.JpaContextModelRootModel;
import org.eclipse.jpt.jpa.ui.JpaWorkbench;
import org.eclipse.jpt.jpa.ui.internal.navigator.JpaNavigatorItemContentProviderFactory;
import org.eclipse.jpt.jpa.ui.internal.navigator.JpaNavigatorItemLabelProviderFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public class JpaNavigatorContentProvider
extends NavigatorContentProvider {
    private volatile IResourceChangeListener resourceChangeListener;
    private final HashMap<IProject, JpaContextModelRootModel[]> projectChildren = new HashMap();

    public void init(ICommonContentExtensionSite config) {
        super.init(config);
        this.resourceChangeListener = new ResourceChangeListener();
        this.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    protected ItemTreeContentProvider.Factory buildItemContentProviderFactory() {
        return new JpaNavigatorItemContentProviderFactory();
    }

    protected ItemExtendedLabelProvider.Factory buildItemLabelProviderFactory() {
        return new JpaNavigatorItemLabelProviderFactory();
    }

    protected ResourceManager buildResourceManager() {
        JpaWorkbench jpaWorkbench = this.getJpaWorkbench();
        return jpaWorkbench != null ? jpaWorkbench.buildLocalResourceManager() : this.buildResourceManager_();
    }

    private ResourceManager buildResourceManager_() {
        return new LocalResourceManager(JFaceResources.getResources((Display)WorkbenchTools.getDisplay()));
    }

    protected boolean hasChildren_(Object element) {
        return this.getChildren_(element) != null;
    }

    protected Object[] getChildren_(Object element) {
        return element instanceof IProject ? this.getChildren((IProject)element) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getChildren(IProject project) {
        HashMap<IProject, JpaContextModelRootModel[]> hashMap = this.projectChildren;
        synchronized (hashMap) {
            return this.getChildren_(project);
        }
    }

    private JpaContextModelRootModel[] getChildren_(IProject project) {
        JpaContextModelRootModel[] children = this.projectChildren.get(project);
        if (children == null) {
            children = this.buildChildren(project);
            this.projectChildren.put(project, children);
        }
        return children;
    }

    private JpaContextModelRootModel[] buildChildren(IProject project) {
        return new JpaContextModelRootModel[]{this.buildChild(project)};
    }

    private JpaContextModelRootModel buildChild(IProject project) {
        return (JpaContextModelRootModel)project.getAdapter(JpaContextModelRootModel.class);
    }

    void facetFileChanged(IProject project) {
        if (ProjectTools.hasFacet((IProject)project, (IProjectFacet)JpaProject.FACET)) {
            this.jpaFacetIsPresent(project);
        } else {
            this.jpaFacetIsAbsent(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jpaFacetIsPresent(IProject project) {
        HashMap<IProject, JpaContextModelRootModel[]> hashMap = this.projectChildren;
        synchronized (hashMap) {
            this.jpaFacetIsPresent_(project);
        }
    }

    private void jpaFacetIsPresent_(IProject project) {
        JpaContextModelRootModel[] children = this.projectChildren.get(project);
        if (children == null) {
            this.delegate.updateChildren((Object)project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jpaFacetIsAbsent(IProject project) {
        HashMap<IProject, JpaContextModelRootModel[]> hashMap = this.projectChildren;
        synchronized (hashMap) {
            this.jpaFacetIsAbsent_(project);
        }
    }

    private void jpaFacetIsAbsent_(IProject project) {
        JpaContextModelRootModel[] children = this.projectChildren.remove(project);
        if (children != null) {
            JpaContextModelRootModel[] jpaContextModelRootModelArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                JpaContextModelRootModel child = jpaContextModelRootModelArray[n2];
                this.delegate.dispose((Object)child);
                ++n2;
            }
            this.delegate.updateChildren((Object)project);
        }
    }

    public void dispose() {
        this.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.dispose();
    }

    private IWorkspace getWorkspace() {
        return this.getJpaWorkbench().getJpaWorkspace().getWorkspace();
    }

    private JpaWorkbench getJpaWorkbench() {
        return (JpaWorkbench)WorkbenchTools.getAdapter(JpaWorkbench.class);
    }

    class ResourceChangeListener
    extends ResourceChangeAdapter {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 1: {
                    this.processPostChangeDelta(event.getDelta());
                    break;
                }
            }
        }

        private void processPostChangeDelta(IResourceDelta delta) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    this.processPostChangeDeltaChildren(delta);
                    break;
                }
                case 4: {
                    this.processPostChangeDeltaChildren(delta);
                    break;
                }
                case 2: {
                    if (!((IFolder)resource).getName().equals(".settings")) break;
                    this.processPostChangeDeltaChildren(delta);
                    break;
                }
                case 1: {
                    IFile file = (IFile)resource;
                    if (!file.getName().equals("org.eclipse.wst.common.project.facet.core.xml")) break;
                    this.checkForFacetFileChanges(file, delta);
                    break;
                }
            }
        }

        private void processPostChangeDeltaChildren(IResourceDelta delta) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                this.processPostChangeDelta(child);
                ++n2;
            }
        }

        private void checkForFacetFileChanges(IFile file, IResourceDelta delta) {
            switch (delta.getKind()) {
                case 1: 
                case 2: 
                case 4: {
                    JpaNavigatorContentProvider.this.facetFileChanged(file.getProject());
                    break;
                }
            }
        }
    }
}

