/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.navigator;

import java.util.HashMap;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeStateProviderFactoryProvider;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.ui.JpaContextModelRootModel;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.internal.navigator.JpaContextModelRootModelItemContentProvider;

public class JpaNavigatorItemContentProviderFactory
implements ItemTreeContentProvider.Factory {
    private HashMap<JpaPlatform, ItemTreeContentProvider.Factory> delegates = new HashMap();

    public ItemTreeContentProvider buildProvider(Object item, ItemTreeContentProvider.Manager manager) {
        if (item instanceof JpaContextModelRootModel) {
            return this.buildContextModelRootModelProvider((JpaContextModelRootModel)item, manager);
        }
        ItemTreeContentProvider.Factory delegate = this.getDelegate(item);
        return delegate == null ? null : delegate.buildProvider(item, manager);
    }

    protected ItemTreeContentProvider buildContextModelRootModelProvider(JpaContextModelRootModel item, ItemTreeContentProvider.Manager manager) {
        return new JpaContextModelRootModelItemContentProvider(item, manager);
    }

    private ItemTreeContentProvider.Factory getDelegate(Object element) {
        return element instanceof JpaContextModel ? this.getDelegate((JpaContextModel)element) : null;
    }

    private synchronized ItemTreeContentProvider.Factory getDelegate(JpaContextModel contextNode) {
        JpaPlatform jpaPlatform = contextNode.getJpaPlatform();
        ItemTreeContentProvider.Factory delegate = this.delegates.get(jpaPlatform);
        if (delegate == null && !this.delegates.containsKey(jpaPlatform)) {
            delegate = this.buildDelegate(jpaPlatform);
            this.delegates.put(jpaPlatform, delegate);
        }
        return delegate;
    }

    private ItemTreeContentProvider.Factory buildDelegate(JpaPlatform jpaPlatform) {
        JpaPlatformUi platformUI = (JpaPlatformUi)jpaPlatform.getAdapter(JpaPlatformUi.class);
        if (platformUI == null) {
            return null;
        }
        ItemTreeStateProviderFactoryProvider factoryProvider = platformUI.getNavigatorFactoryProvider();
        return factoryProvider == null ? null : factoryProvider.getItemContentProviderFactory();
    }

    public String toString() {
        return ObjectTools.toString((Object)this);
    }
}

