/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import java.util.List;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.jpa.annotate.mapping.AnnotationAttrConverter;
import org.eclipse.jpt.jpa.annotate.mapping.AnnotationAttribute;
import org.eclipse.jpt.jpa.annotate.mapping.EntityRefPropertyElem;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.AssociationAnnotationWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.SelectCascadeDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingAnnotationCtl {
    private EntityRefPropertyElem refElem;
    private Text propNameText;
    private Text propTypeText;
    private Text cascadeText;
    private Button cascadeBrowseBtn;
    private Combo fetchTypeCombo;
    private ResourceManager resourceManager;

    public MappingAnnotationCtl(ResourceManager resourceManager, EntityRefPropertyElem refElem) {
        this.refElem = refElem;
        this.resourceManager = resourceManager;
    }

    Composite createMappingPropGroup(Composite parent, int style) {
        Group mappingGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        mappingGroup.setLayout((Layout)layout);
        mappingGroup.setLayoutData((Object)new GridData(768));
        AssociationAnnotationWizard.createLabel((Composite)mappingGroup, 1, JptJpaUiMakePersistentMessages.PROPERTY_NAME_LABEL, -1);
        this.propNameText = AssociationAnnotationWizard.createText((Composite)mappingGroup, 1, true, null, 2056);
        new Label((Composite)mappingGroup, 0);
        AssociationAnnotationWizard.createLabel((Composite)mappingGroup, 1, JptJpaUiMakePersistentMessages.PROPERTY_TYPE_LABEL, -1);
        this.propTypeText = AssociationAnnotationWizard.createText((Composite)mappingGroup, 1, true, null, 2056);
        new Label((Composite)mappingGroup, 0);
        AssociationAnnotationWizard.createLabel((Composite)mappingGroup, 1, JptJpaUiMakePersistentMessages.CASCADE, -1);
        this.cascadeText = AssociationAnnotationWizard.createText((Composite)mappingGroup, 1, true, null, 2056);
        this.cascadeBrowseBtn = AssociationAnnotationWizard.createImageButton((Composite)mappingGroup, this.resourceManager.createImage(JptJpaUiImages.LIST_OF_VALUES), 1, 0, JptJpaUiMakePersistentMessages.BROWSE);
        AssociationAnnotationWizard.createLabel((Composite)mappingGroup, 1, JptJpaUiMakePersistentMessages.FETCH_TYPE, -1);
        this.fetchTypeCombo = AssociationAnnotationWizard.createCombo((Composite)mappingGroup, true, 1, 2060, -1);
        new Label((Composite)mappingGroup, 0);
        return mappingGroup;
    }

    void initFields() {
        this.propNameText.setText(this.refElem.getPropertyName());
        this.propTypeText.setText(this.refElem.getPropertyType());
        String cascadeStr = this.getCascadeDisplayStr(this.refElem.getAllCascades());
        this.cascadeText.setText(cascadeStr);
        this.fetchTypeCombo.setItems(AnnotationAttrConverter.getTagEnumStringValues((String)"fetch"));
        AnnotationAttribute fetchAttr = this.refElem.getAnnotationAttribute("fetch");
        if (fetchAttr != null) {
            this.fetchTypeCombo.select(this.fetchTypeCombo.indexOf(fetchAttr.attrValue));
        }
    }

    void addListeners() {
        this.cascadeBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingAnnotationCtl.this.chooseCascade();
            }
        });
        this.fetchTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingAnnotationCtl.this.handleFetchTypeChange();
            }
        });
    }

    private String getCascadeDisplayStr(List<String> cascades) {
        assert (cascades != null);
        if (cascades.isEmpty()) {
            return "";
        }
        StringBuffer cascadeBuf = new StringBuffer();
        int i = 0;
        while (i < cascades.size()) {
            if (i != 0) {
                cascadeBuf.append(", ");
            }
            cascadeBuf.append(cascades.get(i));
            ++i;
        }
        return cascadeBuf.toString();
    }

    private void chooseCascade() {
        SelectCascadeDialog dlg = new SelectCascadeDialog(Display.getDefault().getActiveShell(), this.refElem.getAllCascades());
        if (dlg.open() == 0) {
            List<String> cascades = dlg.getAllCascades();
            this.refElem.setCascades(cascades);
            this.cascadeText.setText(this.getCascadeDisplayStr(cascades));
        }
    }

    private void handleFetchTypeChange() {
        int index = this.fetchTypeCombo.getSelectionIndex();
        String newFetchType = this.fetchTypeCombo.getItem(index);
        AnnotationAttribute fetchAttr = new AnnotationAttribute("fetch", "fetch", newFetchType);
        this.refElem.setAnnotationAttr(fetchAttr);
    }
}

