/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.jee.JEEPlugin;
import org.eclipse.jst.jee.model.internal.common.ManyToOneRelation;
import org.eclipse.jst.jee.model.internal.common.MyModelProviderEvent;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationModelProvider<T>
implements IElementChangedListener,
IModelProvider {
    private static final String JAVA_EXTENSION = "java";
    protected T modelObject;
    private Collection<IModelProviderListener> listeners;
    private Lock listenersLock = new ReentrantLock();
    protected IFacetedProject facetedProject;
    private ManyToOneRelation<SecurityRoleRef, SecurityRole> rolesToRolesRef = new ManyToOneRelation();

    private static SecurityRole findRole(Collection<SecurityRole> securityRoles, String name) {
        for (SecurityRole role : securityRoles) {
            if (!role.getRoleName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public AbstractAnnotationModelProvider(IFacetedProject project) {
        if (project == null) {
            throw new IllegalArgumentException("The project argument can not be null");
        }
        this.facetedProject = project;
    }

    public T getConcreteModel() {
        if (this.modelObject == null) {
            this.preLoad();
            try {
                this.loadModel();
                this.postLoad();
            }
            catch (CoreException e) {
                this.log(e.getStatus());
                return null;
            }
        }
        return this.modelObject;
    }

    public Object getModelObject() {
        return this.getConcreteModel();
    }

    public Object getModelObject(IPath modelPath) {
        return this.getConcreteModel();
    }

    protected abstract void loadModel() throws CoreException;

    protected void preLoad() {
    }

    protected void postLoad() {
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    protected void notifyListeners(IModelProviderEvent event) {
        if (this.listeners == null) {
            return;
        }
        this.listenersLock.lock();
        try {
            IModelProviderListener[] backup = this.listeners.toArray(new IModelProviderListener[this.listeners.size()]);
            this.notifyListeners(backup, event);
            backup = null;
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    protected void clearListeners() {
        if (this.listeners == null) {
            return;
        }
        try {
            this.listenersLock.lock();
            this.listeners.clear();
            this.listeners = null;
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    private void notifyListeners(IModelProviderListener[] aListeners, final IModelProviderEvent event) {
        if (event.getChangedResources() == null || event.getChangedResources().isEmpty()) {
            return;
        }
        IModelProviderListener[] iModelProviderListenerArray = aListeners;
        int n = aListeners.length;
        int n2 = 0;
        while (n2 < n) {
            final IModelProviderListener listener = iModelProviderListenerArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.modelsChanged(event);
                }
            });
            ++n2;
        }
    }

    protected Collection<IModelProviderListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IModelProviderListener>();
        }
        return this.listeners;
    }

    public void addListener(IModelProviderListener listener) {
        this.listenersLock.lock();
        try {
            this.getModelObject();
            this.getListeners().add(listener);
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    public void removeListener(IModelProviderListener listener) {
        this.listenersLock.lock();
        try {
            this.getListeners().remove(listener);
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    protected boolean isProjectRelative(IJavaProject javaProject) {
        if (javaProject == null || this.facetedProject == null) {
            return false;
        }
        if (javaProject.getProject().equals((Object)this.facetedProject.getProject())) {
            return true;
        }
        return JavaEEProjectUtilities.isWebFragmentProject((IProject)javaProject.getProject()) && JavaEEProjectUtilities.isDynamicWebProject((IProject)this.facetedProject.getProject()) && this.isWebFragmentOf(this.facetedProject.getProject(), javaProject.getProject());
    }

    private boolean isWebFragmentOf(IProject webProject, IProject webFragment) {
        IVirtualComponent componentWebProject = ComponentCore.createComponent((IProject)webProject);
        IVirtualComponent componentWebFragment = ComponentCore.createComponent((IProject)webFragment);
        if (componentWebProject != null && componentWebFragment != null) {
            return WebUtilities.getWebFragments((IVirtualComponent)componentWebProject).contains(componentWebFragment);
        }
        return false;
    }

    public void dispose() {
        MyModelProviderEvent modelEvent = this.createModelProviderEvent();
        modelEvent.addResource(this.facetedProject.getProject());
        modelEvent.setEventCode(64);
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this.modelObject = null;
        this.notifyListeners(modelEvent);
        this.clearListeners();
    }

    protected abstract void processRemovedCompilationUnit(IModelProviderEvent var1, ICompilationUnit var2) throws CoreException;

    protected abstract void processAddedCompilationUnit(IModelProviderEvent var1, ICompilationUnit var2) throws CoreException;

    protected abstract void processChangedCompilationUnit(IModelProviderEvent var1, ICompilationUnit var2) throws CoreException;

    protected void log(IStatus status) {
    }

    protected MyModelProviderEvent createModelProviderEvent() {
        return new MyModelProviderEvent(0, null, this.facetedProject.getProject());
    }

    protected abstract Collection<SecurityRole> getSecurityRoles();

    protected abstract Collection<SecurityRoleRef> getSecurityRoleRefs(JavaEEObject var1);

    protected void disconnectFromRoles(JavaEEObject target) {
        Collection<SecurityRole> roles = this.getSecurityRoles();
        if (roles == null) {
            return;
        }
        Collection<SecurityRoleRef> refs = this.getSecurityRoleRefs(target);
        if (refs == null) {
            return;
        }
        for (SecurityRoleRef ref : refs) {
            SecurityRole role = this.rolesToRolesRef.getTarget(ref);
            this.rolesToRolesRef.disconnectSource(ref);
            if (this.rolesToRolesRef.containsTarget(role)) continue;
            this.getSecurityRoles().remove(role);
        }
    }

    protected void securityRoleFound(JavaEEObject object, SecurityRole securityRole) {
        this.connectWithRole(securityRole, object);
    }

    private void connectWithRole(SecurityRole securityRole, JavaEEObject target) {
        Collection<SecurityRole> roles = this.getSecurityRoles();
        if (roles == null) {
            return;
        }
        Collection<SecurityRoleRef> refs = this.getSecurityRoleRefs(target);
        if (refs == null) {
            return;
        }
        SecurityRole role = AbstractAnnotationModelProvider.findRole(roles, securityRole.getRoleName());
        if (role == null) {
            roles.add(securityRole);
            role = securityRole;
        }
        for (SecurityRoleRef ref : refs) {
            if (!ref.getRoleName().equals(role.getRoleName())) continue;
            this.rolesToRolesRef.connect(ref, role);
        }
    }

    public void elementChanged(ElementChangedEvent javaEvent) {
        if (javaEvent.getType() == 4) {
            this.internalPostReconcile(javaEvent);
        } else if (javaEvent.getType() == 1) {
            this.internalPostChange(javaEvent);
        }
    }

    private void internalPostChange(ElementChangedEvent javaEvent) {
        MyModelProviderEvent modelEvent = this.createModelProviderEvent();
        IJavaElementDelta[] iJavaElementDeltaArray = javaEvent.getDelta().getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            if (child.getElement() instanceof IJavaProject) {
                this.processChangedProject(modelEvent, child);
                this.notifyListeners(modelEvent);
            }
            ++n2;
        }
    }

    private void internalPostReconcile(ElementChangedEvent javaEvent) {
        MyModelProviderEvent modelEvent = this.createModelProviderEvent();
        if (javaEvent.getDelta().getElement() instanceof ICompilationUnit) {
            this.recursevilyProcessCompilationUnits(modelEvent, javaEvent.getDelta());
            this.notifyListeners(modelEvent);
        }
    }

    protected void processChangedProject(IModelProviderEvent event, IJavaElementDelta projectDelta) {
        if (!this.isProjectRelative(projectDelta.getElement().getJavaProject())) {
            return;
        }
        Assert.isTrue((boolean)(projectDelta.getElement() instanceof IJavaProject), (String)("An invalid change notification has occured. Element is <" + projectDelta.getElement() + ">"));
        if ((projectDelta.getFlags() & 0x200) != 0 || projectDelta.getKind() == 1) {
            try {
                this.loadModel();
            }
            catch (CoreException e) {
                JEEPlugin.getDefault().getLog().log((IStatus)new Status(4, JEEPlugin.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
            }
        }
        if ((projectDelta.getFlags() & 0x400) != 0 || projectDelta.getKind() == 2) {
            this.dispose();
        }
        this.processChangedProjectChildren(event, projectDelta);
    }

    protected void processChangedProjectChildren(IModelProviderEvent event, IJavaElementDelta projectDelta) {
        IJavaElementDelta[] iJavaElementDeltaArray = projectDelta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
            if (childDelta.getElement() instanceof IPackageFragmentRoot && (childDelta.getFlags() & 8) != 0) {
                this.recursevilyProcessPackages(event, childDelta);
            }
            ++n2;
        }
    }

    public void recursevilyProcessPackages(IModelProviderEvent modelEvent, IJavaElementDelta delta) {
        block9: {
            if (delta.getElement() instanceof IPackageFragment) {
                try {
                    IPackageFragment fragment = (IPackageFragment)delta.getElement();
                    if (delta.getKind() == 1) {
                        ICompilationUnit[] iCompilationUnitArray = fragment.getCompilationUnits();
                        int n = iCompilationUnitArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICompilationUnit unit = iCompilationUnitArray[n2];
                            this.processAddedCompilationUnit(modelEvent, unit);
                            ++n2;
                        }
                        break block9;
                    }
                    if (delta.getKind() == 2) {
                        if (delta.getKind() == 2) {
                            this.processRemovedPackage(modelEvent, delta);
                        }
                        break block9;
                    }
                    if (delta.getKind() != 4) break block9;
                    this.recursevilyProcessCompilationUnits(modelEvent, delta);
                }
                catch (CoreException e) {
                    JEEPlugin.getDefault().getLog().log((IStatus)new Status(4, JEEPlugin.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
                }
            } else {
                IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
                int n = iJavaElementDeltaArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IJavaElementDelta childDelta = iJavaElementDeltaArray[n3];
                    this.recursevilyProcessPackages(modelEvent, childDelta);
                    ++n3;
                }
            }
        }
    }

    protected abstract void processRemovedPackage(IModelProviderEvent var1, IJavaElementDelta var2) throws CoreException;

    public void recursevilyProcessCompilationUnits(IModelProviderEvent modelEvent, IJavaElementDelta delta) {
        if (delta.getElement() instanceof ICompilationUnit) {
            if (!this.isProjectRelative(delta.getElement().getJavaProject())) {
                return;
            }
            try {
                ICompilationUnit unit = (ICompilationUnit)delta.getElement();
                if (delta.getKind() == 1) {
                    this.processAddedCompilationUnit(modelEvent, unit);
                }
                if (delta.getKind() == 2) {
                    this.processRemovedCompilationUnit(modelEvent, unit);
                }
                if (delta.getKind() == 4 && ((delta.getFlags() & 0x40000) == 0 || (delta.getFlags() & 0x10000) == 0)) {
                    modelEvent.setEventCode(0x100 | modelEvent.getEventCode());
                    this.processChangedCompilationUnit(modelEvent, unit);
                }
            }
            catch (CoreException e) {
                JEEPlugin.getDefault().getLog().log((IStatus)new Status(4, JEEPlugin.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
            }
        } else {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
                this.recursevilyProcessCompilationUnits(modelEvent, childDelta);
                ++n2;
            }
        }
    }

    protected void visitJavaFiles(final Collection<ICompilationUnit> javaFiles, final IPackageFragmentRoot root) throws CoreException {
        if (root.getKind() != 1) {
            return;
        }
        root.getCorrespondingResource().accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 1) {
                    if (proxy.getName().endsWith(".java")) {
                        IFile file = (IFile)proxy.requestResource();
                        if (!root.getJavaProject().isOnClasspath((IResource)file)) {
                            return false;
                        }
                        if (!file.isSynchronized(1)) {
                            return false;
                        }
                        javaFiles.add(JavaCore.createCompilationUnitFrom((IFile)file));
                    }
                    return false;
                }
                return true;
            }
        }, 0);
    }
}

