/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.e4.ui.workbench.addons.dndaddon.SplitFeedbackOverlay;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SplitDropAgent
extends DropAgent {
    private static final int NOWHERE = -1;
    private int curDockLocation = -1;
    private boolean onEdge = false;
    private MPartStack dropStack;
    private CTabFolder dropCTF;
    private Rectangle clientBounds;
    private String weight;
    private Rectangle ctfBounds;
    private MUIElement outerRelTo;
    private Rectangle ocBounds;
    private SplitFeedbackOverlay feedback = null;

    public SplitDropAgent(DnDManager manager) {
        super(manager);
    }

    public boolean canDrop(MUIElement dragElement, DnDInfo info) {
        MElementContainer dragParent;
        if (!(dragElement instanceof MStackElement) && !(dragElement instanceof MPartStack)) {
            return false;
        }
        this.dropStack = null;
        if (info.curElement instanceof MPartStack) {
            MPartStack stack = (MPartStack)info.curElement;
            if (this.dndManager.getModelService().isLastEditorStack((MUIElement)stack)) {
                this.dropStack = stack;
            }
        }
        if (this.dropStack == null) {
            if (!(info.curElement instanceof MStackElement) && !this.dndManager.getModelService().isLastEditorStack(info.curElement)) {
                return false;
            }
            MElementContainer parent = info.curElement.getParent();
            if (info.curElement instanceof MPart && info.curElement.getCurSharedRef() != null) {
                parent = info.curElement.getCurSharedRef().getParent();
            }
            if (!(parent instanceof MPartStack) || !(parent.getWidget() instanceof CTabFolder)) {
                return false;
            }
            this.dropStack = (MPartStack)parent;
        }
        if ((dragParent = dragElement.getParent()) == this.dropStack && this.dropStack.getChildren().size() == 2) {
            return false;
        }
        this.weight = this.dropStack.getContainerData();
        this.dropCTF = (CTabFolder)this.dropStack.getWidget();
        return true;
    }

    public void dragEnter(MUIElement dragElement, DnDInfo info) {
        MElementContainer relToParent;
        super.dragEnter(dragElement, info);
        this.clientBounds = this.dropCTF.getClientArea();
        this.clientBounds = Display.getCurrent().map((Control)this.dropCTF, null, this.clientBounds);
        this.ctfBounds = this.dropCTF.getBounds();
        this.ctfBounds = Display.getCurrent().map((Control)this.dropCTF.getParent(), null, this.ctfBounds);
        this.outerRelTo = this.dropStack.getParent();
        if (this.outerRelTo instanceof MPartSashContainer) {
            while (this.outerRelTo != null && !(this.outerRelTo.getWidget() instanceof Composite)) {
                this.outerRelTo = this.outerRelTo.getParent();
            }
        }
        this.outerRelTo = this.outerRelTo instanceof MArea ? this.outerRelTo.getCurSharedRef() : (this.outerRelTo instanceof MPartSashContainer ? ((relToParent = this.outerRelTo.getParent()) instanceof MArea ? relToParent.getCurSharedRef() : (relToParent instanceof MPerspective ? relToParent.getParent() : null)) : null);
        if (this.outerRelTo != null) {
            Composite outerComposite = (Composite)this.outerRelTo.getWidget();
            this.ocBounds = outerComposite.getBounds();
            this.ocBounds = Display.getCurrent().map((Control)outerComposite.getParent(), null, this.ocBounds);
        } else {
            this.ocBounds = null;
        }
        this.getDockLocation(info);
        this.showFeedback(this.curDockLocation);
    }

    public void dragLeave(MUIElement dragElement, DnDInfo info) {
        if (this.dndManager.getFeedbackStyle() != 3) {
            this.unDock(dragElement);
        }
        this.dndManager.clearOverlay();
        this.clearFeedback();
        this.curDockLocation = -1;
        super.dragLeave(dragElement, info);
    }

    public boolean drop(MUIElement dragElement, DnDInfo info) {
        if (this.dndManager.getFeedbackStyle() != 1 && this.curDockLocation != -1) {
            this.dock(dragElement, this.curDockLocation);
        }
        this.clearFeedback();
        return true;
    }

    public boolean track(MUIElement dragElement, DnDInfo info) {
        if (!this.clientBounds.contains(info.cursorPos)) {
            return false;
        }
        boolean wasOnEdge = this.onEdge;
        int dockLocation = this.getDockLocation(info);
        if (this.feedback != null) {
            this.feedback.setFeedback(this.getEnclosed(), this.getModified());
        }
        if (dockLocation == this.curDockLocation && wasOnEdge == this.onEdge) {
            return true;
        }
        if (this.dropStack == dragElement && !this.onEdge) {
            return false;
        }
        this.curDockLocation = dockLocation;
        if (this.curDockLocation != -1) {
            this.showFeedback(this.curDockLocation);
            this.dndManager.setCursor(Display.getCurrent().getSystemCursor(21));
        } else {
            this.unDock(dragElement);
            this.dndManager.setCursor(Display.getCurrent().getSystemCursor(20));
        }
        return true;
    }

    private boolean getModified() {
        if (!this.onEdge) {
            return false;
        }
        return this.dndManager.isModified;
    }

    private boolean getEnclosed() {
        if (this.onEdge) {
            if (this.outerRelTo instanceof MPerspectiveStack) {
                return !this.getModified();
            }
            return this.getModified();
        }
        return true;
    }

    private void showFeedback(int location) {
        Rectangle bounds;
        if (location == -1) {
            return;
        }
        Rectangle feedbackBounds = null;
        feedbackBounds = !this.onEdge ? (bounds = new Rectangle(this.ctfBounds.x, this.ctfBounds.y, this.ctfBounds.width, this.ctfBounds.height)) : (bounds = new Rectangle(this.ocBounds.x, this.ocBounds.y, this.ocBounds.width, this.ocBounds.height));
        if (this.feedback != null) {
            this.feedback.dispose();
        }
        int side = 0;
        if (location == 0) {
            side = 128;
        } else if (location == 1) {
            side = 1024;
        } else if (location == 2) {
            side = 16384;
        } else if (location == 3) {
            side = 131072;
        }
        float pct = (float)(this.onEdge ? 0.34 : 0.5);
        this.clearFeedback();
        this.feedback = new SplitFeedbackOverlay(this.dropCTF.getShell(), feedbackBounds, side, pct, this.getEnclosed(), this.getModified());
        this.feedback.setVisible(true);
    }

    private void clearFeedback() {
        if (this.feedback == null) {
            return;
        }
        this.feedback.dispose();
        this.feedback = null;
    }

    private int getDockLocation(DnDInfo info) {
        int minDy;
        if (this.outerRelTo != null) {
            int outerThreshold = 50;
            if (info.cursorPos.y - this.ocBounds.y < outerThreshold) {
                this.onEdge = true;
                return 0;
            }
            if (this.ocBounds.y + this.ocBounds.height - info.cursorPos.y < outerThreshold) {
                this.onEdge = true;
                return 1;
            }
            if (info.cursorPos.x - this.ocBounds.x < outerThreshold) {
                this.onEdge = true;
                return 2;
            }
            if (this.ocBounds.x + this.ocBounds.width - info.cursorPos.x < outerThreshold) {
                this.onEdge = true;
                return 3;
            }
        }
        this.onEdge = false;
        int dx = info.cursorPos.x - this.clientBounds.x;
        int dy = info.cursorPos.y - this.clientBounds.y;
        int dxr = this.clientBounds.x + this.clientBounds.width - info.cursorPos.x;
        int dyr = this.clientBounds.y + this.clientBounds.height - info.cursorPos.y;
        int minDx = Math.min(dx, dxr);
        if (minDx < (minDy = Math.min(dy, dyr))) {
            return dx < dxr ? 2 : 3;
        }
        return dy < dyr ? 0 : 1;
    }

    protected void unDock(MUIElement dragElement) {
        this.dndManager.clearOverlay();
        this.clearFeedback();
        this.dndManager.setHostBounds(null);
        this.dndManager.setDragHostVisibility(true);
    }

    protected boolean dock(MUIElement dragElement, int where) {
        MPartStack toInsert;
        this.dndManager.setDragHostVisibility(false);
        MPartStack relTo = this.dropStack;
        if (this.crossSharedAreaBoundary(dragElement, this.dropStack)) {
            if (!this.dndManager.isModified) {
                relTo = (MPartSashContainerElement)this.outerRelTo;
            }
        } else if (this.onEdge) {
            relTo = (MPartSashContainerElement)this.outerRelTo;
            if (this.outerRelTo instanceof MPerspectiveStack && !this.getModified()) {
                relTo = (MPartSashContainerElement)((MPerspective)((MPerspectiveStack)this.outerRelTo).getSelectedElement()).getChildren().get(0);
            }
        }
        if (dragElement instanceof MPartStack) {
            toInsert = (MPartStack)dragElement;
            toInsert.getParent().getChildren().remove(toInsert);
        } else {
            MStackElement stackElement = (MStackElement)dragElement;
            toInsert = BasicFactoryImpl.eINSTANCE.createPartStack();
            toInsert.getChildren().add(stackElement);
            toInsert.setSelectedElement((MUIElement)stackElement);
        }
        float pct = (float)(this.onEdge ? 0.34 : 0.5);
        MElementContainer relToParent = relTo.getParent();
        this.dndManager.getModelService().insert((MPartSashContainerElement)toInsert, (MPartSashContainerElement)relTo, where, pct);
        if (relTo.getParent() != relToParent && !this.onEdge) {
            relTo.getParent().setContainerData(this.weight);
        }
        this.dndManager.update();
        return true;
    }

    private boolean crossSharedAreaBoundary(MUIElement dragElement, MPartStack dropStack) {
        boolean dsInSA;
        EModelService ms = this.dndManager.getModelService();
        boolean deNotInSA = (ms.getElementLocation(dragElement) & 8) == 0;
        boolean bl = dsInSA = (ms.getElementLocation((MUIElement)dropStack) & 8) != 0;
        return deNotInSA && dsInSA;
    }
}

