/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.trace.Trace;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.PasswordAuthentication;
import java.util.StringTokenizer;

public final class CredentialInfo
implements Externalizable,
Cloneable {
    private static final int MAX_PASSWORD_LENGTH = 4096;
    private String userName = "";
    private char[] password = new char[0];
    private byte[] encryptedPassword = new byte[0];
    private String domain = "";
    private long sessionId = -1L;
    private boolean isPasswordSaved = false;

    public Object clone() {
        CredentialInfo credentialInfo = new CredentialInfo();
        credentialInfo.userName = this.userName;
        credentialInfo.domain = this.domain;
        credentialInfo.sessionId = this.sessionId;
        credentialInfo.isPasswordSaved = this.isPasswordSaved;
        credentialInfo.password = new char[this.password.length];
        credentialInfo.encryptedPassword = new byte[this.encryptedPassword.length];
        System.arraycopy(this.password, 0, credentialInfo.password, 0, this.password.length);
        System.arraycopy(this.encryptedPassword, 0, credentialInfo.encryptedPassword, 0, this.encryptedPassword.length);
        return credentialInfo;
    }

    public void setSessionId(long l) {
        this.sessionId = l;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public boolean isPasswordSaveApproved() {
        return this.isPasswordSaved;
    }

    public void setPasswordSaveApproval(boolean bl) {
        this.isPasswordSaved = bl;
    }

    public void setUserName(String string) {
        if (string == null) {
            this.userName = "";
        } else if (string.indexOf("\\".toString()) > -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
            this.domain = stringTokenizer.nextToken();
            this.userName = stringTokenizer.nextToken();
        } else {
            this.userName = string;
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setDomain(String string) {
        this.domain = string == null ? "" : string;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setPassword(char[] cArray) {
        if (cArray == null) {
            cArray = new char[]{};
            this.setEncryptedPassword(null);
        }
        this.password = new char[cArray.length];
        System.arraycopy(cArray, 0, this.password, 0, this.password.length);
    }

    public char[] getPassword() {
        char[] cArray = new char[this.password.length];
        System.arraycopy(this.password, 0, cArray, 0, this.password.length);
        return cArray;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        try {
            objectOutput.writeObject(this.userName);
            objectOutput.writeLong(this.sessionId);
            objectOutput.writeObject(this.domain);
            objectOutput.writeInt(this.encryptedPassword.length);
            for (int i = 0; i < this.encryptedPassword.length; ++i) {
                objectOutput.writeByte(this.encryptedPassword[i]);
            }
        }
        catch (Exception exception) {
            Trace.securityPrintException(exception);
        }
    }

    public boolean isCredentialEmpty() {
        return this.userName.length() <= 0 && this.domain.length() <= 0;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            this.userName = (String)objectInput.readObject();
            this.sessionId = objectInput.readLong();
            this.domain = (String)objectInput.readObject();
            int n = objectInput.readInt();
            if (n > 4096) {
                throw new SecurityException("Invalid password length (" + n + "). It should not exceed " + 4096 + " bytes.");
            }
            this.encryptedPassword = new byte[n];
            for (int i = 0; i < this.encryptedPassword.length; ++i) {
                this.encryptedPassword[i] = objectInput.readByte();
            }
        }
        catch (Exception exception) {
            Trace.securityPrintException(exception);
        }
    }

    protected byte[] getEncryptedPassword() {
        byte[] byArray = new byte[this.encryptedPassword.length];
        System.arraycopy(this.encryptedPassword, 0, byArray, 0, this.encryptedPassword.length);
        return byArray;
    }

    protected void setEncryptedPassword(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.encryptedPassword = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.encryptedPassword, 0, byArray.length);
    }

    public static CredentialInfo passAuthToCredentialInfo(PasswordAuthentication passwordAuthentication) {
        CredentialInfo credentialInfo = new CredentialInfo();
        if (passwordAuthentication != null) {
            if (passwordAuthentication.getUserName().contains("\\")) {
                StringTokenizer stringTokenizer = new StringTokenizer(passwordAuthentication.getUserName(), "\\");
                credentialInfo.domain = stringTokenizer.nextToken();
                credentialInfo.userName = stringTokenizer.nextToken();
            } else {
                credentialInfo.userName = passwordAuthentication.getUserName();
            }
            credentialInfo.password = passwordAuthentication.getPassword();
        }
        return credentialInfo;
    }

    public PasswordAuthentication getPasswordAuthentication() {
        String string = this.userName;
        if (this.domain != null && !this.domain.trim().equals("")) {
            string = this.domain + '\\' + this.userName;
        }
        return new PasswordAuthentication(string, this.password);
    }
}

