/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsDoubleBufferRL;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

class ByteBufferAsDoubleBufferL
extends DoubleBuffer {
    protected final ByteBuffer bb;
    protected final int offset;

    ByteBufferAsDoubleBufferL(ByteBuffer byteBuffer) {
        super(-1, 0, byteBuffer.remaining() >> 3, byteBuffer.remaining() >> 3);
        this.bb = byteBuffer;
        int n = this.capacity();
        this.limit(n);
        int n2 = this.position();
        assert (n2 <= n);
        this.offset = n2;
    }

    ByteBufferAsDoubleBufferL(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.bb = byteBuffer;
        this.offset = n5;
    }

    @Override
    public DoubleBuffer slice() {
        int n;
        int n2 = this.position();
        int n3 = n2 <= (n = this.limit()) ? n - n2 : 0;
        int n4 = (n2 << 3) + this.offset;
        assert (n4 >= 0);
        return new ByteBufferAsDoubleBufferL(this.bb, -1, 0, n3, n3, n4);
    }

    @Override
    public DoubleBuffer duplicate() {
        return new ByteBufferAsDoubleBufferL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        return new ByteBufferAsDoubleBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return (n << 3) + this.offset;
    }

    @Override
    public double get() {
        return Bits.getDoubleL(this.bb, this.ix(this.nextGetIndex()));
    }

    @Override
    public double get(int n) {
        return Bits.getDoubleL(this.bb, this.ix(this.checkIndex(n)));
    }

    @Override
    public DoubleBuffer put(double d) {
        Bits.putDoubleL(this.bb, this.ix(this.nextPutIndex()), d);
        return this;
    }

    @Override
    public DoubleBuffer put(int n, double d) {
        Bits.putDoubleL(this.bb, this.ix(this.checkIndex(n)), d);
        return this;
    }

    @Override
    public DoubleBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        ByteBuffer byteBuffer = this.bb.duplicate();
        byteBuffer.limit(this.ix(n2));
        byteBuffer.position(this.ix(0));
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.position(n << 3);
        byteBuffer2.compact();
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

