/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;

public final class SelectAction
extends WidgetAction.LockedAdapter {
    private boolean aiming = false;
    private Widget aimedWidget = null;
    private boolean invertSelection;
    private SelectProvider provider;
    private boolean trapRightClick = false;

    public SelectAction(SelectProvider selectProvider, boolean bl) {
        this.provider = selectProvider;
        this.trapRightClick = bl;
    }

    public SelectAction(SelectProvider selectProvider) {
        this.provider = selectProvider;
    }

    @Override
    protected boolean isLocked() {
        return this.aiming;
    }

    @Override
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked(widget, this);
        }
        Point point = widgetMouseEvent.getPoint();
        if (widgetMouseEvent.getButton() == 1 || widgetMouseEvent.getButton() == 2) {
            boolean bl = this.invertSelection = (widgetMouseEvent.getModifiersEx() & 0x80) != 0;
            if (this.provider.isSelectionAllowed(widget, point, this.invertSelection)) {
                this.aiming = this.provider.isAimingAllowed(widget, point, this.invertSelection);
                if (this.aiming) {
                    this.updateState(widget, point);
                    return WidgetAction.State.createLocked(widget, this);
                }
                this.provider.select(widget, point, this.invertSelection);
                return WidgetAction.State.CHAIN_ONLY;
            }
        } else if (this.trapRightClick && widgetMouseEvent.getButton() == 3) {
            this.provider.select(widget, point, false);
            return WidgetAction.State.CHAIN_ONLY;
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.aiming) {
            Point point = widgetMouseEvent.getPoint();
            this.updateState(widget, point);
            if (this.aimedWidget != null) {
                this.provider.select(widget, point, this.invertSelection);
            }
            this.updateState(null, null);
            this.aiming = false;
            return WidgetAction.State.CONSUMED;
        }
        return super.mouseReleased(widget, widgetMouseEvent);
    }

    private void updateState(Widget widget, Point point) {
        if (widget != null && !widget.isHitAt(point)) {
            widget = null;
        }
        if (widget == this.aimedWidget) {
            return;
        }
        if (this.aimedWidget != null) {
            this.aimedWidget.setState(this.aimedWidget.getState().deriveWidgetAimed(false));
        }
        this.aimedWidget = widget;
        if (this.aimedWidget != null) {
            this.aimedWidget.setState(this.aimedWidget.getState().deriveWidgetAimed(true));
        }
    }

    @Override
    public WidgetAction.State keyTyped(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
        if (!this.aiming && widgetKeyEvent.getKeyChar() == ' ') {
            this.provider.select(widget, null, (widgetKeyEvent.getModifiersEx() & 0x80) != 0);
            return WidgetAction.State.CONSUMED;
        }
        return WidgetAction.State.REJECTED;
    }
}

