/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import sun.security.ssl.Alert;
import sun.security.ssl.CertificateStatus;
import sun.security.ssl.ChangeCipherSpec;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.ServerHandshakeContext;

final class ServerHelloDone {
    static final SSLConsumer handshakeConsumer = new ServerHelloDoneConsumer();
    static final HandshakeProducer handshakeProducer = new ServerHelloDoneProducer();

    ServerHelloDone() {
    }

    private static final class ServerHelloDoneConsumer
    implements SSLConsumer {
        private ServerHelloDoneConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            SSLHandshake[] sSLHandshakeArray;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            SSLConsumer sSLConsumer = (SSLConsumer)clientHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_STATUS.id);
            if (sSLConsumer != null) {
                CertificateStatus.handshakeAbsence.absent(connectionContext, null);
            }
            clientHandshakeContext.handshakeConsumers.clear();
            ServerHelloDoneMessage serverHelloDoneMessage = new ServerHelloDoneMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ServerHelloDone handshake message", serverHelloDoneMessage);
            }
            clientHandshakeContext.handshakeProducers.put(SSLHandshake.CLIENT_KEY_EXCHANGE.id, SSLHandshake.CLIENT_KEY_EXCHANGE);
            clientHandshakeContext.handshakeProducers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            for (SSLHandshake sSLHandshake : sSLHandshakeArray = new SSLHandshake[]{SSLHandshake.CERTIFICATE, SSLHandshake.CLIENT_KEY_EXCHANGE, SSLHandshake.CERTIFICATE_VERIFY, SSLHandshake.FINISHED}) {
                HandshakeProducer handshakeProducer = (HandshakeProducer)clientHandshakeContext.handshakeProducers.remove(sSLHandshake.id);
                if (handshakeProducer == null) continue;
                handshakeProducer.produce(connectionContext, null);
            }
        }
    }

    private static final class ServerHelloDoneProducer
    implements HandshakeProducer {
        private ServerHelloDoneProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            ServerHelloDoneMessage serverHelloDoneMessage = new ServerHelloDoneMessage(serverHandshakeContext);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ServerHelloDone handshake message", serverHelloDoneMessage);
            }
            serverHelloDoneMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            serverHandshakeContext.handshakeConsumers.put(SSLHandshake.CLIENT_KEY_EXCHANGE.id, SSLHandshake.CLIENT_KEY_EXCHANGE);
            serverHandshakeContext.conContext.consumers.put(ContentType.CHANGE_CIPHER_SPEC.id, ChangeCipherSpec.t10Consumer);
            serverHandshakeContext.handshakeConsumers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            return null;
        }
    }

    static final class ServerHelloDoneMessage
    extends SSLHandshake.HandshakeMessage {
        ServerHelloDoneMessage(HandshakeContext handshakeContext) {
            super(handshakeContext);
        }

        ServerHelloDoneMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            if (byteBuffer.hasRemaining()) {
                handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Error parsing ServerHelloDone message: not empty");
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.SERVER_HELLO_DONE;
        }

        @Override
        public int messageLength() {
            return 0;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
        }

        public String toString() {
            return "<empty>";
        }
    }
}

