/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.IntegerArray;
import com.sun.java.help.search.LiteMorph;
import com.sun.java.help.search.Search;
import com.sun.java.help.search.SearchEnvironment;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.HelpUtilities;
import javax.help.search.SearchQuery;

public class QueryEngine {
    private SearchEnvironment _env;

    public QueryEngine(String string, URL uRL) throws Exception {
        this._env = new SearchEnvironment(string, uRL);
    }

    public void processQuery(String string, Locale locale, SearchQuery searchQuery) throws Exception {
        int n;
        int n2;
        String[] stringArray;
        int n3;
        Vector<SearchIds> vector = new Vector<SearchIds>();
        LiteMorph liteMorph = this.getMorphForLocale(locale);
        int n4 = -1;
        try {
            BreakIterator breakIterator = BreakIterator.getWordInstance(locale);
            breakIterator.setText(string);
            int n5 = breakIterator.first();
            n3 = breakIterator.next();
            while (n3 != -1) {
                int n6;
                int n7;
                String string2 = new String(string.substring(n5, n3));
                string2 = string2.trim();
                if ((string2 = string2.toLowerCase(locale)).length() > 1) {
                    ++n4;
                    n7 = this._env.fetch(string2);
                    if (n7 > 0) {
                        vector.addElement(new SearchIds(n4, n7, 0.0));
                    }
                    if (liteMorph != null) {
                        stringArray = liteMorph.variantsOf(string2);
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            n6 = this._env.fetch(stringArray[n2]);
                            if (n6 <= 0) continue;
                            vector.addElement(new SearchIds(n4, n6, 0.1));
                        }
                    }
                } else if (string2.length() == 1 && ((n7 = Character.getType(string2.charAt(0))) == 9 || n7 == 10 || n7 == 2 || n7 == 5 || n7 == 11 || n7 == 3 || n7 == 0 || n7 == 1)) {
                    ++n4;
                    int n8 = this._env.fetch(string2);
                    if (n8 > 0) {
                        vector.addElement(new SearchIds(n4, n8, 0.0));
                    }
                    if (liteMorph != null) {
                        String[] stringArray2 = liteMorph.variantsOf(string2);
                        for (n6 = 0; n6 < stringArray2.length; ++n6) {
                            n = this._env.fetch(stringArray2[n6]);
                            if (n <= 0) continue;
                            vector.addElement(new SearchIds(n4, n, 0.1));
                        }
                    }
                }
                n5 = n3;
                n3 = breakIterator.next();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        n3 = vector.size();
        Search search = new Search(this._env, n4 + 1);
        stringArray = new IntegerArray();
        for (n2 = 0; n2 < n3; ++n2) {
            SearchIds searchIds = (SearchIds)vector.elementAt(n2);
            search.addTerm(searchIds.col, searchIds.concept, searchIds.score, 0);
            stringArray.clear();
            this._env.getChildren(searchIds.concept, (IntegerArray)stringArray);
            if (stringArray.cardinality() <= 0) continue;
            for (n = 0; n < stringArray.cardinality(); ++n) {
                search.addTerm(searchIds.col, stringArray.at(n), searchIds.score + 0.1, 0);
                this._env.getChildren(stringArray.at(n), (IntegerArray)stringArray);
            }
        }
        search.startSearch(searchQuery);
    }

    private LiteMorph getMorphForLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        Enumeration enumeration = HelpUtilities.getCandidates(locale);
        String string = "com.sun.java.help.search.LiteMorph";
        ClassLoader classLoader = QueryEngine.class.getClassLoader();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = new String(string + string2);
            try {
                Class<?> clazz = classLoader == null ? Class.forName(string3) : classLoader.loadClass(string3);
                Method method = clazz.getMethod("getMorph", null);
                return (LiteMorph)method.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in), 1);
            String string2 = new String(stringArray[0]);
            QueryEngine queryEngine = new QueryEngine(string2, null);
            System.out.println("initialized; enter query");
            while (!(string = bufferedReader.readLine()).equals(".")) {
                long l = System.currentTimeMillis();
                queryEngine.processQuery(string, Locale.getDefault(), null);
                System.out.println(System.currentTimeMillis() - l + " msec search");
                System.out.println("enter next query or . to quit");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class SearchIds {
        public int col;
        public int concept;
        public double score;

        public SearchIds(int n, int n2, double d) {
            this.col = n;
            this.concept = n2;
            this.score = d;
        }

        public String toString() {
            return "col=" + this.col + " concept=" + this.concept + " score=" + this.score;
        }
    }
}

