/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.MainWindow;
import javax.help.Map;
import javax.help.Popup;
import javax.help.Presentation;
import javax.help.SwingHelpUtilities;
import javax.help.UnsupportedOperationException;
import javax.help.WindowPresentation;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class DefaultHelpBroker
implements HelpBroker,
KeyListener {
    private MainWindow mw = null;
    private HelpSet helpKeyHS = null;
    private String helpKeyPresentation = null;
    private String helpKeyPresentationName = null;
    protected ActionListener displayHelpFromFocus;
    protected ActionListener displayHelpFromSource;
    private static final boolean debug = false;

    public DefaultHelpBroker(HelpSet helpSet) {
        this.mw = (MainWindow)MainWindow.getPresentation(helpSet, null);
    }

    public DefaultHelpBroker() {
        this.mw = (MainWindow)MainWindow.getPresentation(null, null);
    }

    public WindowPresentation getWindowPresentation() {
        return this.mw;
    }

    @Override
    public HelpSet getHelpSet() {
        return this.mw.getHelpSet();
    }

    @Override
    public void setHelpSet(HelpSet helpSet) {
        DefaultHelpBroker.debug("setHelpSet");
        this.mw.setHelpSet(helpSet);
    }

    @Override
    public void setHelpSetPresentation(HelpSet.Presentation presentation) {
        DefaultHelpBroker.debug("setHelpSetPresentation");
        this.mw.setHelpSetPresentation(presentation);
    }

    @Override
    public Locale getLocale() {
        return this.mw.getLocale();
    }

    @Override
    public void setLocale(Locale locale) {
        this.mw.setLocale(locale);
    }

    @Override
    public Font getFont() {
        return this.mw.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.mw.setFont(font);
    }

    @Override
    public void setCurrentView(String string) {
        this.mw.setCurrentView(string);
    }

    @Override
    public String getCurrentView() {
        return this.mw.getCurrentView();
    }

    @Override
    public void initPresentation() {
        this.mw.createHelpWindow();
    }

    @Override
    public void setDisplayed(boolean bl) {
        DefaultHelpBroker.debug("setDisplayed");
        this.mw.setDisplayed(bl);
    }

    @Override
    public boolean isDisplayed() {
        return this.mw.isDisplayed();
    }

    @Override
    public void setLocation(Point point) {
        this.mw.setLocation(point);
    }

    @Override
    public Point getLocation() {
        return this.mw.getLocation();
    }

    @Override
    public void setSize(Dimension dimension) {
        this.mw.setSize(dimension);
    }

    @Override
    public Dimension getSize() throws UnsupportedOperationException {
        return this.mw.getSize();
    }

    @Override
    public void setScreen(int n) {
        this.mw.setScreen(n);
    }

    @Override
    public int getScreen() throws UnsupportedOperationException {
        return this.mw.getScreen();
    }

    @Override
    public void setViewDisplayed(boolean bl) {
        this.mw.setViewDisplayed(bl);
    }

    @Override
    public boolean isViewDisplayed() {
        return this.mw.isViewDisplayed();
    }

    @Override
    public void showID(String string, String string2, String string3) throws BadIDException {
        DefaultHelpBroker.debug("showID - string");
        Presentation presentation = this.getPresentation(string2, string3);
        if (presentation != null) {
            presentation.setCurrentID(string);
            presentation.setDisplayed(true);
        }
    }

    @Override
    public void showID(Map.ID iD, String string, String string2) throws InvalidHelpSetContextException {
        DefaultHelpBroker.debug("showID - ID");
        Presentation presentation = this.getPresentation(string, string2);
        if (presentation != null) {
            presentation.setCurrentID(iD);
            presentation.setDisplayed(true);
        }
    }

    private Presentation getPresentation(String string, String string2) {
        Presentation presentation;
        HelpSet helpSet = this.mw.getHelpSet();
        if (helpSet == null) {
            return null;
        }
        Class[] classArray = new Class[]{HelpSet.class, String.class};
        Object[] objectArray = new Object[]{helpSet, string2};
        try {
            ClassLoader classLoader = helpSet.getLoader();
            Class<?> clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            Method method = clazz.getMethod("getPresentation", classArray);
            presentation = (Presentation)method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(string + "presentation  invalid");
        }
        catch (Exception exception) {
            throw new RuntimeException("error invoking presentation");
        }
        if (presentation == null) {
            return null;
        }
        if (presentation instanceof Popup) {
            return null;
        }
        return presentation;
    }

    @Override
    public void setCurrentID(String string) throws BadIDException {
        DefaultHelpBroker.debug("setCurrentID - string");
        this.mw.setCurrentID(string);
    }

    @Override
    public void setCurrentID(Map.ID iD) throws InvalidHelpSetContextException {
        DefaultHelpBroker.debug("setCurrentID - ID");
        this.mw.setCurrentID(iD);
    }

    @Override
    public Map.ID getCurrentID() {
        return this.mw.getCurrentID();
    }

    @Override
    public void setCurrentURL(URL uRL) {
        DefaultHelpBroker.debug("setCurrentURL");
        this.mw.setCurrentURL(uRL);
    }

    @Override
    public URL getCurrentURL() {
        return this.mw.getCurrentURL();
    }

    @Override
    public void enableHelpKey(Component component, String string, HelpSet helpSet) {
        this.enableHelpKey(component, string, helpSet, null, null);
    }

    @Override
    public void enableHelpKey(Component component, String string, HelpSet helpSet, String string2, String string3) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        if (string2 != null && helpSet == null) {
            throw new IllegalArgumentException("hs");
        }
        CSH.setHelpIDString(component, string);
        if (helpSet != null) {
            CSH.setHelpSet(component, helpSet);
        }
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            ActionListener actionListener = null;
            actionListener = string2 == null ? this.getDisplayHelpFromFocus() : new CSH.DisplayHelpFromFocus(helpSet, string2, string3);
            jComponent.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(156, 0), 1);
            jComponent.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(112, 0), 1);
        } else {
            this.helpKeyHS = helpSet;
            this.helpKeyPresentation = string2;
            this.helpKeyPresentationName = string3;
            component.addKeyListener(this);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 112 || n == 156) {
            ActionListener actionListener = null;
            actionListener = this.helpKeyHS != null ? new CSH.DisplayHelpFromFocus(this.helpKeyHS, this.helpKeyPresentation, this.helpKeyPresentationName) : this.getDisplayHelpFromFocus();
            actionListener.actionPerformed(new ActionEvent(keyEvent.getComponent(), 1001, null));
        }
    }

    @Override
    public void enableHelp(Component component, String string, HelpSet helpSet) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(component, string);
        if (helpSet != null) {
            CSH.setHelpSet(component, helpSet);
        }
    }

    @Override
    public void enableHelp(MenuItem menuItem, String string, HelpSet helpSet) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(menuItem, string);
        if (helpSet != null) {
            CSH.setHelpSet(menuItem, helpSet);
        }
    }

    @Override
    public void enableHelpOnButton(Component component, String string, HelpSet helpSet) {
        if (!(component instanceof AbstractButton) && !(component instanceof Button)) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(component, string);
        if (helpSet != null) {
            CSH.setHelpSet(component, helpSet);
        }
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.addActionListener(this.getDisplayHelpFromSource());
        } else if (component instanceof Button) {
            Button button = (Button)component;
            button.addActionListener(this.getDisplayHelpFromSource());
        }
    }

    @Override
    public void enableHelpOnButton(MenuItem menuItem, String string, HelpSet helpSet) {
        if (menuItem == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(menuItem, string);
        if (helpSet != null) {
            CSH.setHelpSet(menuItem, helpSet);
        }
        menuItem.addActionListener(this.getDisplayHelpFromSource());
    }

    @Override
    public void enableHelpOnButton(Object object, String string, HelpSet helpSet, String string2, String string3) {
        if (!(object instanceof AbstractButton || object instanceof Button || object instanceof MenuItem)) {
            throw new IllegalArgumentException("Invalid Object");
        }
        if (string == null) {
            throw new NullPointerException("id");
        }
        if (object instanceof AbstractButton || object instanceof Button) {
            CSH.setHelpIDString((Component)object, string);
            if (helpSet != null) {
                CSH.setHelpSet((Component)object, helpSet);
            }
        } else {
            CSH.setHelpIDString((MenuItem)object, string);
            if (helpSet != null) {
                CSH.setHelpSet((MenuItem)object, helpSet);
            }
        }
        if (string2 == null) {
            if (object instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)object;
                abstractButton.addActionListener(this.getDisplayHelpFromSource());
            } else if (object instanceof Button) {
                Button button = (Button)object;
                button.addActionListener(this.getDisplayHelpFromSource());
            } else if (object instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)object;
                menuItem.addActionListener(this.getDisplayHelpFromSource());
            }
        } else if (object instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)object;
            abstractButton.addActionListener(new CSH.DisplayHelpFromSource(helpSet, string2, string3));
        } else if (object instanceof Button) {
            Button button = (Button)object;
            button.addActionListener(new CSH.DisplayHelpFromSource(helpSet, string2, string3));
        } else if (object instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)object;
            menuItem.addActionListener(new CSH.DisplayHelpFromSource(helpSet, string2, string3));
        }
    }

    protected ActionListener getDisplayHelpFromFocus() {
        if (this.displayHelpFromFocus == null) {
            this.displayHelpFromFocus = new CSH.DisplayHelpFromFocus(this);
        }
        return this.displayHelpFromFocus;
    }

    protected ActionListener getDisplayHelpFromSource() {
        if (this.displayHelpFromSource == null) {
            this.displayHelpFromSource = new CSH.DisplayHelpFromSource(this);
        }
        return this.displayHelpFromSource;
    }

    public void setActivationObject(Object object) {
        this.mw.setActivationObject(object);
    }

    public void setActivationWindow(Window window) {
        this.mw.setActivationWindow(window);
    }

    private static void debug(Object object) {
    }

    static {
        SwingHelpUtilities.installLookAndFeelDefaults();
    }
}

