/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal;

import java.io.IOException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import jdk.management.resource.ResourceId;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

public class CompletionHandlerWrapper<V, A>
implements CompletionHandler<V, A> {
    private final CompletionHandler<V, ? super A> handler;
    private final ResourceId id;
    private final ResourceRequest ra;
    private final long approved;
    private Object clientChannel;

    public CompletionHandlerWrapper(CompletionHandler<V, ? super A> completionHandler, ResourceId resourceId, ResourceRequest resourceRequest, long l) {
        this.handler = completionHandler;
        this.id = resourceId;
        this.ra = resourceRequest;
        this.approved = l;
    }

    public CompletionHandlerWrapper(CompletionHandler<V, ? super A> completionHandler) {
        this(completionHandler, null, null, 0L);
    }

    public CompletionHandlerWrapper(CompletionHandler<V, ? super A> completionHandler, Object object) {
        this(completionHandler, null, null, 0L);
        this.clientChannel = object;
    }

    @Override
    public void completed(V v, A a) {
        if (v instanceof Number) {
            int n = ((Number)v).intValue();
            if (n == -1) {
                this.ra.request(-this.approved, this.id);
            } else {
                this.ra.request(-(this.approved - (long)n), this.id);
            }
        } else if (v instanceof AsynchronousSocketChannel || this.clientChannel != null) {
            AsynchronousSocketChannel asynchronousSocketChannel = v != null ? (AsynchronousSocketChannel)v : (AsynchronousSocketChannel)this.clientChannel;
            ResourceIdImpl resourceIdImpl = null;
            try {
                resourceIdImpl = ResourceIdImpl.of(asynchronousSocketChannel.getLocalAddress());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ResourceRequest resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(asynchronousSocketChannel);
            long l = 0L;
            ResourceRequestDeniedException resourceRequestDeniedException = null;
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    resourceRequestDeniedException = new ResourceRequestDeniedException("Resource limited: too many open server socket channels");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException2) {
                resourceRequestDeniedException = resourceRequestDeniedException2;
            }
            if (resourceRequestDeniedException == null) {
                resourceRequest.request(-(l - 1L), resourceIdImpl);
            } else {
                resourceRequest.request(-l, resourceIdImpl);
                try {
                    asynchronousSocketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.handler != null) {
                    this.handler.failed(resourceRequestDeniedException, a);
                }
                return;
            }
        }
        if (this.handler != null) {
            this.handler.completed(v, a);
        }
    }

    @Override
    public void failed(Throwable throwable, A a) {
        if (this.ra != null && this.id != null) {
            this.ra.request(-this.approved, this.id);
        }
        if (this.handler != null) {
            this.handler.failed(throwable, a);
        }
    }
}

