/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.application.PlatformImpl;
import java.awt.AlphaComposite;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javax.swing.SwingUtilities;
import sun.awt.AWTAccessor;
import sun.awt.FwDispatcher;
import sun.awt.image.IntegerComponentRaster;

public class SwingFXUtils {
    private static final Set<Object> eventLoopKeys = new HashSet<Object>();

    private SwingFXUtils() {
    }

    public static WritableImage toFXImage(BufferedImage object, WritableImage writableImage) {
        int[] nArray;
        Object object2;
        Object object3;
        int n = ((BufferedImage)object).getWidth();
        int n2 = ((BufferedImage)object).getHeight();
        switch (((BufferedImage)object).getType()) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                object3 = new BufferedImage(n, n2, 3);
                object2 = ((BufferedImage)object3).createGraphics();
                ((Graphics)object2).drawImage((Image)object, 0, 0, null);
                ((Graphics)object2).dispose();
                object = object3;
            }
        }
        if (writableImage != null) {
            int n3 = (int)writableImage.getWidth();
            int n4 = (int)writableImage.getHeight();
            if (n3 < n || n4 < n2) {
                writableImage = null;
            } else if (n < n3 || n2 < n4) {
                nArray = new int[n3];
                PixelWriter pixelWriter = writableImage.getPixelWriter();
                WritablePixelFormat<IntBuffer> writablePixelFormat = PixelFormat.getIntArgbPreInstance();
                if (n < n3) {
                    pixelWriter.setPixels(n, 0, n3 - n, n2, writablePixelFormat, nArray, 0, 0);
                }
                if (n2 < n4) {
                    pixelWriter.setPixels(0, n2, n3, n4 - n2, writablePixelFormat, nArray, 0, 0);
                }
            }
        }
        if (writableImage == null) {
            writableImage = new WritableImage(n, n2);
        }
        object3 = writableImage.getPixelWriter();
        object2 = (IntegerComponentRaster)((BufferedImage)object).getRaster();
        nArray = ((IntegerComponentRaster)object2).getDataStorage();
        int n5 = ((IntegerComponentRaster)object2).getDataOffset(0);
        int n6 = ((IntegerComponentRaster)object2).getScanlineStride();
        WritablePixelFormat<IntBuffer> writablePixelFormat = ((BufferedImage)object).isAlphaPremultiplied() ? PixelFormat.getIntArgbPreInstance() : PixelFormat.getIntArgbInstance();
        object3.setPixels(0, 0, n, n2, writablePixelFormat, nArray, n5, n6);
        return writableImage;
    }

    private static int getBestBufferedImageType(PixelFormat<?> pixelFormat, BufferedImage bufferedImage) {
        int n;
        if (bufferedImage != null && ((n = bufferedImage.getType()) == 2 || n == 3)) {
            return n;
        }
        switch (pixelFormat.getType()) {
            default: {
                return 3;
            }
            case BYTE_BGRA: 
            case INT_ARGB: {
                return 2;
            }
            case BYTE_RGB: {
                return 1;
            }
            case BYTE_INDEXED: 
        }
        return pixelFormat.isPremultiplied() ? 3 : 2;
    }

    private static WritablePixelFormat<IntBuffer> getAssociatedPixelFormat(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 1: 
            case 3: {
                return PixelFormat.getIntArgbPreInstance();
            }
            case 2: {
                return PixelFormat.getIntArgbInstance();
            }
        }
        throw new InternalError("Failed to validate BufferedImage type");
    }

    public static BufferedImage fromFXImage(javafx.scene.image.Image image, BufferedImage bufferedImage) {
        int n;
        PixelReader pixelReader = image.getPixelReader();
        if (pixelReader == null) {
            return null;
        }
        int n2 = (int)image.getWidth();
        int n3 = (int)image.getHeight();
        int n4 = SwingFXUtils.getBestBufferedImageType(pixelReader.getPixelFormat(), bufferedImage);
        if (bufferedImage != null) {
            int n5 = bufferedImage.getWidth();
            n = bufferedImage.getHeight();
            if (n5 < n2 || n < n3 || bufferedImage.getType() != n4) {
                bufferedImage = null;
            } else if (n2 < n5 || n3 < n) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setComposite(AlphaComposite.Clear);
                graphics2D.fillRect(0, 0, n5, n);
                graphics2D.dispose();
            }
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(n2, n3, n4);
        }
        IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)bufferedImage.getRaster();
        n = integerComponentRaster.getDataOffset(0);
        int n6 = integerComponentRaster.getScanlineStride();
        int[] nArray = integerComponentRaster.getDataStorage();
        WritablePixelFormat<IntBuffer> writablePixelFormat = SwingFXUtils.getAssociatedPixelFormat(bufferedImage);
        pixelReader.getPixels(0, 0, n2, n3, writablePixelFormat, nArray, n, n6);
        return bufferedImage;
    }

    static void runOnFxThread(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater(runnable);
        }
    }

    static void runOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    static void runOnEDTAndWait(Object object, Runnable runnable) {
        com.sun.javafx.tk.Toolkit.getToolkit().checkFxUserThread();
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            eventLoopKeys.add(object);
            SwingUtilities.invokeLater(runnable);
            com.sun.javafx.tk.Toolkit.getToolkit().enterNestedEventLoop(object);
        }
    }

    static void leaveFXNestedLoop(Object object) {
        if (!eventLoopKeys.contains(object)) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            com.sun.javafx.tk.Toolkit.getToolkit().exitNestedEventLoop(object, null);
        } else {
            Platform.runLater(() -> com.sun.javafx.tk.Toolkit.getToolkit().exitNestedEventLoop(object, null));
        }
        eventLoopKeys.remove(object);
    }

    private static EventQueue getEventQueue() {
        return AccessController.doPrivileged(() -> Toolkit.getDefaultToolkit().getSystemEventQueue());
    }

    private static void installFwEventQueue() {
        AWTAccessor.getEventQueueAccessor().setFwDispatcher(SwingFXUtils.getEventQueue(), new FXDispatcher());
    }

    private static void removeFwEventQueue() {
        AWTAccessor.getEventQueueAccessor().setFwDispatcher(SwingFXUtils.getEventQueue(), null);
    }

    private static class FXDispatcher
    implements FwDispatcher {
        private FXDispatcher() {
        }

        @Override
        public boolean isDispatchThread() {
            return Platform.isFxApplicationThread();
        }

        @Override
        public void scheduleDispatch(Runnable runnable) {
            Platform.runLater(runnable);
        }

        @Override
        public SecondaryLoop createSecondaryLoop() {
            return new FwSecondaryLoop();
        }
    }

    private static class FwSecondaryLoop
    implements SecondaryLoop {
        private final AtomicBoolean isRunning = new AtomicBoolean(false);

        private FwSecondaryLoop() {
        }

        @Override
        public boolean enter() {
            if (this.isRunning.compareAndSet(false, true)) {
                PlatformImpl.runAndWait(() -> com.sun.javafx.tk.Toolkit.getToolkit().enterNestedEventLoop(this));
                return true;
            }
            return false;
        }

        @Override
        public boolean exit() {
            if (this.isRunning.compareAndSet(true, false)) {
                PlatformImpl.runAndWait(() -> com.sun.javafx.tk.Toolkit.getToolkit().exitNestedEventLoop(this, null));
                return true;
            }
            return false;
        }
    }
}

