/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import java.util.ArrayList;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CoreAndroid;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginManager;
import org.apache.cordova.PluginResult;
import org.json.JSONException;
import org.json.JSONObject;

public class ResumeCallback
extends CallbackContext {
    private final String TAG = "CordovaResumeCallback";
    private String serviceName;
    private PluginManager pluginManager;

    public ResumeCallback(String serviceName, PluginManager pluginManager) {
        super("resumecallback", null);
        this.serviceName = serviceName;
        this.pluginManager = pluginManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPluginResult(PluginResult pluginResult) {
        ResumeCallback resumeCallback = this;
        synchronized (resumeCallback) {
            if (this.finished) {
                LOG.w("CordovaResumeCallback", this.serviceName + " attempted to send a second callback to ResumeCallback\nResult was: " + pluginResult.getMessage());
                return;
            }
            this.finished = true;
        }
        JSONObject event = new JSONObject();
        JSONObject pluginResultObject = new JSONObject();
        try {
            pluginResultObject.put("pluginServiceName", (Object)this.serviceName);
            pluginResultObject.put("pluginStatus", (Object)PluginResult.StatusMessages[pluginResult.getStatus()]);
            event.put("action", (Object)"resume");
            event.put("pendingResult", (Object)pluginResultObject);
        }
        catch (JSONException e) {
            LOG.e("CordovaResumeCallback", "Unable to create resume object for Activity Result");
        }
        PluginResult eventResult = new PluginResult(PluginResult.Status.OK, event);
        ArrayList<PluginResult> result = new ArrayList<PluginResult>();
        result.add(eventResult);
        result.add(pluginResult);
        CoreAndroid appPlugin = (CoreAndroid)this.pluginManager.getPlugin("CoreAndroid");
        appPlugin.sendResumeEvent(new PluginResult(PluginResult.Status.OK, result));
    }
}

