/**
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.
*/
let commands = require('../src/commands')
let os = require('os')

describe('commands end-to-end', function () {
  beforeEach(function () {
    if (os.platform() === 'darwin') {
      commands.init()
    }
  })

  afterEach(function () {
  })

  it('command - showsdks', function () {
    if (os.platform() === 'darwin') {
      commands.showsdks({ 'no-output': true })
    }
  })

  it('command - showdevicetypes', function () {
    if (os.platform() === 'darwin') {
      commands.showdevicetypes({ 'no-output': true })
    }
  })

  it('command - launch', function () {
    // TODO: - fail();
    // TODO: add a fixture Simulator .app to launch
  })

  it('command - install', function () {
    // TODO: - fail();
    // TODO: add a fixture Simulator .app to install
  })

  it('command - start', function () {
    let devicetypeid = 'iPhone-6'
    if (os.platform() === 'darwin') {
      commands.start({ 'devicetypeid': devicetypeid })
    }
  })
})
